# 画面設計書 33-インストール中断エラー画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「インストール中断エラー画面」の画面設計書である。本画面は、インストールプロセスのいずれかのステップが中断（失敗）した場合に表示されるエラーダイアログであり、インストーラの再起動または終了をユーザに選択させる。

### 本画面の処理概要

本画面では、インストール中に発生したエラーにより処理が中断された場合に、ユーザにリカバリ手段を提供する。Restart を選択するとインストーラが最初から再起動され、Exit を選択するとインストーラが終了する。

**業務上の目的・背景**：FreeBSD のインストールプロセスは複数のステップ（パーティション設定、ファイルダウンロード、展開、ブートローダ設定、rootパスワード設定、各種設定保存等）で構成されており、いずれかのステップが失敗した場合にユーザが安全にリカバリできる手段が必要である。本画面は、`error()` 関数として `auto` スクリプト内に実装されており、各ステップの失敗時に SIGINT ハンドラまたは直接呼び出しにより起動される。これにより、ユーザは問題の原因を確認した上でインストールのやり直しまたは終了を選択できる。

**画面へのアクセス方法**：本画面は以下の契機で表示される。
- 各インストールステップが失敗した場合（`|| error "エラーメッセージ"` パターン）
- ユーザが Ctrl+C を押下し SIGINT が発生した場合（`trap error SIGINT` が有効な区間）
- `auto` スクリプト内の `error()` 関数が呼び出されるすべての箇所

**主要な操作・処理内容**：
1. マウント済みファイルシステムがあれば `bsdinstall umount` でアンマウントする。
2. エラーメッセージと中断確認ダイアログ（Yes/No）を表示する。
3. Restart を選択すると、環境変数を復元して `auto` スクリプトを `exec` で再実行する。
4. Exit を選択すると `exit 1` でインストーラを終了する。

**画面遷移**：
- 遷移元：インストールプロセス中の任意のステップ（エラー発生時）
- 遷移先（Restart）：インストーラ起動画面（auto スクリプトの先頭に戻る）
- 遷移先（Exit）：インストーラ終了

**権限による表示制御**：本画面はインストーラ内で動作するため、すべての操作は root 権限で実行される。権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | インストールステップ中断時のリスタート/終了選択ダイアログ表示 |

## 画面種別

エラー確認（Yes/No ダイアログ）

## URL/ルーティング

シェルスクリプト: `usr.sbin/bsdinstall/scripts/auto`（行79-105: `error()` 関数）
呼び出し方法: `error()` 関数が各インストールステップの失敗時に呼び出される

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | デフォルト値 | 説明 |
|--------|--------|-----|------|-------------|------|
| Restart/Exit 選択 | 入力 | ボタン選択 | はい | なし | インストーラ再起動または終了の選択 |
| エラーメッセージ | 入力（関数引数） | 文字列 | いいえ | なし | error() 関数の第1引数。追加のエラー説明文 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| タイトル | テキスト | "Abort" |
| バックタイトル | テキスト | "FreeBSD Installer"（$OSNAME に応じて変動） |
| エラーメッセージ（オプション） | テキスト | error() の第1引数として渡されたメッセージ（存在する場合） |
| 中断確認メッセージ | テキスト | "An installation step has been aborted. Would you like to restart the installation or exit the installer?" |
| Restart ボタン | ボタン | インストーラを再起動する（Yes ラベルとして表示） |
| Exit ボタン | ボタン | インストーラを終了する（No ラベルとして表示） |

## イベント仕様

### 1-Restart ボタン押下

1. `$DIALOG --yesno` が `$DIALOG_OK`（0）を返す（行92-98）。
2. `environment_restore()` 関数により、ユーザ定義の環境変数を初期値に復元する（行100）。復元対象は `BSDINSTALL_DISTSITE`、`DISTRIBUTIONS`、`WORKAROUND_GPTACTIVE`、`WORKAROUND_LENOVO`、`ZFSBOOT_PARTITION_SCHEME`（行42）。
3. `exec $0` により `auto` スクリプトを再実行する（行101）。`exec` によりプロセスが置換され、元のプロセスには戻らない。

### 2-Exit ボタン押下

1. `$DIALOG --yesno` が非ゼロを返す（行92-98）。
2. `exit 1` でインストーラが終了する（行104）。

### 3-error() 関数呼び出し時の前処理

1. `$PATH_FSTAB` ファイルが存在する場合、`bsdinstall umount` でマウント済みファイルシステムをアンマウントする（行86）。
2. エラーメッセージの構築: 引数が指定されている場合は「引数メッセージ + 改行 + 中断確認メッセージ」、未指定の場合は「中断確認メッセージのみ」（行83）。
3. `f_dialog_buttonbox_size` でダイアログサイズを自動計算する（行89-90）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| error() 呼び出し時 | マウント済みファイルシステム | umount | $PATH_FSTAB が存在する場合にアンマウント処理 |
| Restart 選択時 | 環境変数 | 復元 | user_env_vars のリストに含まれる環境変数を初期値に復元 |

### テーブル別更新項目詳細

該当なし（RDBMSは使用しない）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| msg_abort | タイトル | "Abort" | 常時 |
| msg_an_installation_step_has_been_aborted | エラー確認 | "An installation step has been aborted. Would you like to restart the installation or exit the installer?" | 常時 |
| msg_restart | ボタンラベル | "Restart" | 常時（Yesラベル） |
| msg_exit | ボタンラベル | "Exit" | 常時（Noラベル） |
| （error()引数） | エラー詳細 | 各呼び出し元から渡されるエラーメッセージ | error()に引数が指定された場合 |

### error() の呼び出し箇所とエラーメッセージ一覧

| 呼び出し箇所（行番号） | エラーメッセージ | 発生条件 |
|----------------------|--------------|---------|
| 行198 | "Set hostname failed" | ホスト名設定失敗 |
| 行228,235 | （メッセージなし） | ネットワーク設定失敗（pkgbase時） |
| 行266 | （メッセージなし） | ネットワーク設定失敗（distset時） |
| 行397 | "ZFS setup failed" | ZFS設定失敗 |
| 行398 | "Failed to mount filesystem" | ファイルシステムマウント失敗（ZFS） |
| 行401 | "Partitioning error" | UFS自動パーティション失敗 |
| 行402 | "Failed to mount filesystem" | ファイルシステムマウント失敗（UFS） |
| 行408 | "Failed to mount auxiliary filesystems" | 補助ファイルシステムマウント失敗 |
| 行413-415 | "Partitioning error" | 手動パーティション失敗 |
| 行417 | "Failed to mount filesystem" | ファイルシステムマウント失敗（手動） |
| 行420 | "Unknown partitioning mode" | 不明なパーティションモード |
| 行435 | "Could not fetch remote distributions" | リモート配布ファイル取得失敗 |
| 行437 | "Distribution checksum failed" | チェックサム検証失敗 |
| 行438 | "Distribution extract failed" | 配布ファイル展開失敗 |
| 行427 | "Installation of base system packages failed" | pkgbaseインストール失敗 |
| 行442 | "Failed to configure bootloader" | ブートローダ設定失敗 |
| 行446 | "Could not set root password" | rootパスワード設定失敗 |
| 行466 | "Failed to save config" | 設定保存失敗 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| $PATH_FSTAB が存在しない | umount 処理をスキップし、ダイアログ表示に進む（行86） |
| Restart 後の再実行でも同じエラーが発生 | 再度 error() が呼ばれ、同じダイアログが表示される（無限ループの可能性あり） |
| SIGINT による呼び出し | trap error SIGINT が設定されている区間（行197以降、行448で一時解除、行465で再設定）で Ctrl+C を押下した場合に error() が引数なしで呼ばれる |

## 備考

- `error()` 関数は `auto` スクリプト内に定義されたグローバル関数であり、インストーラの全ステップで共通のエラーハンドリングとして使用される。
- Restart 選択時の `exec $0` は、現在のプロセスを `auto` スクリプトの再実行で置換する。これにより、インストーラは完全にリセットされた状態で再開始する。
- `environment_restore()` により、ユーザの初期設定が復元される。これは `environment_save()` で保存された値を `ORIG_` プレフィックス付き変数から復元する仕組みである（行153-158, 165-169）。
- SIGINT トラップの設定区間は以下の通り：
  - 行194 `trap true SIGINT`: キーマップ選択は Ctrl+C で安全にスキップ可能
  - 行197 `trap error SIGINT`: ホスト名設定以降は error() にトラップ
  - 行448 `trap true SIGINT`: オプション設定区間（netconfig, time, services, hardening, firmware, adduser）は Ctrl+C で安全にスキップ可能
  - 行465 `trap error SIGINT`: config 保存は error() にトラップ
- `$DIALOG` 変数は bsdconfig の dialog.subr により設定される（通常は bsddialog）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

error() 関数が使用する変数とメッセージ定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行42: `user_env_vars` 変数 -- Restart時に復元される環境変数のリスト |
| 1-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行49-50: `msg_abort`, `msg_an_installation_step_has_been_aborted` -- ダイアログメッセージ定義 |
| 1-3 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行57,65-66: `msg_exit`, `msg_restart` -- ボタンラベル定義 |
| 1-4 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行48: `hline_arrows_tab_space_enter` -- ヒントライン定義 |

**読解のコツ**: `auto` スクリプトの GLOBALS セクション（行36-69）に全てのメッセージ文字列が定義されている。`error()` 関数はこれらのグローバル変数を参照する。

#### Step 2: error() 関数の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行79-105: `error()` 関数の全体定義 |
| 2-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行81-84: ローカル変数の初期化。引数ありの場合のメッセージ構築ロジック |
| 2-3 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行86: `$PATH_FSTAB` 存在チェックと umount 処理 |
| 2-4 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行88-98: ダイアログサイズ計算と表示 |
| 2-5 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行100-104: Restart/Exit の分岐処理 |

**主要処理フロー**:
1. **行81-84**: ダイアログのタイトル・バックタイトル・プロンプト・ヒントラインを設定。引数が指定されている場合、`${1:+$1\n\n}` によりエラーメッセージを先頭に追加。
2. **行86**: `$PATH_FSTAB` が存在すれば `bsdinstall umount` を実行。
3. **行88-90**: `f_dialog_buttonbox_size` でダイアログの高さと幅を計算。
4. **行92-98**: `$DIALOG --yesno` で Restart/Exit ダイアログを表示。`--yes-label "$msg_restart"`, `--no-label "$msg_exit"` でボタンラベルをカスタマイズ。
5. **行100**: Restart 選択時: `environment_restore` で環境変数を復元。
6. **行101**: `exec $0` で auto スクリプトを再実行（プロセス置換）。
7. **行104**: Exit 選択時: `exit 1` でインストーラを終了。

#### Step 3: 環境変数の保存・復元メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行165-169: `environment_save()` -- スクリプト開始時に環境変数を `ORIG_` 付きで保存 |
| 3-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行153-158: `environment_restore()` -- Restart時に `ORIG_` から復元 |
| 3-3 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行176: `environment_save` の呼び出し箇所（MAINセクション冒頭） |

#### Step 4: SIGINT トラップの設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行194: `trap true SIGINT` -- オプション区間（キーマップ）開始 |
| 4-2 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行197: `trap error SIGINT` -- 必須区間開始（ホスト名以降） |
| 4-3 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行448: `trap true SIGINT` -- オプション区間開始（netconfig～adduser） |
| 4-4 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行465: `trap error SIGINT` -- 必須区間開始（config保存） |

#### Step 5: error() の呼び出し箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 行198,228,235,266,397-398,401-402,408,413-415,417,420,427,435,437-438,442,446,466: error() の全呼び出し箇所 |

### プログラム呼び出し階層図

```
auto (インストーラメインスクリプト)
    |
    +-- environment_save() (行176) -- 初期環境変数の保存
    +-- trap error SIGINT (行197) -- SIGINTハンドラ設定
    |
    +-- 各インストールステップ || error "メッセージ"
    |       |
    |       +-- (失敗時) error()
    |               |
    |               +-- bsdinstall umount (行86) -- マウント解除
    |               +-- f_dialog_buttonbox_size (行89-90) -- サイズ計算
    |               +-- $DIALOG --yesno (行92-98) -- ダイアログ表示
    |               |
    |               +-- (Restart)
    |               |       +-- environment_restore() (行100) -- 環境変数復元
    |               |       +-- exec $0 (行101) -- スクリプト再実行
    |               |
    |               +-- (Exit)
    |                       +-- exit 1 (行104)
    |
    +-- trap error SIGINT 有効区間での Ctrl+C
            +-- error() (引数なし)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

エラー発生
(ステップ失敗/SIGINT) -------> error($msg) -------> エラーダイアログ表示
                               |
                               +-- $PATH_FSTAB ----> bsdinstall umount -> ファイルシステム解放
                               |   (存在チェック)
                               |
ユーザ選択 (Restart/Exit) ---> 分岐処理
                               |
                               +-- (Restart)
                               |       |
                               |       +-- ORIG_* 変数 -> environment_restore() -> 環境変数復元
                               |       +-- exec $0 ---------------------------> auto再実行
                               |
                               +-- (Exit)
                                       +-- exit 1 ---------------------------> インストーラ終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | error() 関数を含むインストーラメインスクリプト（行79-105） |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通ライブラリ（f_dprintf, f_isset等） |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ操作ライブラリ（$DIALOG変数, f_dialog_buttonbox_size等） |
