# 画面設計書 4-ネットワーク/オフラインインストール選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「ネットワーク/オフラインインストール選択画面」の設計仕様を記述する。本画面はpkgbase選択時に表示され、パッケージをネットワーク経由で取得するか、インストールメディアのローカルパッケージを使用するかを選択する。

### 本画面の処理概要

本画面は、pkgbaseによるインストール時にパッケージの取得元を選択するTUI画面である。ネットワークインストール（最新パッケージを取得）かオフラインインストール（メディア内のパッケージを使用）かを選択する。

**業務上の目的・背景**：pkgbaseインストールでは、パッケージをインターネットから取得することで最新のバージョンをインストールできるが、ネットワークが利用できない環境ではインストールメディアに含まれるパッケージを使用する必要がある。本画面はこの選択をユーザに提供し、環境に応じた適切なインストール方法を決定させる。

**画面へのアクセス方法**：インストール種別選択画面でPackages（pkgbase）を選択し、かつローカルパッケージ（`/usr/freebsd-packages/repos/FreeBSD-base-offline.conf`）が利用可能な場合にのみ表示される。autoスクリプト221-230行目で制御される。ローカルパッケージが存在しない場合は、ネットワークインストールが自動選択され、本画面は表示されない（231-236行目のelseブロック）。

**主要な操作・処理内容**：
1. インストール方法の選択：Yes/Noダイアログで「Network」か「Offline (Limited Packages)」を選択する
2. ネットワーク選択時：netconfig画面に遷移してネットワーク設定を行う（228-229行目）
3. オフライン選択時：BSDINSTALL_PKG_REPOS_DIRをローカルリポジトリに設定する（226行目）

**画面遷移**：
- 遷移元：インストール種別選択画面（Packages選択時）
- 遷移先（Network選択時）：ネットワークインターフェース選択画面（netconfig）
- 遷移先（Offline選択時）：パーティションモード選択画面

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | pkgbase選択時のネットワーク/オフラインインストールモード選択処理 |
| 35 | ネットワークインタフェース管理 | 遷移先機能 | ネットワークインストール選択時のnetconfig画面への遷移 |

## 画面種別

選択（Yes/Noダイアログ形式の取得元選択画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。autoスクリプト内の222-224行目でbsddialogが呼び出される。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| 選択結果 | 出力 | ブール | Network（Yes）またはOffline（No） | - | はい |
| BSDINSTALL_PKG_REPOS_DIR | 出力 | パス | オフライン選択時のリポジトリディレクトリ | /usr/freebsd-packages/repos/ | - |
| NETCONFIG_DONE | 出力 | 文字列 | ネットワーク設定完了フラグ | "yes"（ネットワーク選択時） | - |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Network or Offline Installation" | ダイアログタイトル |
| バックタイトル | "$OSNAME Installer" | ダイアログバックタイトル |
| プロンプト | "Would you like to fetch packages from the internet or use the limited set of packages included in this installation media?" | テキスト |
| Yesボタン | "Network" | ボタン（yes-label） |
| Noボタン | "Offline (Limited Packages)" | ボタン（no-label） |

## イベント仕様

### 1-Network選択（Yesボタン）

bsddialogの戻り値が0の場合（225行目の条件が不成立）、`bsdinstall netconfig`が呼び出され（228行目）、ネットワーク設定画面に遷移する。設定完了後、NETCONFIG_DONE=yesが設定される（229行目）。

### 2-Offline選択（Noボタン）

bsddialogの戻り値が1の場合（225行目）、`BSDINSTALL_PKG_REPOS_DIR=/usr/freebsd-packages/repos/`がexportされ（226行目）、ローカルリポジトリがパッケージ取得元として設定される。ネットワーク設定はスキップされる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| Offline選択 | BSDINSTALL_PKG_REPOS_DIR環境変数 | SET | ローカルリポジトリパスを設定 |
| Network選択 | NETCONFIG_DONE変数 | SET | "yes"を設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 説明 | "Would you like to fetch packages from the internet or use the limited set of packages included in this installation media?" | HAVE_BASE_PACKAGES=yesの場合 |
| - | 情報 | "No base system packages are included in this installation media. The next few screens will allow you to configure networking." | HAVE_BASE_PACKAGESが未設定の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ローカルパッケージが存在しない場合 | 本画面は表示されず、ネットワークインストール案内メッセージが表示された後、netconfig画面に遷移する（231-236行目） |
| bsdinstall netconfigが失敗 | error()関数が呼ばれ、リスタート/終了ダイアログが表示される（228行目） |

## 備考

- 本画面はローカルパッケージ（HAVE_BASE_PACKAGES=yes）が利用可能な場合にのみ表示される
- ローカルパッケージがない場合は「Network Installation」のmsgboxが表示された後、自動的にnetconfigに遷移する
- 本画面は単独のスクリプトではなく、autoスクリプト内に直接記述されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 200-206行目のHAVE_BASE_PACKAGES判定ロジック |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 220-236行目のpkgbase時のネットワーク/オフライン分岐 |

**主要処理フロー**:
1. **220行目**: PKGBASE==yes判定
2. **221行目**: HAVE_BASE_PACKAGES==yes判定
3. **222-224行目**: bsddialog --yesnoでNetwork/Offline選択
4. **225-226行目**: Offline選択時のBSDINSTALL_PKG_REPOS_DIR設定
5. **228-229行目**: Network選択時のnetconfig呼び出し
6. **231-236行目**: ローカルパッケージなし時のネットワークインストール案内

### プログラム呼び出し階層図

```
auto (bsdinstall起動スクリプト)
    |
    +-- [PKGBASE=yes かつ HAVE_BASE_PACKAGES=yes]
    |      +-- bsddialog --yesno (Network/Offline選択)
    |      |
    |      +-- [Network選択]
    |      |      +-- bsdinstall netconfig
    |      |      +-- NETCONFIG_DONE=yes
    |      |
    |      +-- [Offline選択]
    |             +-- export BSDINSTALL_PKG_REPOS_DIR
    |
    +-- [PKGBASE=yes かつ HAVE_BASE_PACKAGES未設定]
           +-- bsddialog --msgbox (ネットワーク案内)
           +-- bsdinstall netconfig
           +-- NETCONFIG_DONE=yes
```

### データフロー図

```
[入力]                           [処理]                         [出力]

PKGBASE=yes              -----> 条件分岐               -----> 画面表示判定
HAVE_BASE_PACKAGES       -----> 条件分岐               -----> 画面表示判定

ユーザ選択(Network)      -----> bsdinstall netconfig   -----> ネットワーク設定
                                                              NETCONFIG_DONE=yes

ユーザ選択(Offline)      -----> export設定             -----> BSDINSTALL_PKG_REPOS_DIR
                                                              =/usr/freebsd-packages/repos/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | 本画面のロジックを含むメインスクリプト |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | Network選択時に遷移するネットワーク設定スクリプト |
| FreeBSD-base-offline.conf | `/usr/freebsd-packages/repos/FreeBSD-base-offline.conf` | 設定 | ローカルパッケージリポジトリ設定（存在確認に使用） |
