# 画面設計書 5-配布セット選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「配布セット選択画面」の設計仕様を記述する。本画面はDistribution Sets方式選択時に表示され、base.txz・kernel.txz以外のオプション配布セットを選択する。

### 本画面の処理概要

本画面は、Distribution Sets方式でのインストール時にオプションの配布セットを選択するためのTUIチェックリスト画面である。MANIFESTファイルからオプション一覧を生成し、ユーザが追加インストールするコンポーネントを選択できる。

**業務上の目的・背景**：FreeBSDのDistribution Sets方式では、base.txzとkernel.txzが必須だが、その他にlib32.txz、tests.txz等のオプションコンポーネントが提供される。ユーザの用途に応じて必要なコンポーネントのみを選択インストールすることで、ディスク使用量の最適化やインストール時間の短縮を実現する。

**画面へのアクセス方法**：インストール種別選択画面でDistribution Sets（従来方式）を選択した場合に表示される。autoスクリプト238-255行目で処理される。MANIFESTファイルにオプション配布セットが存在しない場合は表示されない。

**主要な操作・処理内容**：
1. MANIFESTファイルの解析：awkコマンドでMANIFESTファイルからbase.txzとkernel.txz以外のエントリを抽出する（240行目）
2. チェックリスト表示：抽出されたオプション配布セットをbsddialogのchecklistとして表示する（245-250行目）
3. 選択の反映：ユーザが選択した配布セットがDISTRIBUTIONS変数に追加される（251-253行目）

**画面遷移**：
- 遷移元：インストール種別選択画面（Distribution Sets選択時）
- 遷移先：ネットワーク設定画面（未取得の配布ファイルがある場合）またはパーティションモード選択画面

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | パッケージ管理支援 | 主機能 | MANIFESTファイルからオプション配布セットを解析し選択するチェックリスト処理 |

## 画面種別

選択（チェックリスト形式の配布セット選択画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。autoスクリプト内の245-250行目でbsddialogが呼び出される。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| EXTRA_DISTS | 出力 | 文字列（スペース区切り） | ユーザが選択した追加配布セット名 | - | いいえ |
| DISTRIBUTIONS | 入力/出力 | 文字列（スペース区切り） | 全配布セットリスト | "base.txz kernel.txz" | - |
| DISTMENU | 内部 | 文字列 | MANIFESTから生成されたメニュー項目 | MANIFEST解析結果 | - |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Distribution Select" | ダイアログタイトル |
| バックタイトル | "$OSNAME Installer" | ダイアログバックタイトル |
| プロンプト | "Choose optional system components to install:" | テキスト |
| 配布セットリスト | MANIFESTから抽出されたオプション配布セット一覧 | チェックリスト |

## イベント仕様

### 1-配布セット選択確定

ユーザがチェックリストで配布セットを選択し確定すると、選択された各配布セット名に`.txz`サフィックスが付与され、DISTRIBUTIONS変数に追加される（251-253行目）。`--nocancel`オプションにより、キャンセルは不可。

### 2-未取得ファイルの検出

選択確定後、DISTRIBUTIONS内の各配布ファイルが`$BSDINSTALL_DISTDIR`に存在するか確認される（257-262行目）。存在しないファイルがある場合、FETCH_DISTRIBUTIONS変数に追加され、ネットワーク経由でのダウンロードが必要になる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| 配布セット選択 | DISTRIBUTIONS環境変数 | UPDATE | 選択した配布セット（.txz付き）を追加 |
| 未取得検出 | FETCH_DISTRIBUTIONS環境変数 | SET | 未取得の配布ファイル名リストを設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 説明 | "Choose optional system components to install:" | チェックリスト表示時 |
| - | 情報 | "Some installation files were not found on the boot volume..." | 未取得ファイルが検出された場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| MANIFESTにオプション配布セットが存在しない | DISTMENUが空のためチェックリストは表示されない（243行目の条件分岐） |
| MANIFESTファイル自体が存在しない | Distribution Sets方式が選択されないため、本画面に到達しない |

## 備考

- `--nocancel`オプションにより、キャンセルボタンは無効化されている
- `--separate-output`オプションにより、選択結果が改行区切りで出力される
- MANIFESTファイルのフォーマットはタブ区切りで、カラム1がファイル名、カラム5と6が説明とデフォルト値
- `.txz`拡張子はawkのsed処理で除去されて表示され（241行目）、選択後に再付与される（252行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MANIFEST | `$BSDINSTALL_DISTDIR/MANIFEST` | タブ区切りフォーマット。カラム1: ファイル名、カラム5: 説明テキスト、カラム6: デフォルト選択状態 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | auto | `usr.sbin/bsdinstall/scripts/auto` | 238-268行目のDistribution Sets処理ブロック |

**主要処理フロー**:
1. **238行目**: DISTRIBUTIONS変数に"base.txz kernel.txz"をデフォルト設定
2. **240行目**: awkでMANIFESTからbase.txzとkernel.txz以外を抽出
3. **241行目**: sedで.txz拡張子を除去
4. **243行目**: DISTMENUが空でないか確認
5. **245-250行目**: bsddialog --checklistでチェックリスト表示
6. **251-253行目**: 選択結果をDISTRIBUTIONSに追加（.txz付与）
7. **257-262行目**: 未取得ファイルの検出
8. **264-268行目**: 未取得ファイルがある場合のネットワーク設定遷移

### プログラム呼び出し階層図

```
auto (bsdinstall起動スクリプト)
    |
    +-- [Distribution Sets選択時]
         +-- DISTRIBUTIONS初期化 ("base.txz kernel.txz")
         +-- awk (MANIFEST解析)
         +-- sed (.txz除去)
         +-- bsddialog --checklist (チェックリスト表示)
         |
         +-- DISTRIBUTIONS更新 (選択結果追加)
         +-- 未取得ファイル検出ループ
         |
         +-- [未取得ファイルあり]
                +-- bsddialog --msgbox (ネットワーク案内)
                +-- bsdinstall netconfig
```

### データフロー図

```
[入力]                          [処理]                          [出力]

$BSDINSTALL_DISTDIR/       -->  awk解析                  -----> DISTMENU
  MANIFEST                       (base/kernel除外)              (メニュー項目)

DISTMENU                   -->  bsddialog --checklist    -----> EXTRA_DISTS
                                                                (ユーザ選択)

EXTRA_DISTS                -->  ループ処理               -----> DISTRIBUTIONS
                                 (.txz付与・追加)               (更新済み)

DISTRIBUTIONS              -->  ファイル存在確認         -----> FETCH_DISTRIBUTIONS
$BSDINSTALL_DISTDIR                                            (未取得リスト)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | 本画面のロジックを含むメインスクリプト |
| MANIFEST | `$BSDINSTALL_DISTDIR/MANIFEST` | データ | 配布セット情報ファイル（タブ区切り） |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | 未取得ファイルダウンロード時のネットワーク設定 |
