# 画面設計書 6-ネットワークインターフェース選択画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「ネットワークインターフェース選択画面」の設計仕様を記述する。本画面はネットワーク設定が必要な場合に表示され、利用可能なネットワークインターフェースの一覧表示とAuto/Manual設定モードの選択を行う。

### 本画面の処理概要

本画面は、ネットワーク設定の最初のステップとして、システムで利用可能なネットワークインターフェースを一覧表示し、ユーザが設定対象のインターフェースとAuto/Manualモードを選択するTUI画面である。

**業務上の目的・背景**：FreeBSDインストール時にネットワーク接続が必要な場面は多数ある（配布ファイルのダウンロード、pkgbaseパッケージの取得、ファームウェアのインストール等）。本画面はネットワーク設定の起点として、利用可能なインターフェースを自動検出し、有線・無線を区別した上でユーザに選択させる。Autoモードではdhclient/SLAACが自動使用され、Manualモードでは後続の画面で手動設定を行う。

**画面へのアクセス方法**：autoスクリプトの`bsdinstall netconfig`呼び出し（228行目、266行目、450行目等）により表示される。netconfigスクリプトがエントリーポイントとなる。

**主要な操作・処理内容**：
1. インターフェース一覧の生成：ifconfig -lでループバック以外のインターフェースを列挙し、sysctl net.wlan.devicesで無線デバイスも追加する（46-53行目）
2. インターフェース説明の取得：dev.*.%descからデバイス説明を取得してメニュー項目を構築する（63-66行目）
3. インターフェースと設定モードの選択：bsddialogのmenuダイアログで、AutoボタンとManual（Extra）ボタンを持つメニューを表示する（76-79行目）
4. 無線インターフェース判定：選択されたインターフェースが無線の場合、wlanインターフェースを作成し無線LAN設定画面に遷移する（96-106行目）

**画面遷移**：
- 遷移元：autoスクリプトの各所からbsdinstall netconfigとして呼び出される
- 遷移先（無線インターフェース選択時）：無線LAN設定画面 -> IPv4設定確認画面
- 遷移先（有線インターフェース・Autoモード）：IPv4設定確認画面（Auto引数付き）
- 遷移先（有線インターフェース・Manualモード）：IPv4設定確認画面（Manual）
- キャンセル時：exit 1でnetconfigスクリプト終了

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | ネットワークインタフェース管理 | 主機能 | ifconfigによるネットワークインターフェース一覧表示とAuto/Manual選択処理 |
| 34 | TCP/IPプロトコルスタック | 補助機能 | IPv4/IPv6対応状態の確認 |

## 画面種別

選択（メニュー形式のインターフェース選択画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。`bsdinstall netconfig`として呼び出される。実体は`usr.sbin/bsdinstall/scripts/netconfig`シェルスクリプトである。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| INTERFACE | 出力 | 文字列 | 選択されたインターフェース名 | - | はい |
| AUTO | 出力 | 文字列 | "auto"またはブランク | AutoボタンならAuto | - |
| INTERFACES | 内部 | 文字列 | 利用可能なインターフェース一覧 | ifconfig -lの結果 | - |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Network Configuration" | ダイアログタイトル |
| バックタイトル | "$OSNAME Installer" | ダイアログバックタイトル |
| プロンプト | "Please select a network interface and configuration mode:" | テキスト |
| AutoボタンOK | "Auto" | OKボタン（ok-label） |
| Manualボタン | "Manual" | Extraボタン（extra-label） |
| インターフェース一覧 | インターフェース名とデバイス説明 | メニュー |

## イベント仕様

### 1-Auto選択

OKボタン（Auto）を押下すると（83行目）、AUTO=autoが設定される（84行目）。後続のIPv4/IPv6設定で、DHCPとSLAACが自動的に使用される。

### 2-Manual選択

Extraボタン（Manual）を押下すると、INTERFACEが設定されAUTOは空のままとなる（89行目）。後続のIPv4/IPv6設定で、手動設定モードが使用される。

### 3-キャンセル

キャンセル時（INTERFACEが空の場合）、exit 1でスクリプトが終了する（86-88行目）。

### 4-無線インターフェース検出

選択されたインターフェースが無線デバイスの場合（96行目のis_wireless_if判定）、wlan0インターフェースが作成され（98-103行目）、`bsdinstall wlanconfig`が呼び出される（104行目）。wlanconfigが失敗した場合はnetconfigが再実行される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インターフェース選択 | $BSDINSTALL_TMPETC/._rc.conf.net | CREATE | 空の設定ファイルを作成（93行目） |
| 無線インターフェース検出 | $BSDINSTALL_TMPETC/._rc.conf.net | WRITE | wlans_$INTERFACE設定を書き込み |
| 処理完了 | $BSDINSTALL_TMPETC/rc.conf.net | RENAME | ._rc.conf.netをrc.conf.netにリネーム（261行目） |

### テーブル別更新項目詳細

#### $BSDINSTALL_TMPETC/._rc.conf.net -> rc.conf.net

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | wlans_$INTERFACE | wlan0 | 無線インターフェースの場合のみ |
| WRITE | ifconfig_$INTERFACE | IPv4/IPv6設定値 | 後続処理で追記 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | エラー | "No network interfaces present to configure." | INTERFACESが空の場合（68-72行目） |
| - | 説明 | "Please select a network interface and configuration mode:" | メニュー表示時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ネットワークインターフェースなし | msgboxで「No network interfaces present to configure.」表示後、exit 1（68-72行目） |
| 無線LAN設定失敗 | exec $0でnetconfigスクリプトを再実行（104行目） |
| IPv4設定失敗（Manualモード） | exec $0でnetconfigスクリプトを再実行（131行目） |
| IPv6設定失敗（Manualモード） | exec $0でnetconfigスクリプトを再実行（153行目） |
| Auto設定完全失敗 | AUTO_FAILにプロトコル名を記録し、失敗メッセージを表示後にnetconfigを再実行（212-216行目） |

## 備考

- netconfigスクリプトはインターフェース選択だけでなく、IPv4/IPv6設定、DNS設定までを一連の処理として含む
- xargsのexit code折りたたみ（80-82行目のコメント参照）により、ManualとCancelの区別にINTERFACE変数の有無を使用する
- 無線インターフェースの場合、物理デバイス名からwlan0仮想インターフェースが作成され、以降はwlan0が使用される
- kern.features.inet/inet6のsysctlでIPv4/IPv6サポートの有無が確認される（108-117行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 36-66行目のインターフェース一覧構築ロジック |

**読解のコツ**: `ifconfig -l`はインターフェース名一覧を返す。`ifconfig -g wlan`はwlanグループのインターフェースを返す。`sysctl -in net.wlan.devices`は無線デバイス一覧を返す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 75-91行目のbsddialogによるメニュー表示と選択処理 |

**主要処理フロー**:
1. **46-50行目**: ifconfig -lでインターフェース列挙（lo0とwlanグループを除外）
2. **52-53行目**: 無線デバイスを追加
3. **63-66行目**: 各インターフェースのデバイス説明を取得してメニュー項目構築
4. **76-79行目**: bsddialog --menuでインターフェース選択ダイアログ表示
5. **83-90行目**: Auto/Manual/Cancel判定
6. **96-106行目**: 無線インターフェースの処理（wlan作成・wlanconfig呼び出し）

#### Step 3: 後続処理（IPv4/IPv6/DNS）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 108-158行目のIPv4/IPv6設定呼び出し |
| 3-2 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 160-261行目のDNS設定処理 |

### プログラム呼び出し階層図

```
auto (bsdinstall起動スクリプト)
    |
    +-- bsdinstall netconfig
            |
            +-- ifconfig -l (インターフェース列挙)
            +-- sysctl net.wlan.devices (無線デバイス列挙)
            +-- sysctl dev.*.%desc (デバイス説明取得)
            +-- bsddialog --menu (インターフェース選択)
            |
            +-- [無線インターフェース]
            |      +-- ifconfig wlan0 create wlandev $IF
            |      +-- bsdinstall wlanconfig (画面No.7)
            |
            +-- [IPv4サポートあり]
            |      +-- bsdinstall netconfig_ipv4 (画面No.8/9)
            |
            +-- [IPv6サポートあり]
            |      +-- bsdinstall netconfig_ipv6 (画面No.10/11)
            |
            +-- DNS設定 (画面No.12)
            |      +-- bsddialog --mixedform (resolv.conf設定)
            |
            +-- mv ._rc.conf.net -> rc.conf.net
```

### データフロー図

```
[入力]                          [処理]                          [出力]

ifconfig -l              -----> インターフェース列挙   -------> INTERFACES変数
sysctl net.wlan.devices  -----> 無線デバイス検出       -------> INTERFACES追加
sysctl dev.*.%desc       -----> 説明テキスト取得       -------> BSDDIALOG_ITEMS

ユーザ選択               -----> bsddialog --menu       ------> INTERFACE, AUTO

INTERFACE                -----> is_wireless_if         -------> wlan0作成
                                                               wlanconfig呼び出し

INTERFACE + AUTO         -----> netconfig_ipv4         -------> ._rc.conf.net
                         -----> netconfig_ipv6         -------> ._rc.conf.net
                         -----> DNS設定                -------> resolv.conf

._rc.conf.net            -----> mv                     -------> rc.conf.net
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | 本画面の主スクリプト（IPv4/IPv6/DNS設定も含む） |
| auto | `usr.sbin/bsdinstall/scripts/auto` | ソース | 呼び出し元メインスクリプト |
| wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | ソース | 無線LAN設定スクリプト |
| netconfig_ipv4 | `usr.sbin/bsdinstall/scripts/netconfig_ipv4` | ソース | IPv4設定スクリプト |
| netconfig_ipv6 | `usr.sbin/bsdinstall/scripts/netconfig_ipv6` | ソース | IPv6設定スクリプト |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| ._rc.conf.net | `$BSDINSTALL_TMPETC/._rc.conf.net` | 設定 | ネットワーク設定一時ファイル |
| rc.conf.net | `$BSDINSTALL_TMPETC/rc.conf.net` | 設定 | ネットワーク設定最終ファイル |
| resolv.conf | `$BSDINSTALL_TMPETC/resolv.conf` | 設定 | DNS設定ファイル |
