# 画面設計書 7-無線LAN設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「無線LAN設定画面」の設計仕様を記述する。本画面は無線ネットワークインターフェースが選択された場合に表示され、無線LANネットワークのスキャン・選択・認証設定を行う。

### 本画面の処理概要

本画面は、無線LANネットワークへの接続設定を行うためのTUI画面群である。wpa_supplicantを使用してネットワークスキャンを行い、SSID選択と認証方式に応じたクレデンシャル入力を行う。

**業務上の目的・背景**：ノートPCやサーバの一部では無線LANがネットワーク接続の唯一の手段である場合がある。FreeBSDインストール時にネットワーク接続が必要な場合（配布ファイルダウンロード、pkgbaseインストール等）、無線LANの設定が不可欠となる。本画面はWPA-PSK、WPA-EAP、WEP、Open（暗号化なし）の4つの認証方式に対応し、wpa_supplicant.confを生成してネットワーク接続を確立する。

**画面へのアクセス方法**：netconfigスクリプトの104行目で`bsdinstall wlanconfig $NEXT_WLAN_IFACE`として呼び出される。無線インターフェースが選択された場合にのみ表示される。

**主要な操作・処理内容**：
1. リージョン/国コード設定：BSDINSTALL_CONFIGCURRENTが設定されている場合、regdomain/country選択ダイアログが表示される（185-198行目）
2. 無線ネットワークスキャン：wpa_cli scanでスキャンを実行し、5秒待機後にscan_resultsを取得する（201-217行目）
3. SSID選択：スキャン結果をメニューとして表示し、ユーザがSSIDを選択する（223-237行目）
4. 手動SSID入力：スキャン結果にないネットワークの場合、SSIDと暗号化方式を手動入力できる（243-265行目）
5. 認証情報入力：選択された暗号化方式に応じてパスワード等を入力する（275-352行目）
6. wpa_supplicant.conf生成：入力された情報に基づいてwpa_supplicant.confを生成する

**画面遷移**：
- 遷移元：ネットワークインターフェース選択画面（無線インターフェース選択時）
- 遷移先：IPv4設定確認画面
- 再スキャン：Rescanボタンでスキャンを再実行
- キャンセル時：exit 1でwlanconfigスクリプト終了

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | ネットワークインタフェース管理 | 主機能 | wpa_supplicantを使用した無線LANスキャン・SSID選択・認証設定処理 |
| 55 | ネットワークデバイスドライバ | 補助機能 | 無線LANデバイスの検出・wlanインターフェース作成 |
| 110 | 国際化・地域化 | 補助機能 | 無線LAN規制ドメイン・国コード選択処理 |

## 画面種別

設定（複数ステップからなる無線LAN設定画面群）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。`bsdinstall wlanconfig $WLAN_IFACE`として呼び出される。実体は`usr.sbin/bsdinstall/scripts/wlanconfig`シェルスクリプトである。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| WLAN_IFACE | 入力 | 文字列 | wlanインターフェース名 | 引数$1 | はい |
| NETWORK | 入力/出力 | 文字列 | 選択されたSSID | - | はい |
| ENCRYPTION | 出力 | 文字列 | 暗号化方式の文字列 | スキャン結果から取得 | - |
| PASS | 入力 | 文字列 | WPA-PSKパスワード | - | PSK選択時のみ |
| USERPASS | 入力 | 文字列 | WPA-EAPユーザ名・パスワード | - | EAP選択時のみ |
| WEPKEY | 入力 | 文字列 | WEPキー | - | WEP選択時のみ |
| regdomain | 入力 | 文字列 | 規制ドメイン | 現在の設定値 | いいえ |
| country | 入力 | 文字列 | 国コード | 現在の設定値 | いいえ |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| スキャン中メッセージ | "Waiting 5 seconds to scan for wireless networks..." | pauseダイアログ |
| ネットワーク一覧 | スキャン結果のSSIDと暗号化方式 | メニュー |
| WPA Setupタイトル | "WPA Setup" | mixedformダイアログ |
| WPA-Enterprise Setupタイトル | "WPA-Enterprise Setup" | mixedformダイアログ |
| WEP Setupタイトル | "WEP Setup" | mixedformダイアログ |
| Regdomain selection | "Select your regdomain." | メニュー |
| Country selection | "Select your country." | メニュー |

## イベント仕様

### 1-リージョン/国コード変更

BSDINSTALL_CONFIGCURRENT設定時（185行目）、現在のregdomain/countryが表示され、変更するか確認される（194行目）。Yesの場合、dialog_country_select関数でregdomainとcountryを選択する（196-198行目）。選択結果はifconfig経由で適用され、rc.conf.net.wlanに保存される（72-74行目）。

### 2-ネットワークスキャン

wpa_cli scanが実行され（209行目）、5秒のpauseダイアログが表示される（211行目）。スキャン結果はwpa_cli scan_resultsで取得され（214行目）、BSSID・フラグ・SSID情報がawkで整形される（215-217行目）。

### 3-SSID選択

スキャン結果がメニューとして表示される（227-236行目）。OK（選択）、Cancel（手動入力）、Extra（Rescan）の3つのボタンが使用可能。

### 4-手動SSID・暗号化選択

Cancelボタン押下時、SSIDの手動入力（246行目）と暗号化方式の選択（248-263行目: WPA/WPA2 PSK、WPA/WPA2 EAP、WEP、None）が行われる。

### 5-認証情報入力（WPA-PSK）

PSK暗号化の場合（275行目）、mixedformダイアログでSSID（読み取り専用）とPassword（パスワードフィールド）が表示される（276-284行目）。入力結果はwpa_supplicant.confにnetworkブロックとして書き込まれる（286-294行目）。

### 6-認証情報入力（WPA-EAP）

EAP暗号化の場合（295行目）、mixedformダイアログでSSID、Username、Passwordフィールドが表示される（296-305行目）。key_mgmt=WPA-EAPとidentity/passwordが設定される（308-319行目）。

### 7-認証情報入力（WEP）

WEP暗号化の場合（320行目）、mixedformダイアログでSSIDとWEP Key 0フィールドが表示される（321-329行目）。key_mgmt=NONEとwep_key0/wep_tx_keyidxが設定される（331-341行目）。

### 8-Open（暗号化なし）

暗号化なしの場合（342行目）、key_mgmt=NONEのnetworkブロックのみが書き込まれる（343-351行目）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| wpa_supplicant.conf初期化 | $BSDINSTALL_TMPETC/wpa_supplicant.conf | CREATE | 基本設定（ctrl_interface等）を書き込み |
| 認証情報入力 | $BSDINSTALL_TMPETC/wpa_supplicant.conf | APPEND | networkブロックを追記 |
| オープンネットワークポリシー | $BSDINSTALL_TMPETC/wpa_supplicant.conf | APPEND | priority=0のオープンネットワーク設定を追記 |
| regdomain/country設定 | $BSDINSTALL_TMPETC/rc.conf.net.wlan | WRITE | create_args設定を書き込み |

### テーブル別更新項目詳細

#### $BSDINSTALL_TMPETC/wpa_supplicant.conf

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | ctrl_interface | /var/run/wpa_supplicant | 固定値 |
| WRITE | eapol_version | 2 | 固定値 |
| WRITE | ap_scan | 1 | 固定値 |
| APPEND | network{} | ssid, psk/identity/password/wep_key0, key_mgmt, scan_ssid, priority | 認証方式に応じた値 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 情報 | "Waiting 5 seconds to scan for wireless networks..." | スキャン時 |
| msg_error | エラー | "No wireless networks were found. Rescan?" | スキャン結果が空の場合 |
| - | 確認 | "Do you want to select the network manually?" | Cancel時 |
| - | エラー | "Wireless cannot be configured without making changes to the local system!" | CONFIGCURRENT未設定時 |
| - | エラー | "Error while applying chosen settings ($error_str)" | regdomain/country適用エラー時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| wpa_supplicantが起動していない | BSDINSTALL_CONFIGCURRENT設定時は起動を試行。未設定時はエラーメッセージ表示後exit 1（167-179行目） |
| スキャン結果が空 | "No wireless networks were found. Rescan?"のYes/No確認。Yesでリスキャン、Noでexit 1（219-221行目） |
| regdomain/country適用失敗 | エラーメッセージ表示。Change/Ignoreの選択。ChangeでリトライIgnoreでスキップ（62-70行目） |
| 認証情報入力でキャンセル | exec "$0" "$@"でスクリプト再実行（285行目等） |

## 備考

- wpa_supplicantはバックグラウンドプロセスとして動作し、wpa_cliコマンドで制御される
- scan_ssid=1は手動入力SSID用のフラグで、隠しSSIDのスキャンを有効にする
- 最後に常にpriority=0のオープンネットワーク設定が追加される（355-359行目）
- wpa_supplicant.confのパーミッションは0600に設定される（153行目）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | 152-161行目のwpa_supplicant.conf初期構造（ctrl_interface、eapol_version、ap_scan、fast_reauth） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 96-106行目のwlanconfig呼び出し部分 |
| 2-2 | wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | 150-366行目のMAINセクション |

**主要処理フロー**:
1. **152-161行目**: wpa_supplicant.conf初期化
2. **167-179行目**: wpa_supplicant接続確認・起動
3. **185-198行目**: regdomain/country設定（条件付き）
4. **201-270行目**: スキャン・SSID選択メインループ
5. **272-352行目**: 暗号化方式に応じた認証情報入力・設定書き込み
6. **355-359行目**: オープンネットワークポリシー追加
7. **363-364行目**: wpa_cli reconfigure（設定適用）

#### Step 3: 認証方式別処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | 275-294行目のWPA-PSK処理 |
| 3-2 | wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | 295-319行目のWPA-EAP処理 |
| 3-3 | wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | 320-341行目のWEP処理 |
| 3-4 | wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | 342-351行目のOpen処理 |

### プログラム呼び出し階層図

```
netconfig (ネットワーク設定スクリプト)
    |
    +-- bsdinstall wlanconfig $WLAN_IFACE
            |
            +-- wpa_supplicant.conf初期化 (152-161行目)
            +-- wpa_cli ping (接続確認)
            |      +-- wpa_supplicant -B (未起動時に起動)
            |
            +-- [CONFIGCURRENT時]
            |      +-- ifconfig list regdomain (現在値取得)
            |      +-- dialog_country_select (regdomain/country選択)
            |             +-- ifconfig list countries (利用可能リスト)
            |             +-- country_set (適用)
            |
            +-- [スキャンループ]
            |      +-- ifconfig $WLAN_IFACE up
            |      +-- wpa_cli scan
            |      +-- f_dialog_pause (5秒待機)
            |      +-- wpa_cli scan_results
            |      +-- $DIALOG --menu (SSID選択)
            |
            +-- [認証情報入力]
            |      +-- $DIALOG --mixedform (PSK/EAP/WEP)
            |      +-- wpa_supplicant.conf書き込み
            |
            +-- wpa_cli reconfigure (設定適用)
```

### データフロー図

```
[入力]                          [処理]                          [出力]

WLAN_IFACE引数           -----> wpa_supplicant起動      ------> wpa_supplicant.conf
                                                               (初期設定)

wpa_cli scan_results     -----> awk整形                 ------> NETWORKS
                                                               (SSID+暗号化)

ユーザSSID選択           -----> ENCRYPTION取得           ------> 認証方式判定

ユーザ認証情報入力       -----> networkブロック生成       ------> wpa_supplicant.conf
                                                               (追記)

wpa_cli reconfigure      -----> 設定適用                ------> 無線LAN接続
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| wlanconfig | `usr.sbin/bsdinstall/scripts/wlanconfig` | ソース | 本画面の主スクリプト |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | 呼び出し元スクリプト |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ表示関数群 |
| wpa_supplicant.conf | `$BSDINSTALL_TMPETC/wpa_supplicant.conf` | 設定 | 無線LAN設定ファイル |
| rc.conf.net.wlan | `$BSDINSTALL_TMPETC/rc.conf.net.wlan` | 設定 | wlanインターフェースcreate_args設定 |
