# 画面設計書 8-IPv4設定確認画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「IPv4設定確認画面」の設計仕様を記述する。本画面はIPv4を使用するか確認し、DHCP又はスタティック設定を行う。

### 本画面の処理概要

本画面は、選択されたネットワークインターフェースに対してIPv4ネットワーク設定を行うためのTUI画面である。IPv4使用の有無確認、DHCP/スタティック選択、およびDHCPによるアドレス自動取得を処理する。

**業務上の目的・背景**：ネットワーク接続にはIPアドレスの設定が不可欠である。IPv4はインターネット接続の主要プロトコルであり、ほとんどの環境で使用される。本画面はDHCPによる自動設定と手動（スタティック）設定の両方に対応し、環境に応じた柔軟なネットワーク設定を提供する。Autoモード時はDHCPが自動選択され、ユーザ操作なしで設定が完了する。

**画面へのアクセス方法**：netconfigスクリプトの128行目で`bsdinstall netconfig_ipv4 ${INTERFACE} "${IFCONFIG_PREFIX}" $AUTO`として呼び出される。kern.features.inetのsysctlでIPv4サポートが確認された場合にのみ呼び出される。

**主要な操作・処理内容**：
1. IPv4使用確認（Manualモード時）：「Would you like to configure IPv4 for this interface?」のYes/Noダイアログ（netconfigスクリプト121-126行目）
2. DHCP使用確認：「Would you like to use DHCP to configure this interface?」のYes/Noダイアログ（64行目）
3. DHCPアドレス取得：dhclientコマンドによるIPv4アドレスの自動取得（72-89行目）
4. スタティック設定画面への遷移：DHCP不使用時はIPv4スタティック設定画面（画面No.9）に相当するフォーム入力に進む（92-109行目）

**画面遷移**：
- 遷移元：ネットワークインターフェース選択画面（netconfig）
- 遷移先（DHCP選択時）：IPv6設定確認画面
- 遷移先（スタティック選択時）：IPv4スタティック設定画面（同スクリプト内のフォーム部分、画面No.9）
- IPv4不使用選択時：IPv6設定確認画面

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | TCP/IPプロトコルスタック | 主機能 | IPv4使用有無の確認およびDHCP/スタティック設定モード選択 |
| 96 | DHCPクライアント | 遷移先機能 | Autoモード時のDHCPによるIPv4アドレス自動取得 |

## 画面種別

確認・設定（Yes/Noダイアログ + DHCP設定画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。`bsdinstall netconfig_ipv4`として呼び出される。実体は`usr.sbin/bsdinstall/scripts/netconfig_ipv4`シェルスクリプトである。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| INTERFACE | 入力 | 文字列 | ネットワークインターフェース名 | 引数$1 | はい |
| IFCONFIG_PREFIX | 入力 | 文字列 | ifconfig設定プレフィックス | 引数$2（無線時"WPA "） | いいえ |
| AUTO | 入力 | 文字列 | "auto"またはブランク | 引数$3 | いいえ |
| DHCP | 内部 | 整数 | DHCP使用フラグ（1/0） | Autoモード時は1 | - |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Network Configuration" | ダイアログタイトル |
| DHCP確認プロンプト | "Would you like to use DHCP to configure this interface?" | Yes/Noダイアログ |
| DHCP取得中メッセージ | "Acquiring DHCP lease..." | infobox |

## イベント仕様

### 1-DHCP選択

Autoモード時はDHCP=1が自動設定される（62行目）。Manualモード時はYes/Noダイアログでユーザに確認される（64-69行目）。DHCP=1の場合、BSDINSTALL_CONFIGCURRENT設定時にdhclientが実行される（72-87行目）。成功時、`ifconfig_$INTERFACE="${IFCONFIG_PREFIX}DHCP"`がrc.conf.netに書き込まれる（88行目）。

### 2-スタティック選択

DHCP不使用の場合（DHCP=0）、IPアドレス・サブネットマスク・デフォルトルータの入力フォームが表示される（92-101行目）。これは画面No.9のIPv4スタティック設定画面に相当する。

### 3-DHCP失敗

DHCP取得が失敗した場合、Autoモード時はexit 1（82行目）、Manualモード時はエラーメッセージ後にスクリプト再実行（84-85行目）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| DHCP選択 | $BSDINSTALL_TMPETC/._rc.conf.net | WRITE | ifconfig_$INTERFACE="...DHCP"を設定 |
| スタティック設定 | $BSDINSTALL_TMPETC/._rc.conf.net | APPEND | ifconfig_$INTERFACE、defaultrouterを追記 |

### テーブル別更新項目詳細

#### $BSDINSTALL_TMPETC/._rc.conf.net

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| WRITE | ifconfig_$INTERFACE | "${IFCONFIG_PREFIX}DHCP" | DHCP選択時 |
| WRITE | ifconfig_$INTERFACE | "${IFCONFIG_PREFIX}inet $IP netmask $MASK" | スタティック時 |
| WRITE | defaultrouter | ユーザ入力値 | スタティック時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 確認 | "Would you like to use DHCP to configure this interface?" | Manualモード時 |
| - | 情報 | "Acquiring DHCP lease..." | DHCP取得中 |
| - | エラー | "DHCP lease acquisition failed." | DHCP失敗時（Manualモード） |
| - | エラー | "No interface specified for IPv4 configuration." | INTERFACEが空の場合 |
| - | エラー | "Bad auto option '$AUTO'." | AUTO引数が不正な場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| INTERFACEが未指定 | エラーメッセージ表示後exit 1（46-49行目） |
| AUTO引数が不正 | エラーメッセージ表示後exit 1（55-58行目） |
| DHCP取得失敗（Autoモード） | exit 1で終了（82行目） |
| DHCP取得失敗（Manualモード） | エラーメッセージ表示後、スクリプト再実行（84-85行目） |
| フォームキャンセル | exit 1で終了（102行目） |

## 備考

- Autoモードではdhclient実行前にインターフェースをdown/upする（75-76行目）。PR262262のワークアラウンドとして、dhclientが新しいresolv.confを生成するために必要
- IFCONFIG_PREFIXはwlanインターフェースの場合"WPA "が設定され、ifconfig設定値の先頭に付与される
- dhclient起動前に既存のdhclientプロセスがpkillで停止される（78行目）
- BSDINSTALL_CONFIGCURRENTが未設定の場合、DHCPの実際の取得は行わず、rc.conf設定のみ書き込む

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | netconfig_ipv4 | `usr.sbin/bsdinstall/scripts/netconfig_ipv4` | 41-44行目の引数受け取り（INTERFACE、IFCONFIG_PREFIX、AUTO） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | 120-136行目のIPv4設定呼び出し部分 |
| 2-2 | netconfig_ipv4 | `usr.sbin/bsdinstall/scripts/netconfig_ipv4` | 38-126行目のMAINセクション |

**主要処理フロー**:
1. **41-59行目**: 引数バリデーション
2. **61-70行目**: DHCP使用判定（Autoモード時は自動、Manual時はYes/No確認）
3. **71-89行目**: DHCP処理（インターフェースdown/up、dhclient実行、rc.conf書き込み）
4. **92-109行目**: スタティック設定（フォーム表示、rc.conf追記）
5. **112-124行目**: CONFIGCURRENT時の即時適用（ifconfig、route設定）

### プログラム呼び出し階層図

```
netconfig (ネットワーク設定スクリプト)
    |
    +-- bsdinstall netconfig_ipv4 $INTERFACE "$PREFIX" $AUTO
            |
            +-- 引数バリデーション (41-59行目)
            |
            +-- [Autoモード]
            |      +-- DHCP=1 (自動設定)
            |
            +-- [Manualモード]
            |      +-- bsddialog --yesno (DHCP確認)
            |
            +-- [DHCP=1]
            |      +-- ifconfig down/up
            |      +-- pkill dhclient
            |      +-- dhclient $INTERFACE
            |      +-- sysrc ifconfig_$INTERFACE="DHCP"
            |
            +-- [DHCP=0]
                   +-- ifconfig (現在値取得)
                   +-- netstat -rn (デフォルトルータ取得)
                   +-- bsddialog --form (スタティック設定)
                   +-- awk (rc.conf生成)
                   +-- [CONFIGCURRENT時]
                          +-- ifconfig (適用)
                          +-- route add (適用)
```

### データフロー図

```
[入力]                          [処理]                          [出力]

INTERFACE, PREFIX, AUTO  -----> 引数解析               -------> DHCP判定

[DHCP=1]
dhclient                 -----> DHCP取得               -------> IPアドレス設定
                                sysrc                  -------> ._rc.conf.net
                                                               (ifconfig_$IF="DHCP")

[DHCP=0]
ifconfig (現在値)        -----> 初期値取得             -------> フォーム初期値
ユーザ入力(IP/Mask/GW)  -----> bsddialog --form       -------> IF_CONFIG
IF_CONFIG                -----> awk生成                -------> ._rc.conf.net
                                                               (ifconfig_$IF, defaultrouter)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| netconfig_ipv4 | `usr.sbin/bsdinstall/scripts/netconfig_ipv4` | ソース | 本画面の主スクリプト |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | 呼び出し元スクリプト |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ表示関数群 |
| ._rc.conf.net | `$BSDINSTALL_TMPETC/._rc.conf.net` | 設定 | ネットワーク設定一時ファイル |
