# 画面設計書 9-IPv4スタティック設定画面

## 概要

本ドキュメントは、FreeBSD bsdinstall インストーラにおける「IPv4スタティック設定画面」の設計仕様を記述する。本画面はDHCP不使用時に表示され、IPアドレス・サブネットマスク・デフォルトルータを手動入力する。

### 本画面の処理概要

本画面は、IPv4ネットワーク設定を手動で行うためのフォーム入力画面である。bsddialogのformダイアログを使用して、IPアドレス、サブネットマスク、デフォルトルータの3項目を入力する。

**業務上の目的・背景**：DHCPサーバが存在しないネットワーク環境やサーバ用途で固定IPアドレスを使用する場合、IPアドレスの手動設定が必要となる。本画面はIPアドレス、サブネットマスク、デフォルトルータの3つの基本パラメータを入力させることで、静的なIPv4ネットワーク設定を実現する。現在のインターフェース設定値とルーティングテーブルから初期値を取得するため、既に設定がある場合は効率的に編集できる。

**画面へのアクセス方法**：netconfig_ipv4スクリプト内でDHCP不使用（DHCP=0）の場合に表示される。DHCP確認のYes/Noダイアログで「No」を選択した場合に到達する。netconfig_ipv4スクリプトの92-109行目で処理される。

**主要な操作・処理内容**：
1. 現在値の取得：ifconfigから現在のIPアドレスとサブネットマスク、netstatからデフォルトルータを取得する（92-94行目）
2. フォーム入力：bsddialogの--formダイアログで3項目を入力する（97-101行目）
3. rc.conf設定の生成：awkで入力値からifconfig設定値とdefaultrouter設定を生成する（105-109行目）
4. 即時適用：BSDINSTALL_CONFIGCURRENT設定時に、ifconfigとroute addで即座に設定を適用する（112-124行目）

**画面遷移**：
- 遷移元：IPv4設定確認画面（DHCP不使用選択時）
- 遷移先：IPv6設定確認画面
- キャンセル時：exit 1でスクリプト終了

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | TCP/IPプロトコルスタック | 主機能 | IPアドレス・サブネットマスク・デフォルトルータの手動入力・設定処理 |
| 35 | ネットワークインタフェース管理 | 補助機能 | ifconfigによるインターフェースへのIPアドレス適用 |

## 画面種別

入力（フォーム形式のIPv4手動設定画面）

## URL/ルーティング

TUIベースのインストーラのため、URLは存在しない。netconfig_ipv4スクリプト内の92-109行目で処理される。スクリプトは`usr.sbin/bsdinstall/scripts/netconfig_ipv4`。

## 入出力項目

| 項目名 | 入力/出力 | 型 | 説明 | 初期値 | 必須 |
|--------|----------|-----|------|--------|------|
| IP Address | 入力 | 文字列 | IPv4アドレス | ifconfigから取得した現在値 | はい |
| Subnet Mask | 入力 | 文字列 | サブネットマスク | ifconfigから取得した現在値 | はい |
| Default Router | 入力 | 文字列 | デフォルトルータ | netstat -rnから取得した現在値 | はい |

## 表示項目

| 項目名 | 説明 | 表示形式 |
|--------|------|----------|
| タイトル | "Network Configuration" | ダイアログタイトル |
| バックタイトル | "$OSNAME Installer" | ダイアログバックタイトル |
| プロンプト | "Static Network Interface Configuration" | テキスト |
| IP Addressフィールド | IPv4アドレス入力 | フォームフィールド（16文字幅） |
| Subnet Maskフィールド | サブネットマスク入力 | フォームフィールド（16文字幅） |
| Default Routerフィールド | デフォルトルータ入力 | フォームフィールド（16文字幅） |

## イベント仕様

### 1-フォーム入力確定（OK）

OKボタン押下時、入力された3つの値がIF_CONFIG変数に格納される（97-101行目）。awkで解析され、`ifconfig_$INTERFACE="${IFCONFIG_PREFIX}inet $IP netmask $MASK"`と`defaultrouter="$ROUTER"`がrc.conf.netに書き込まれる（105-109行目）。

### 2-キャンセル

Cancelボタン押下時、exit 1でスクリプトが終了する（102行目）。

### 3-即時適用

BSDINSTALL_CONFIGCURRENT設定時、rc.conf.netの内容をsourceして変数に読み込み（113行目）、ifconfigコマンドでIPアドレスを適用する（114-118行目）。defaultrouter設定がある場合、既存のデフォルトルートを削除してから新しいルートを追加する（119-123行目）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| OK押下 | $BSDINSTALL_TMPETC/._rc.conf.net | APPEND | ifconfig_$INTERFACE、defaultrouterを追記 |

### テーブル別更新項目詳細

#### $BSDINSTALL_TMPETC/._rc.conf.net

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| APPEND | ifconfig_$INTERFACE | "${IFCONFIG_PREFIX}inet $IP netmask $MASK" | 例: `ifconfig_em0="inet 192.168.1.100 netmask 255.255.255.0"` |
| APPEND | defaultrouter | ユーザ入力のルータアドレス | 例: `defaultrouter="192.168.1.1"` |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | タイトル | "Static Network Interface Configuration" | フォーム表示時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| フォームキャンセル | exit 1で終了（102行目） |
| route add失敗 | 戻り値が非ゼロで返却される（122行目のretval） |

## 備考

- フォームの各フィールドは16文字幅に制限されている
- IFCONFIG_PREFIXが設定されている場合（無線LANの"WPA "等）、ifconfig適用時にはprefixがsedで除去される（115行目）
- 既存のデフォルトルートは`route delete -inet default`で削除されてから新しいルートが追加される
- 本画面はnetconfig_ipv4スクリプトの後半部分であり、独立したスクリプトではない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | netconfig_ipv4 | `usr.sbin/bsdinstall/scripts/netconfig_ipv4` | 92-94行目の初期値取得（ifconfig、netstatからの現在値抽出） |

**読解のコツ**: `ifconfig $INTERFACE inet | awk '/inet/ {printf("%s\n", $2)}'`はインターフェースのIPv4アドレスを取得するワンライナー。$4がネットマスク。`netstat -rn -f inet | awk '/default/ {printf("%s\n", $2)}'`はデフォルトルータを取得する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | netconfig_ipv4 | `usr.sbin/bsdinstall/scripts/netconfig_ipv4` | 92-126行目のスタティック設定処理部分 |

**主要処理フロー**:
1. **92行目**: `ifconfig $INTERFACE inet`でIPアドレス取得
2. **93行目**: `ifconfig $INTERFACE inet`でネットマスク取得
3. **94行目**: `netstat -rn -f inet`でデフォルトルータ取得
4. **97-101行目**: `bsddialog --form`でフォーム表示
5. **102行目**: キャンセル時のexit 1
6. **105-109行目**: awkでrc.conf設定生成（ifconfig_$INTERFACE、defaultrouter）
7. **112-124行目**: CONFIGCURRENT時の即時適用

### プログラム呼び出し階層図

```
netconfig_ipv4 (IPv4設定スクリプト)
    |
    +-- [DHCP=0 スタティック設定パス]
         |
         +-- ifconfig $INTERFACE inet (現在IP/Mask取得)
         +-- netstat -rn -f inet (デフォルトルータ取得)
         +-- bsddialog --form (フォーム表示)
         +-- awk (rc.conf生成 -> ._rc.conf.net)
         |
         +-- [CONFIGCURRENT時]
                +-- . ._rc.conf.net (source)
                +-- ifconfig $INTERFACE (IP適用)
                +-- route delete -inet default
                +-- route add -inet default $defaultrouter
```

### データフロー図

```
[入力]                          [処理]                          [出力]

ifconfig $IF inet        -----> awk抽出                -------> IP_ADDRESS, NETMASK
netstat -rn -f inet      -----> awk抽出                -------> ROUTER

ユーザ入力               -----> bsddialog --form       ------> IF_CONFIG
  (IP, Mask, Router)

IF_CONFIG                -----> awk生成                -------> ._rc.conf.net
                                                               ifconfig_$IF="..."
                                                               defaultrouter="..."

._rc.conf.net            -----> source / ifconfig      -------> インターフェース設定
                                route add                       (即時適用)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| netconfig_ipv4 | `usr.sbin/bsdinstall/scripts/netconfig_ipv4` | ソース | 本画面を含むIPv4設定スクリプト |
| netconfig | `usr.sbin/bsdinstall/scripts/netconfig` | ソース | 呼び出し元スクリプト |
| common.subr | `/usr/share/bsdconfig/common.subr` | ライブラリ | bsdconfig共通関数群 |
| dialog.subr | `/usr/share/bsdconfig/dialog.subr` | ライブラリ | ダイアログ表示関数群 |
| ._rc.conf.net | `$BSDINSTALL_TMPETC/._rc.conf.net` | 設定 | ネットワーク設定一時ファイル |
