---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-キーマップ選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **keymap.subr内部のKEYMAPS変数構造**：keymap.subrの実際のコードは未読のため構造の詳細は推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `usr.sbin/bsdinstall/scripts/keymap` (全233行)
- E-02: `usr.sbin/bsdinstall/scripts/auto` (195行目: bsdinstall keymap呼び出し)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (1行目: キーマップ選択画面)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (1-2行目)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (9行目: KEYMAP -> HOSTNAME)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インストーラ起動直後に表示される | E-02 (auto:195行目) | ○ |
| C-02 | BSDINSTALL_SKIP_KEYMAPで省略可能 | E-02 (auto:195行目) | ○ |
| C-03 | bsdconfigのkeymap.subrを使用 | E-01 (keymap:35行目 f_include keymap.subr) | ○ |
| C-04 | dialog.subrラッパーを使用 | E-01 (keymap:34行目 f_include dialog.subr) | ○ |
| C-05 | rc.confからkeymap初期値を取得 | E-01 (keymap:131行目 f_sysrc_get keymap) | ○ |
| C-06 | KEYMAPFILEに設定保存 | E-01 (keymap:224行目 echo > KEYMAPFILE) | ○ |
| C-07 | dialog_keymap_test関数でテスト入力 | E-01 (keymap:70-110行目) | ○ |
| C-08 | f_keymap_kbdcontrolでキーマップ適用 | E-01 (keymap:81行目, 227行目) | ○ |
| C-09 | Cancel時にKEYMAPFILE削除しexit FAILURE | E-01 (keymap:200-203行目) | ○ |
| C-10 | SIGINT時にKEYMAPFILE削除 | E-01 (keymap:126行目 trap) | ○ |
| C-11 | メニューにContinue/Test/キーマップ一覧 | E-01 (keymap:150-175行目) | ○ |
| C-12 | ラジオボタン(*)で選択状態表示 | E-01 (keymap:163-165行目) | ○ |
| C-13 | ホスト名設定画面に遷移 | E-05 (遷移図: KEYMAP -> HOSTNAME) | ○ |
| C-14 | 関連機能No.74パッケージ管理支援 | E-04 (マッピング:1行目) | ○ |
| C-15 | 関連機能No.110国際化・地域化 | E-04 (マッピング:2行目) | ○ |
| C-16 | XDialogとbsddialog両対応 | E-01 (keymap:140行目 USE_XDIALOG) | ○ |
| C-17 | テスト入力時にエラーダイアログ表示 | E-01 (keymap:82-87行目) | ○ |
| C-18 | KEYMAPS変数からキーマップ一覧を構築 | E-01 (keymap:160行目参照) だがkeymap.subr未読 | △ |

## 4) 不足情報（Unknown / Missing）
- keymap.subrの実コードを未読のため、KEYMAPS変数の内部構造（keymap_$k get keym/desc）の正確な動作は推定に基づく
  - 候補：`/usr/share/bsdconfig/keymap.subr` の直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フロー、イベント仕様、データフローはソースコードに基づいて正確に記述
- 0: 低リスク - 画面遷移は画面遷移図およびautoスクリプトと整合
- 1: 中リスク - keymap.subrの内部動作の一部は推定

## 6) レビュアーチェックリスト（最小）
- [ ] keymap.subrのKEYMAPS変数とkeymap_$k構造体の実際の動作を確認
- [ ] bsdconfig dialog.subrの$DIALOG変数がbsddialogを正しく参照しているか確認
- [ ] テスト入力機能（dialog_keymap_test）の実際の動作確認
