---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-IPv6設定確認画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **IPv6スタティック設定のmixedform引数構築の正確性**：awkによる動的生成のため実行結果の検証が困難

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` (全185行)
- E-02: `usr.sbin/bsdinstall/scripts/netconfig` (142-158行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (10行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (18行目)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (92-99行目: IPv6サブフロー)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数$1がINTERFACE、$2がAUTO | E-01 (netconfig_ipv6:50-51行目) | ○ |
| C-02 | Autoモード時にSLAAC=1自動設定 | E-01 (netconfig_ipv6:70-71行目) | ○ |
| C-03 | Manualモード時にSLAAC確認Yes/No | E-01 (netconfig_ipv6:73-80行目) | ○ |
| C-04 | rtsolでRouter Solicitation実行 | E-01 (netconfig_ipv6:87行目) | ○ |
| C-05 | rtsol -Fフラグ使用 | E-01 (netconfig_ipv6:87行目) | ○ |
| C-06 | SLAAC前にifconfig inet6 -ifdisabled accept_rtadv up | E-01 (netconfig_ipv6:86行目) | ○ |
| C-07 | SLAAC成功時にaccept_rtadv設定 | E-01 (netconfig_ipv6:98行目 sysrc) | ○ |
| C-08 | SLAAC失敗Autoモード時exit 1 | E-01 (netconfig_ipv6:90-91行目) | ○ |
| C-09 | SLAAC失敗Manualモード時にmsgbox表示後continue | E-01 (netconfig_ipv6:93-95行目) | ○ |
| C-10 | AGAINフラグでプロンプトに"again"追加 | E-01 (netconfig_ipv6:94行目) | ○ |
| C-11 | DHCPv6未サポートのTODOコメント | E-01 (netconfig_ipv6:47行目) | ○ |
| C-12 | INTERFACE未指定時にエラー | E-01 (netconfig_ipv6:52-56行目) | ○ |
| C-13 | AUTO不正値時にエラー | E-01 (netconfig_ipv6:58-65行目) | ○ |
| C-14 | スタティック設定でmixedform使用 | E-01 (netconfig_ipv6:132-136行目) | ○ |
| C-15 | /64自動付与 | E-01 (netconfig_ipv6:163-165行目) | ○ |
| C-16 | 関連機能No.34 TCP/IPプロトコルスタック | E-04 (マッピング:18行目) | ○ |
| C-17 | スタティック設定のmixedform引数構造（ADDRS変数） | E-01 (netconfig_ipv6:106-130行目) だがawk動的生成の実行結果は未検証 | △ |

## 4) 不足情報（Unknown / Missing）
- ADDRS変数はawkによる動的生成であり、実際の実行環境でのbsddialog --mixedform引数の構造は未検証
  - 候補：実際のFreeBSD環境でのnetconfig_ipv6スクリプトの実行テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SLAAC処理フローはソースコードに基づいて正確に記述
- 1: 中リスク - スタティック設定のawk動的フォーム構築は複雑であり、実行結果の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ADDRS変数のawk出力（mixedform引数）が正しいbsddialog構文になるか確認
- [ ] DefaultRouterの隠しフィールドマーカー（128行目）の動作確認
- [ ] IPv6アドレスのプレフィックス長自動付与(/64)の条件確認
