---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-IPv6スタティック設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **DNS設定画面への遷移先**：netconfigスクリプトの制御フローからの推測であり直接的遷移コードはない

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行50-56（INTERFACE引数チェック）
- E-02: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行58-66（AUTOオプションチェック）
- E-03: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行69-103（SLAACループ）
- E-04: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行105-130（既存アドレス取得awk）
- E-05: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行132-138（mixedformダイアログ）
- E-06: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行140-167（入力パースawk）
- E-07: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行163-165（/64デフォルト付与）
- E-08: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行170-178（即時適用処理）
- E-09: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行47（DHCPv6 TODOコメント）
- E-10: `usr.sbin/bsdinstall/scripts/netconfig_ipv6` 行113（fe80除外処理）
- E-11: `usr.sbin/bsdinstall/scripts/netconfig` 行142-158（IPv6設定呼び出し）
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` 行12（画面定義）
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行19-20（機能マッピング）
- E-14: `docs/code-to-docs/画面一覧/画面遷移図.md` 行96（IPv6スタティック設定の遷移）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SLAACを使用しない場合にスタティック設定フォームが表示される | E-03 | ○ |
| C-02 | IPv6アドレスとデフォルトルータの2項目を入力する | E-04, E-05 | ○ |
| C-03 | 現在のインターフェースの既存値がフォーム初期値になる | E-04 | ○ |
| C-04 | fe80リンクローカルアドレスは除外される | E-10 | ○ |
| C-05 | プレフィックス長未指定時に/64が自動付与される | E-07 | ○ |
| C-06 | rc.conf.netにifconfig_*_ipv6が書き込まれる | E-06 | ○ |
| C-07 | rc.conf.netにipv6_defaultrouterが書き込まれる | E-06 | ○ |
| C-08 | BSDINSTALL_CONFIGCURRENT時に即時適用される | E-08 | ○ |
| C-09 | Cancel押下で終了コード1が返る | E-05 (行137) | ○ |
| C-10 | インターフェース未指定でエラーメッセージが表示される | E-01 | ○ |
| C-11 | DHCPv6は未対応である | E-09 | ○ |
| C-12 | bsddialog mixedformが使用される | E-05 | ○ |
| C-13 | netconfigスクリプトから呼び出される | E-11 | ○ |
| C-14 | 複数IPv6アドレス時は最初のアドレスのみ表示 | E-04 (行115) | ○ |
| C-15 | 即時適用時にrouteコマンドでデフォルトルートが設定される | E-08 | ○ |
| C-16 | AUTOオプションのバリデーションがある | E-02 | ○ |
| C-17 | SLAAC失敗時にエラーメッセージが表示され再試行される | E-03 | ○ |
| C-18 | 遷移先はDNS設定画面である | E-14 | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のDNS設定画面への遷移は画面遷移図およびnetconfigスクリプトのフロー制御から推測した。netconfig_ipv6スクリプト自体には次画面への遷移コードはなく、netconfigスクリプトが順次処理を制御している。
  - 候補：netconfigスクリプトの実行フロー確認 / 画面遷移図の検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードと整合性が高い
- 0: 低リスク - 入出力項目はbsddialog mixedformの引数から直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] IPv6アドレスのバリデーション処理が画面レベルで行われているか確認（現状はawk側でのパースのみ）
- [ ] デフォルトルータが空の場合の挙動を確認
- [ ] netconfigスクリプトからの呼び出しフロー（Auto/Manualモード差異）を確認
