---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ミラーサイト選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全項目に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/mirrorselect` 行38-92（bsddialog menuダイアログ）
- E-02: `usr.sbin/bsdinstall/scripts/mirrorselect` 行94-95（unameバージョン取得）
- E-03: `usr.sbin/bsdinstall/scripts/mirrorselect` 行97-104（releases/snapshots判定）
- E-04: `usr.sbin/bsdinstall/scripts/mirrorselect` 行106（URL構築）
- E-05: `usr.sbin/bsdinstall/scripts/mirrorselect` 行108-124（ボタン分岐処理）
- E-06: `usr.sbin/bsdinstall/scripts/mirrorselect` 行115-123（Other入力ダイアログ）
- E-07: `usr.sbin/bsdinstall/scripts/mirrorselect` 行126-127（export + stderr出力）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` 行14（画面定義）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行23-24（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 世界各国のミラーサイトがメニュー表示される | E-01 | ○ |
| C-02 | Main SiteはHTTPとFTPの2種類が提供される | E-01 | ○ |
| C-03 | Otherボタンでカスタム入力画面へ遷移する | E-05, E-06 | ○ |
| C-04 | uname -rからリリースバージョンが取得される | E-02 | ○ |
| C-05 | -p*サフィックスが除去される | E-02 | ○ |
| C-06 | ALPHA/CURRENT等はsnapshotsディレクトリが使用される | E-03 | ○ |
| C-07 | 通常リリースはreleasesディレクトリが使用される | E-03 | ○ |
| C-08 | BSDINSTALL_DISTSITEが構築・エクスポートされる | E-04, E-07 | ○ |
| C-09 | Cancel/ESCで終了コード1が返る | E-05 | ○ |
| C-10 | GeoDNSでMain Siteが最寄りミラーへ誘導する | E-01 (メニュー説明文) | ○ |
| C-11 | メニューは最大16行表示 | E-01 (行42) | ○ |
| C-12 | カスタムURL入力にはデフォルト値がプリセットされる | E-06 (行119) | ○ |
| C-13 | 主機能はlibfetch（機能No.91）である | E-09 | ○ |
| C-14 | URL構築にuname -mとuname -pが使用される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ミラーサイトリストの最新性は確認不要（ソースコードの静的データ）

## 6) レビュアーチェックリスト（最小）
- [ ] ミラーサイトリストが最新であるか確認（ソースコードのハードコード値）
- [ ] fetchmissingdistsからの呼び出しフローを確認
