---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-パーティションモード選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし。全項目に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/auto` 行47-69（メッセージ定数）
- E-02: `usr.sbin/bsdinstall/scripts/auto` 行369-385（PMODES構築・アーキテクチャ判定）
- E-03: `usr.sbin/bsdinstall/scripts/auto` 行387-393（bsddialog menu）
- E-04: `usr.sbin/bsdinstall/scripts/auto` 行395-422（case分岐・後続処理）
- E-05: `usr.sbin/bsdinstall/scripts/auto` 行280-367（ハードウェアワークアラウンド）
- E-06: `usr.sbin/bsdinstall/scripts/auto` 行271-272（PATH_FSTAB初期化）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` 行16（画面定義）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行26-28（機能マッピング）
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md` 行29-32（遷移先）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのパーティション方式から選択する | E-01, E-02 | ○ |
| C-02 | ZFSはamd64/arm64/i386/riscvのみ表示 | E-02 | ○ |
| C-03 | Auto ZFS選択でzfsbootが呼ばれる | E-04 (行397) | ○ |
| C-04 | Auto UFS選択でautopartが呼ばれる | E-04 (行401) | ○ |
| C-05 | Manual選択でparteditが呼ばれる | E-04 (行411-416) | ○ |
| C-06 | Shell選択でshが起動される | E-04 (行407) | ○ |
| C-07 | item-helpが各メニュー項目に付与される | E-03 (行390) | ○ |
| C-08 | ハードウェアワークアラウンドが検出される | E-05 | ○ |
| C-09 | Lenovo ThinkPad等の既知問題が検出される | E-05 (行296-307) | ○ |
| C-10 | Cancel/ESCでexit 1 | E-03 (行392) | ○ |
| C-11 | パーティション設定失敗でerror関数が呼ばれる | E-04 | ○ |
| C-12 | PATH_FSTABが事前に初期化される | E-06 | ○ |
| C-13 | 主機能はGEOMストレージフレームワーク | E-08 | ○ |
| C-14 | ZFS遷移先機能が定義されている | E-08 | ○ |
| C-15 | UFS遷移先機能が定義されている | E-08 | ○ |
| C-16 | Shell選択後にmount_auxが実行される | E-04 (行408) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全項目を直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ハードウェアワークアラウンドの対象機種リストが最新であることを確認
- [ ] ZFS対応アーキテクチャリストが最新であることを確認
