---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：16-ZFSブート設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **暗号化有効時のブートプール自動有効化**：コード内のコメントから推測

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/zfsboot` 行39-183（ZFSBOOT_*設定変数群）
- E-02: `usr.sbin/bsdinstall/scripts/zfsboot` 行338-416（dialog_menu_main関数）
- E-03: `usr.sbin/bsdinstall/scripts/zfsboot` 行490-749（dialog_menu_layout関数）
- E-04: `usr.sbin/bsdinstall/scripts/zfsboot` 行1018-1452（zfs_create_boot関数）
- E-05: `usr.sbin/bsdinstall/scripts/zfsboot` 行761-1011（zfs_create_diskpart関数）
- E-06: `usr.sbin/bsdinstall/scripts/zfsboot` 行1534-1552（ブートタイプ自動検出）
- E-07: `usr.sbin/bsdinstall/scripts/zfsboot` 行1521-1529（プール名重複チェック）
- E-08: `usr.sbin/bsdinstall/scripts/zfsboot` 行1267-1278（RAID-10実装）
- E-09: `usr.sbin/bsdinstall/scripts/zfsboot` 行145-176（デフォルトデータセット）
- E-10: `usr.sbin/bsdinstall/scripts/zfsboot` 行424-483（dialog_last_chance関数）
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` 行17（画面定義）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行29-32（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ZFSプールの各種設定を対話的に行う | E-02 | ○ |
| C-02 | 6種類のvdevタイプに対応 | E-03 (行497-504) | ○ |
| C-03 | デフォルトプール名はzroot | E-01 (行44) | ○ |
| C-04 | デフォルトスワップサイズは2g | E-01 (行127) | ○ |
| C-05 | Force 4K Sectorsのデフォルトは有効 | E-01 (行74) | ○ |
| C-06 | geli暗号化のデフォルトは無効 | E-01 (行80) | ○ |
| C-07 | プール名重複時に名前変更ダイアログが表示される | E-07 | ○ |
| C-08 | arm64/riscvではUEFIのみサポート | E-06 (行1535-1538) | ○ |
| C-09 | machdep.bootmethodから自動検出される | E-06 (行1542-1543) | ○ |
| C-10 | Last Chance確認ダイアログがある | E-10 | ○ |
| C-11 | RAID-10はstripeされたミラーとして実装 | E-08 | ○ |
| C-12 | デフォルトデータセットにBEルートが含まれる | E-09 | ○ |
| C-13 | zfs_enable="YES"がrc.confに書き込まれる | E-04 (行1380-1381) | ○ |
| C-14 | fstabにスワップエントリが書き込まれる | E-05 (行983-1008) | ○ |
| C-15 | 暗号化時にAES-NI kernel moduleがロードされる | E-04 (行1185) | ○ |
| C-16 | ディスクサイズの妥当性チェックがある | E-04 (行1589-1621相当) | ○ |
| C-17 | ZFSプール作成オプションのデフォルトは compression=on, atime=off | E-01 (行54) | ○ |
| C-18 | Cancel選択でf_dieが呼ばれる | E-02 (行1568) | ○ |
| C-19 | 暗号化有効時にブートプールが自動有効化される | E-01 (行78-79 コメント) | △ |
| C-20 | 主機能はZFS（機能No.12） | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-19: 暗号化有効時のブートプール自動有効化はコメント（"NB: Automatically enables ZFSBOOT_BOOT_POOL"）に記述されているが、実際のトグル処理（行1670-1677）ではZFSBOOT_GELI_ENCRYPTION=1設定時にZFSBOOT_BOOT_POOL変数が明示的にセットされるコードが見当たらない。zfs_create_boot内の条件分岐で暗黙的に処理される可能性がある。
  - 候補：zfs_create_boot関数の暗号化関連処理の詳細確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - zfsbootスクリプトは1756行の大規模スクリプトであり、全ての条件分岐を網羅的に検証することは困難
- 0: 低リスク - 主要な設定項目とそのデフォルト値はソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 暗号化有効時のブートプール自動有効化の動作を実機で確認
- [ ] RAID-10のディスク数偶数チェックが正しいことを確認
- [ ] パーティションスキームのトグル順序（GPT BIOS -> UEFI -> BIOS+UEFI -> GPT+Active -> GPT+Lenovo Fix）を確認
