---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：17-手動パーティション編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **gpart_ops.c等の実装ファイル**：partedit.cからincludeされるが実装は未確認
  2. **part_wizard.cの実装**：Auto機能の詳細実装が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/partedit/partedit.c` 行74-232（main関数）
- E-02: `usr.sbin/bsdinstall/partedit/partedit.c` 行339-457（apply_changes関数）
- E-03: `usr.sbin/bsdinstall/partedit/partedit.c` 行499-524（read_geom_mesh関数）
- E-04: `usr.sbin/bsdinstall/partedit/partedit.c` 行278-321（validate_setup関数）
- E-05: `usr.sbin/bsdinstall/partedit/partedit.c` 行58-72（sigint_handler関数）
- E-06: `usr.sbin/bsdinstall/partedit/partedit.h` 行45-54（partition_metadata構造体）
- E-07: `usr.sbin/bsdinstall/partedit/diskmenu.h` 行32-52（partedit_item構造体・ボタン定義）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` 行18（画面定義）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行33-35（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GEOMフレームワークでパーティションを手動編集する | E-01, E-03 | ○ |
| C-02 | Create/Delete/Modify/Revert/Auto/Finishの6ボタンがある | E-07, E-01 | ○ |
| C-03 | GEOMメッシュからディスク階層を読み取る | E-03 | ○ |
| C-04 | partition_metadata構造体でfstabとnewfsを管理する | E-06 | ○ |
| C-05 | sadeモードで動作可能 | E-01 (行86-87) | ○ |
| C-06 | autopartモードで動作可能 | E-01 (行103-111) | ○ |
| C-07 | SIGINTで全変更がリバートされる | E-05 | ○ |
| C-08 | Finish時にvalidate_setupでルートパーティションを確認する | E-04 | ○ |
| C-09 | apply_changesでgpart_commitとnewfsとfstab生成を行う | E-02 | ○ |
| C-10 | fstabエントリがマウントポイント順にソートされる | E-02 (行410-431) | ○ |
| C-11 | ルートパーティション未設定でバリデーションエラー | E-04 (行294-298) | ○ |
| C-12 | 未フォーマットのルートパーティションで警告が表示される | E-04 (行306-317) | ○ |
| C-13 | bsddialogライブラリを直接使用する | E-01 | ○ |
| C-14 | libgeomでGEOM情報を取得する | E-03 | ○ |
| C-15 | Finish確認ダイアログにCommit/Revert&Exit/Backの3選択肢がある | E-01 (行186-209) | ○ |
| C-16 | mixedgaugeで初期化進捗を表示する | E-02 (行375-377) | ○ |
| C-17 | gpart_ops.cにgpart操作の実装がある | **根拠なし** | △ |
| C-18 | part_wizard.cにAuto機能の実装がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17, C-18: partedit.hで宣言されている関数（gpart_create, gpart_delete, gpart_edit, part_wizard等）の実装ファイルは推定であり、実際のファイル存在は未確認
  - 候補：`usr.sbin/bsdinstall/partedit/` ディレクトリ内のファイル一覧確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - C言語実装のため、gpart操作の詳細（gpart_ops.c等）は本レポートの範囲外
- 0: 低リスク - メイン処理フロー（partedit.c）は完全に解析済み

## 6) レビュアーチェックリスト（最小）
- [ ] gpart_ops.c/diskmenu.c/part_wizard.cの実装を確認
- [ ] scriptedpartモードの引数仕様を確認
- [ ] apply_workaround関数のGPT+Lenovo Fix/GPT+Active処理を確認
