---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-配布ファイル展開画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし。全項目に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/distextract/distextract.c` 行58-162（main関数）
- E-02: `usr.sbin/bsdinstall/distextract/distextract.c` 行251-331（extract_files関数）
- E-03: `usr.sbin/bsdinstall/distextract/distextract.c` 行174-249（count_files関数）
- E-04: `usr.sbin/bsdinstall/distextract/distextract.c` 行164-168（sig_int関数）
- E-05: `usr.sbin/bsdinstall/distextract/distextract.c` 行293-296（ARCHIVE_EXTRACTフラグ）
- E-06: `usr.sbin/bsdinstall/distextract/distextract.c` 行143（refresh間隔）
- E-07: `usr.sbin/bsdinstall/distextract/distextract.c` 行144（fmtbottomstr）
- E-08: `usr.sbin/bsdinstall/distextract/distextract.c` 行306（Can't restore time無視）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` 行21（画面定義）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行39-40（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libarchiveを使用して展開する | E-02 | ○ |
| C-02 | progressviewでリアルタイム進捗を表示する | E-01 (行147-149) | ○ |
| C-03 | コールバック形式で展開が実行される | E-02 | ○ |
| C-04 | ARCHIVE_EXTRACT_TIME等6つのフラグで属性を保持する | E-05 | ○ |
| C-05 | エントリ数はMANIFESTまたはarchiveからカウントされる | E-03 | ○ |
| C-06 | 1秒ごとにリフレッシュされる | E-06 | ○ |
| C-07 | 展開速度がfiles/secで表示される | E-07 | ○ |
| C-08 | "Can't restore time"警告は無視される | E-08 | ○ |
| C-09 | SIGINTで中断可能 | E-04 | ○ |
| C-10 | EOF到達でDONEステータスを返す | E-02 (行299-302) | ○ |
| C-11 | エラー時にFAILEDステータスでabort | E-02 (行304-320) | ○ |
| C-12 | BSDINSTALL_CHROOTにchdirする | E-01 (行126) | ○ |
| C-13 | 全アーカイブ形式に対応 | E-02 (行272-273) | ○ |
| C-14 | bsddialog_total_progviewで全体カウントを追跡する | E-02 (行323) | ○ |
| C-15 | 主機能はlibarchive（機能No.92） | E-10 | ○ |
| C-16 | DISTRIBUTIONS環境変数が必須 | E-01 (行73-74) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全処理フローがdistextract.c内に完結しており、ソースコードから完全追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] archive_read_extract のエラーハンドリングが全ケースをカバーしているか確認
- [ ] MANIFESTのエントリ数フォーマット（タブ区切り3列目）を確認
