---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-サービス選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビューが必要な項目はない。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/services` 全体（113行）
- E-02: `usr.sbin/bsdinstall/scripts/auto` 453行目
- E-03: `usr.sbin/bsdinstall/scripts/finalconfig` 75-76行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 26行目（No.25）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 45-49行目
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 56-57行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bsddialogの--checklistウィジェットを使用する | E-01（77行目） | ○ |
| C-02 | sshdのデフォルトはON | E-01（38行目） | ○ |
| C-03 | dumpdevのデフォルトはON | E-01（80行目） | ○ |
| C-04 | --no-cancelでキャンセルボタンなし | E-01（76行目） | ○ |
| C-05 | rc.dスクリプトの存在で表示項目が決まる | E-01（45, 50, 57, 63, 69行目） | ○ |
| C-06 | ntpd_sync_on_startは_enableサフィックスなし | E-01（94-96行目） | ○ |
| C-07 | moused未選択時にmoused_nondefault_enable="NO"を設定 | E-01（102-104行目） | ○ |
| C-08 | dumpdevはAUTO/NOで設定 | E-01（108-112行目） | ○ |
| C-09 | rc.conf.servicesに書き出す | E-01（99行目） | ○ |
| C-10 | autoスクリプト453行目から呼び出される | E-02 | ○ |
| C-11 | BSDINSTALL_SKIP_SERVICES設定時は省略される | E-02 | ○ |
| C-12 | finalconfigからServices選択で再呼び出し可能 | E-03 | ○ |
| C-13 | 関連機能にinit/rc（No.69）を含む | E-05 | ○ |
| C-14 | 関連機能にSSH（No.51）を含む | E-05 | ○ |
| C-15 | 既存rc.conf.servicesの読み込みで前回値を復元 | E-01（33-39行目） | ○ |
| C-16 | --separate-outputで1行1項目出力 | E-01（76行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張がソースコードにより確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] サービス一覧とデフォルト値がソースコードと一致するか確認
- [ ] dumpdevの特別処理が正確に記述されているか確認
- [ ] rc.conf.servicesへの書き出しフォーマットが正確か確認
