---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-セキュリティ強化設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビューが必要な項目はない。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/hardening` 全体（94行）
- E-02: `usr.sbin/bsdinstall/scripts/auto` 454行目
- E-03: `usr.sbin/bsdinstall/scripts/finalconfig` 77-78行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 27行目（No.26）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 50-53行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 10項目のチェックリストを表示する | E-01（42-51行目） | ○ |
| C-02 | 全オプションのデフォルトはOFF | E-01（42-51行目: off指定） | ○ |
| C-03 | hide_uidsはsecurity.bsd.see_other_uids=0を設定 | E-01（62-63行目） | ○ |
| C-04 | hide_gidsはsecurity.bsd.see_other_gids=0を設定 | E-01（65-66行目） | ○ |
| C-05 | hide_jailはsecurity.bsd.see_jail_proc=0を設定 | E-01（68-69行目） | ○ |
| C-06 | read_msgbufはunprivileged_read_msgbuf=0を設定 | E-01（71-72行目） | ○ |
| C-07 | proc_debugはunprivileged_proc_debug=0を設定 | E-01（74-75行目） | ○ |
| C-08 | random_pidはkern.randompid=1を設定 | E-01（77-78行目） | ○ |
| C-09 | clear_tmpはclear_tmp_enable="YES"を設定 | E-01（80-81行目） | ○ |
| C-10 | disable_syslogdはsyslogd_flags="-ss"を設定 | E-01（83-84行目） | ○ |
| C-11 | secure_consoleはttysのsecure→insecure置換 | E-01（86-87行目） | ○ |
| C-12 | disable_ddtraceはallow_destructive_dtrace=0を設定 | E-01（89-90行目） | ○ |
| C-13 | 3つのhardeningファイルを初期化する | E-01（33-35行目） | ○ |
| C-14 | --nocancelでキャンセルボタンなし | E-01（39行目） | ○ |
| C-15 | BSDINSTALL_SKIP_HARDENING設定時は省略される | E-02 | ○ |
| C-16 | 関連機能にMAC（No.44）を含む | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張がソースコードにより確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 10項目のセキュリティオプションとその設定値がソースコードと一致するか確認
- [ ] secure_consoleのsed置換パターンが正確に記述されているか確認
- [ ] 各設定ファイルへの振り分けが正しいか確認
