---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-インストール種別選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/auto` (200-269行目)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (3行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (5行目)
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` (11行目: INSTALLTYPE分岐)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ホスト名設定画面の次に表示 | E-01 (auto:198-208行目) | ○ |
| C-02 | MANIFESTなし時はpkgbase自動選択 | E-01 (auto:208-209行目) | ○ |
| C-03 | Yes/NoダイアログでDistSets/Packages選択 | E-01 (auto:211-214行目 bsddialog --yesno) | ○ |
| C-04 | Yes-labelが"Distribution Sets" | E-01 (auto:212行目 --yes-label) | ○ |
| C-05 | No-labelが"Packages" | E-01 (auto:212行目 --no-label) | ○ |
| C-06 | ローカルパッケージ確認パス | E-01 (auto:200行目 /usr/freebsd-packages/repos/) | ○ |
| C-07 | HAVE_BASE_PACKAGES=yes時にdefault-no | E-01 (auto:202行目 PKGBASE_DEFAULT_BUTTON) | ○ |
| C-08 | 戻り値1でPKGBASE=yes | E-01 (auto:215-217行目) | ○ |
| C-09 | DistSets時にDISTRIBUTIONS設定 | E-01 (auto:238行目) | ○ |
| C-10 | DistSets時にMANIFESTからオプション解析 | E-01 (auto:240行目 awk) | ○ |
| C-11 | Packages時にネットワーク/オフライン選択へ | E-01 (auto:220-236行目) | ○ |
| C-12 | 関連機能No.74パッケージ管理支援 | E-03 (マッピング:5行目) | ○ |
| C-13 | Distribution Sets/Packagesの2択 | E-04 (遷移図:13-14行目) | ○ |
| C-14 | タイトルが"Select Installation Type" | E-01 (auto:211行目) | ○ |
| C-15 | プロンプト文言 | E-01 (auto:214行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - autoスクリプト内の該当部分を直接参照して検証済み
- 0: 低リスク - 画面遷移は画面遷移図と整合

## 6) レビュアーチェックリスト（最小）
- [ ] PKGBASE_DEFAULT_BUTTONの実際の動作（--default-noの効果）を確認
- [ ] MANIFESTファイルのフォーマットと実際の内容を確認
