---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：31-ドキュメントインストール画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **pkg installエラー時の挙動**：エラーハンドリングが明示的に記述されていないため、実際の挙動は推定
  2. **Cancel時のf_die動作**：f_dieの実装はbsdconfigライブラリ内にあり直接確認していない
  3. **対応パッケージ名形式**：`{lang}-freebsd-doc` の形式はコードから読み取れるが、実際のpkgリポジトリとの整合性は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `usr.sbin/bsdinstall/scripts/docsinstall` 行1-167（本画面のメインスクリプト）
- E-02: `usr.sbin/bsdinstall/scripts/finalconfig` 行1-91（呼び出し元スクリプト）
- E-03: `usr.sbin/bsdinstall/scripts/auto` 行463（finalconfigの呼び出し箇所）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行32（画面No.31の定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行63-64（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` 行119,129（最終設定メニューサブフロー）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 本画面はFreeBSDドキュメントセットを言語別に選択してインストールする | E-01 行57,157-162 | ○ |
| C-02 | 最終設定メニューの「Handbook」から遷移する | E-02 行50,87-88 | ○ |
| C-03 | 対応言語は20言語（bn,da,de,el,en,es,fr,hu,id,it,ja,ko,mn,nl,pl,pt,ru,tr,zh_cn,zh_tw） | E-01 行43-45 | ○ |
| C-04 | 英語はデフォルトON、他言語はデフォルトOFF | E-01 行101-104 | ○ |
| C-05 | チェックリスト形式のダイアログを使用 | E-01 行119-130 | ○ |
| C-06 | パッケージ名は{lang}-freebsd-doc形式 | E-01 行159 | ○ |
| C-07 | ASSUME_ALWAYS_YES=YESでpkg確認を抑制 | E-01 行162 | ○ |
| C-08 | chroot環境内でpkg installを実行 | E-01 行162 | ○ |
| C-09 | resolv.confをコピーしてDNS解決を準備 | E-01 行152 | ○ |
| C-10 | DOCSINSTALL_LANGS環境変数でカスタマイズ可能 | E-01 行43-45 | ○ |
| C-11 | bsdconfigのcommon.subr/dialog.subr/mustberoot.subr/packages.subrに依存 | E-01 行31-36 | ○ |
| C-12 | f_dialog_titleでタイトル設定 | E-01 行141 | ○ |
| C-13 | f_dialog_checklist_sizeでサイズ自動計算 | E-01 行112-117 | ○ |
| C-14 | f_dialog_menutag_storeで選択結果保存 | E-01 行132 | ○ |
| C-15 | f_dialog_menutag_fetchで選択結果取得 | E-01 行149 | ○ |
| C-16 | Cancel時はf_dieで終了 | E-01 行148 | ○ |
| C-17 | ネットワーク接続が必要 | E-02 行50 | ○ |
| C-18 | BSDINSTALL_SKIP_FINALCONFIGで省略可能（間接的） | E-03 行463 | ○ |
| C-19 | 各言語の表示名はmsg_*doc_desc変数で定義 | E-01 行53-77 | ○ |
| C-20 | pkg installエラー時にスクリプト側でのエラーハンドリングは行われない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: docsinstallスクリプトには pkg install の戻り値チェックが存在しない。これはコードに「ないこと」の根拠であり、明示的な設計意図は不明
  - 候補：開発者のコミットログ / FreeBSD開発者メーリングリスト / bsdinstallの設計文書

## 5) リスクフラグ（レビュー観点）
- 0: 画面遷移の記述 -- 低リスク。ソースコードから明確に確認可能
- 0: 言語一覧の記述 -- 低リスク。ソースコードに直接定義されている
- 1: エラーハンドリングの記述 -- 中リスク。pkg installの失敗時の挙動が明示的にハンドリングされていない
- 0: パッケージ名形式 -- 低リスク。ソースコードの文字列連結から確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 対応言語20言語のリストがソースコード（docsinstall行43-45）と一致しているか確認
- [ ] パッケージ名形式 `{lang}-freebsd-doc` が実際の pkg リポジトリと一致するか確認
- [ ] pkg install 失敗時のユーザ体験が許容可能か確認
- [ ] ネットワーク未設定時の動作が最終設定メニューの "requires network" 表記と整合しているか確認
