---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ネットワーク/オフラインインストール選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/auto` (220-236行目)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (4行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (6-7行目)
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` (16-21行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pkgbase選択時に表示 | E-01 (auto:220行目 PKGBASE==yes) | ○ |
| C-02 | ローカルパッケージがある場合のみ表示 | E-01 (auto:221行目 HAVE_BASE_PACKAGES==yes) | ○ |
| C-03 | Yes-labelが"Network" | E-01 (auto:223行目) | ○ |
| C-04 | No-labelが"Offline (Limited Packages)" | E-01 (auto:223行目) | ○ |
| C-05 | Offline選択時にBSDINSTALL_PKG_REPOS_DIR設定 | E-01 (auto:226行目 export) | ○ |
| C-06 | Network選択時にbsdinstall netconfig呼び出し | E-01 (auto:228行目) | ○ |
| C-07 | Network選択時にNETCONFIG_DONE=yes | E-01 (auto:229行目) | ○ |
| C-08 | ローカルパッケージなし時はmsgbox表示 | E-01 (auto:232-233行目) | ○ |
| C-09 | ローカルパッケージなし時はnetconfigに自動遷移 | E-01 (auto:234行目) | ○ |
| C-10 | netconfig失敗時にerror()呼び出し | E-01 (auto:228行目 `|| error`) | ○ |
| C-11 | 関連機能No.74パッケージ管理支援 | E-03 (マッピング:6行目) | ○ |
| C-12 | 関連機能No.35ネットワークインタフェース管理 | E-03 (マッピング:7行目) | ○ |
| C-13 | 画面遷移がNetwork/Offlineで分岐 | E-04 (遷移図:19-20行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - autoスクリプト内の該当部分を直接参照して検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] BSDINSTALL_PKG_REPOS_DIRのexportが後続処理で正しく参照されるか確認
- [ ] ローカルパッケージリポジトリの実際のディレクトリ構造を確認
