---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：5-配布セット選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **MANIFESTファイルのフォーマット詳細**：MANIFESTファイルの実体を未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/auto` (238-268行目)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (5行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (8行目)
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` (13行目, 24-27行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Distribution Sets選択時に表示 | E-01 (auto:237行目 else) | ○ |
| C-02 | DISTRIBUTIONS初期値がbase.txz kernel.txz | E-01 (auto:238行目) | ○ |
| C-03 | awkでMANIFESTからbase/kernel除外 | E-01 (auto:240行目) | ○ |
| C-04 | sedで.txz拡張子除去 | E-01 (auto:241行目) | ○ |
| C-05 | bsddialog --checklistで表示 | E-01 (auto:245-250行目) | ○ |
| C-06 | --nocancelでキャンセル不可 | E-01 (auto:247行目) | ○ |
| C-07 | --separate-outputで改行区切り出力 | E-01 (auto:247行目) | ○ |
| C-08 | 選択結果に.txz付与してDISTRIBUTIONSに追加 | E-01 (auto:251-253行目) | ○ |
| C-09 | 未取得ファイルをFETCH_DISTRIBUTIONSに設定 | E-01 (auto:257-262行目) | ○ |
| C-10 | 未取得ファイルあり時にnetconfigへ遷移 | E-01 (auto:264-268行目) | ○ |
| C-11 | 関連機能No.74パッケージ管理支援 | E-03 (マッピング:8行目) | ○ |
| C-12 | DISTMENUが空の場合はチェックリスト非表示 | E-01 (auto:243行目 if条件) | ○ |
| C-13 | MANIFESTタブ区切りカラム1がファイル名 | E-01 (auto:240行目 awk -F'\t') | ○ |
| C-14 | MANIFESTカラム5と6が説明とデフォルト値 | E-01 (auto:240行目 $5,$6) だがMANIFEST実体未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- MANIFESTファイルの実際の内容を未確認。awkの$5,$6の解釈はコードからの推定
  - 候補：実際のFreeBSDインストールメディアのMANIFESTファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - autoスクリプト内の処理フローはコードに基づいて正確に記述
- 1: 中リスク - MANIFESTファイルのカラム解釈は推定要素あり

## 6) レビュアーチェックリスト（最小）
- [ ] MANIFESTファイルの実際のフォーマット（特にカラム5,6の内容）を確認
- [ ] lib32.txz、tests.txz等の実際のオプション配布セットの一覧を確認
