---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-ネットワークインターフェース選択画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/netconfig` (全262行)
- E-02: `usr.sbin/bsdinstall/scripts/auto` (228行目, 266行目, 450行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (6行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (9-10行目)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (75-101行目: ネットワークサブフロー)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ifconfig -lでインターフェース列挙 | E-01 (netconfig:46行目) | ○ |
| C-02 | lo0を除外 | E-01 (netconfig:47行目) | ○ |
| C-03 | wlanグループを除外 | E-01 (netconfig:48行目) | ○ |
| C-04 | sysctl net.wlan.devicesで無線デバイス追加 | E-01 (netconfig:52-53行目) | ○ |
| C-05 | dev.*.%descでデバイス説明取得 | E-01 (netconfig:64行目) | ○ |
| C-06 | bsddialog --menuで表示 | E-01 (netconfig:76-79行目) | ○ |
| C-07 | ok-labelが"Auto" | E-01 (netconfig:78行目) | ○ |
| C-08 | extra-labelが"Manual" | E-01 (netconfig:78行目) | ○ |
| C-09 | Auto時にAUTO=auto設定 | E-01 (netconfig:84行目) | ○ |
| C-10 | Manual時にAUTO空 | E-01 (netconfig:89行目) | ○ |
| C-11 | Cancel時にexit 1 | E-01 (netconfig:86-88行目) | ○ |
| C-12 | 無線時にwlan0作成 | E-01 (netconfig:97-101行目) | ○ |
| C-13 | 無線時にbsdinstall wlanconfig呼び出し | E-01 (netconfig:104行目) | ○ |
| C-14 | kern.features.inetでIPv4サポート確認 | E-01 (netconfig:114-116行目) | ○ |
| C-15 | kern.features.inet6でIPv6サポート確認 | E-01 (netconfig:110-112行目) | ○ |
| C-16 | インターフェースなし時にmsgbox表示 | E-01 (netconfig:68-72行目) | ○ |
| C-17 | ._rc.conf.netをrc.conf.netにリネーム | E-01 (netconfig:261行目 mv) | ○ |
| C-18 | 関連機能No.35, No.34 | E-04 (マッピング:9-10行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - netconfigスクリプト全体を読み込んで検証済み
- 0: 低リスク - 画面遷移はネットワーク設定サブフロー図と整合

## 6) レビュアーチェックリスト（最小）
- [ ] xargsによるexit code折りたたみ問題（Manual/Cancel区別）の実際の動作確認
- [ ] DNS設定部分（160-261行目）の詳細な動作確認
