---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-無線LAN設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/bsdinstall/scripts/wlanconfig` (全371行)
- E-02: `usr.sbin/bsdinstall/scripts/netconfig` (96-106行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (7行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (11-13行目)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (78行目: WIRELESS_CHECK -> WLAN)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | wpa_supplicantを使用 | E-01 (wlanconfig:173-175行目) | ○ |
| C-02 | wpa_supplicant.confを生成 | E-01 (wlanconfig:152-161行目) | ○ |
| C-03 | パーミッション0600 | E-01 (wlanconfig:153行目) | ○ |
| C-04 | WPA-PSK/WPA-EAP/WEP/Open対応 | E-01 (wlanconfig:275,295,320,342行目) | ○ |
| C-05 | wpa_cli scanでスキャン実行 | E-01 (wlanconfig:209行目) | ○ |
| C-06 | 5秒待機 | E-01 (wlanconfig:211行目 f_dialog_pause 5) | ○ |
| C-07 | wpa_cli scan_resultsで結果取得 | E-01 (wlanconfig:214行目) | ○ |
| C-08 | regdomain/country選択機能 | E-01 (wlanconfig:80-148行目 dialog_country_select) | ○ |
| C-09 | CONFIGCURRENT時のみregdomain設定 | E-01 (wlanconfig:185行目 if条件) | ○ |
| C-10 | country_set関数でifconfig適用 | E-01 (wlanconfig:38-78行目) | ○ |
| C-11 | rc.conf.net.wlanにcreate_args保存 | E-01 (wlanconfig:72-74行目) | ○ |
| C-12 | Rescanボタン対応 | E-01 (wlanconfig:231行目 --extra-label Rescan) | ○ |
| C-13 | 手動SSID入力対応 | E-01 (wlanconfig:243-265行目) | ○ |
| C-14 | scan_ssid=1で隠しSSID対応 | E-01 (wlanconfig:264行目) | ○ |
| C-15 | PSKのmixedformでパスワード入力 | E-01 (wlanconfig:276-284行目) | ○ |
| C-16 | EAPのidentity/password設定 | E-01 (wlanconfig:308-316行目) | ○ |
| C-17 | WEPのwep_key0設定 | E-01 (wlanconfig:331-341行目) | ○ |
| C-18 | オープンネットワークポリシー追加 | E-01 (wlanconfig:355-359行目 priority=0) | ○ |
| C-19 | wpa_cli reconfigureで適用 | E-01 (wlanconfig:364行目) | ○ |
| C-20 | 関連機能No.35, No.55, No.110 | E-04 (マッピング:11-13行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - wlanconfigスクリプト全体を読み込んで網羅的に検証済み
- 0: 低リスク - 4つの認証方式すべてのコードパスを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] regdomain/country適用時のインターフェースdown/up処理の実際の動作確認
- [ ] wpa_supplicant.confのネットワークブロック構文の正確性確認
- [ ] 暗号化方式判定のgrep -q PSK/EAP/WEPの正確性確認
