---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 42
  claims_without_evidence: 8
confidence_derived: 0.84
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：42 / 50、根拠なし：8
- 優先レビュー（高）
  1. **IT-019（UFS連携テスト）**：UFS固有のテストコードが tests/ 配下で確認できず、テスト手順はソースコード構造からの推測
  2. **IT-022（NFS連携テスト）**：NFSクライアント・サーバ連携の自動テストがリポジトリ内で未確認
  3. **IT-032（devfs連携テスト）**：devfsデバイスライフサイクルの統合テストが tests/ 配下で未確認
  4. **IT-035（sendfile連携テスト）**：sendfile固有の統合テストコードが未確認
  5. **IT-041（モジュールロード連携テスト）**：カーネルリンカの結合テストが tests/ 配下で未確認
  6. **IT-049（VMM連携テスト）**：bhyve VMMテストの範囲が限定的
  7. **IT-050（サウンド連携テスト）**：サウンドデバイステストの実機依存性が高い
  8. **IT-048（WireGuard連携テスト）**：テストスクリプトは存在するが手順の詳細は推測を含む

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/kern/kern_descrip.c` - ファイルディスクリプタ管理
- E-02: `sys/kern/vfs_syscalls.c` - VFSシステムコール
- E-03: `sys/kern/kern_fork.c` - プロセスfork処理
- E-04: `sys/vm/` - 仮想メモリサブシステム
- E-05: `sys/kern/kern_sig.c` - シグナル処理
- E-06: `sys/kern/kern_proc.c` - プロセス管理
- E-07: `sys/netinet/tcp_input.c`, `sys/netinet/tcp_output.c` - TCP実装
- E-08: `sys/kern/uipc_socket.c` - ソケット実装
- E-09: `sys/netinet/udp_usrreq.c` - UDP実装
- E-10: `tests/sys/net/if_bridge_test.sh` - ブリッジテストスクリプト
- E-11: `sys/net/if_bridge.c` - ブリッジ実装
- E-12: `tests/sys/net/if_lagg_test.sh` - LAGGテストスクリプト
- E-13: `sys/net/if_lagg.c` - LAGG実装
- E-14: `tests/sys/net/if_vlan.sh` - VLANテストスクリプト
- E-15: `sys/net/if_vlan.c` - VLAN実装
- E-16: `tests/sys/net/if_gif.sh` - GIFテストスクリプト
- E-17: `sys/net/if_gif.c` - GIFトンネル実装
- E-18: `tests/sys/net/routing/` - ルーティングテストディレクトリ
- E-19: `sys/netinet/in_fib.c` - IPv4 FIB実装
- E-20: `tests/sys/netinet6/ndp.sh` - NDPテストスクリプト
- E-21: `sys/netinet6/nd6.c` - IPv6近隣探索実装
- E-22: `tests/sys/netinet6/ra.py` - ルータ広告テスト
- E-23: `sys/netinet6/nd6_rtr.c` - ルータ広告処理実装
- E-24: `tests/sys/netipsec/tunnel/` - IPsecトンネルテストディレクトリ
- E-25: `sys/netipsec/` - IPsec実装ディレクトリ
- E-26: `tests/sys/netpfil/pf/` - pfテストディレクトリ
- E-27: `sys/netpfil/pf/` - pf実装ディレクトリ
- E-28: `tests/sys/netpfil/ipfw/` - ipfwテスト（ディレクトリ存在確認済み）
- E-29: `tests/sys/netlink/test_rtnl_route.py` - Netlinkルーティングテスト
- E-30: `tests/sys/netlink/test_rtnl_iface.py` - Netlinkインターフェーステスト
- E-31: `tests/sys/netgraph/` - Netgraphテストディレクトリ
- E-32: `sys/fs/tmpfs/` - tmpfs実装
- E-33: `tests/sys/fs/tmpfs/` - tmpfsテストディレクトリ
- E-34: `tests/sys/fs/fusefs/` - FUSEテストディレクトリ
- E-35: `sys/fs/fuse/` - FUSE実装
- E-36: `sys/fs/nfsclient/`, `sys/fs/nfsserver/` - NFS実装
- E-37: `tests/sys/fs/unionfs/` - unionfsテストディレクトリ
- E-38: `tests/sys/fs/tarfs/` - tarfsテストディレクトリ
- E-39: `tests/sys/kqueue/` - kqueueテストディレクトリ
- E-40: `sys/kern/kern_event.c` - kqueue実装
- E-41: `tests/sys/capsicum/` - Capsicumテストディレクトリ
- E-42: `sys/kern/kern_jail.c` - jail実装
- E-43: `tests/sys/mac/bsdextended/` - MAC bsdextendedテスト
- E-44: `tests/sys/audit/` - 監査テストディレクトリ
- E-45: `tests/sys/geom/` - GEOMテストディレクトリ
- E-46: `tests/sys/opencrypto/` - OpenCryptoテストディレクトリ
- E-47: `tests/sys/net/bpf/` - BPFテスト（ディレクトリ存在）
- E-48: `tests/sys/kern/ktls_test.c` - KTLSテストコード
- E-49: `tests/sys/aio/` - AIOテストディレクトリ
- E-50: `tests/sys/posixshm/` - POSIX共有メモリテスト
- E-51: `tests/sys/mqueue/` - メッセージキューテスト
- E-52: `tests/sys/acl/` - ACLテストディレクトリ
- E-53: `tests/sys/kern/ktrace_test.c` - ktraceテストコード
- E-54: `tests/sys/kern/copy_file_range.c` - copy_file_rangeテスト
- E-55: `tests/sys/kern/execve/` - execveテストディレクトリ
- E-56: `tests/sys/netinet/carp.sh` - CARPテストスクリプト
- E-57: `tests/sys/netinet/divert.sh` - divertテストスクリプト
- E-58: `tests/sys/netinet/multicast.sh` - マルチキャストテスト
- E-59: `tests/sys/net/if_wg.sh` - WireGuardテストスクリプト
- E-60: `tests/sys/vmm/` - VMMテストディレクトリ
- E-61: `tests/sys/sound/` - サウンドテストディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: プロセスからのファイルシステム操作連携 | E-01, E-02 | ○ |
| C-02 | IT-002: fork時のメモリ空間複製連携 | E-03, E-04 | ○ |
| C-03 | IT-003: プロセス間シグナル送受信連携 | E-05, E-06 | ○ |
| C-04 | IT-004: TCP接続確立からデータ送受信連携 | E-07, E-08 | ○ |
| C-05 | IT-005: UDPデータグラム送受信連携 | E-09, E-08 | ○ |
| C-06 | IT-006: ブリッジインターフェース間フレーム転送 | E-10, E-11 | ○ |
| C-07 | IT-007: LAGG集約インターフェース冗長切替 | E-12, E-13 | ○ |
| C-08 | IT-008: VLANタグ付きフレーム送受信 | E-14, E-15 | ○ |
| C-09 | IT-009: GIFトンネルインターフェース連携 | E-16, E-17 | ○ |
| C-10 | IT-010: ルーティングテーブル操作とパケット転送 | E-18, E-19 | ○ |
| C-11 | IT-011: IPv6近隣探索プロトコル連携 | E-20, E-21 | ○ |
| C-12 | IT-012: IPv6ルータ広告受信とアドレス自動設定 | E-22, E-23 | ○ |
| C-13 | IT-013: IPsecトンネルモード暗号化通信 | E-24, E-25 | ○ |
| C-14 | IT-014: pfファイアウォールルール適用 | E-26, E-27 | ○ |
| C-15 | IT-015: ipfwファイアウォールルール適用 | E-28 | ○ |
| C-16 | IT-016: Netlinkソケットによるルーティング情報取得 | E-29 | ○ |
| C-17 | IT-017: Netlinkソケットによるインターフェース情報取得 | E-30 | ○ |
| C-18 | IT-018: Netgraphノード間データ転送 | E-31 | ○ |
| C-19 | IT-019: UFSファイルシステムマウント・操作 | **根拠なし** | △ |
| C-20 | IT-020: tmpfsマウントとメモリ管理 | E-32, E-33 | ○ |
| C-21 | IT-021: FUSEユーザ空間ファイルシステム連携 | E-34, E-35 | ○ |
| C-22 | IT-022: NFSクライアント・サーバ連携 | E-36 | △ |
| C-23 | IT-023: unionfsレイヤ統合 | E-37 | ○ |
| C-24 | IT-024: tarfsアーカイブマウント | E-38 | ○ |
| C-25 | IT-025: kqueueイベント通知連携 | E-39, E-40 | ○ |
| C-26 | IT-026: Capsicumケーパビリティモード制限 | E-41 | ○ |
| C-27 | IT-027: jail環境ネットワーク分離 | E-42 | ○ |
| C-28 | IT-028: jail環境ファイルシステム分離 | E-42 | ○ |
| C-29 | IT-029: MACフレームワークアクセス制御 | E-43 | ○ |
| C-30 | IT-030: 監査サブシステムファイル操作記録 | E-44 | ○ |
| C-31 | IT-031: GEOMストレージフレームワーク | E-45 | ○ |
| C-32 | IT-032: devfsデバイスファイルシステムアクセス | **根拠なし** | △ |
| C-33 | IT-033: OpenCryptoフレームワーク暗号処理 | E-46 | ○ |
| C-34 | IT-034: BPFパケットキャプチャ | E-47 | ○ |
| C-35 | IT-035: sendfileゼロコピーデータ転送 | **根拠なし** | △ |
| C-36 | IT-036: カーネルTLS送受信 | E-48 | ○ |
| C-37 | IT-037: 非同期I/O完了通知 | E-49 | ○ |
| C-38 | IT-038: POSIX共有メモリプロセス間連携 | E-50 | ○ |
| C-39 | IT-039: POSIXメッセージキュー | E-51 | ○ |
| C-40 | IT-040: ACLアクセス制御リスト | E-52 | ○ |
| C-41 | IT-041: カーネルモジュールロード・アンロード | **根拠なし** | △ |
| C-42 | IT-042: ktraceシステムコールトレース | E-53 | ○ |
| C-43 | IT-043: copy_file_rangeファイル間コピー | E-54 | ○ |
| C-44 | IT-044: execveプロセスイメージ置換 | E-55 | ○ |
| C-45 | IT-045: CARP仮想IPフェイルオーバー | E-56 | ○ |
| C-46 | IT-046: divertソケットパケット取得 | E-57 | ○ |
| C-47 | IT-047: IGMPマルチキャストグループ管理 | E-58 | ○ |
| C-48 | IT-048: WireGuard VPNトンネル | E-59 | △ |
| C-49 | IT-049: bhyve仮想マシンモニタ | E-60 | △ |
| C-50 | IT-050: サウンドサブシステムデバイス | E-61 | △ |

## 4) 不足情報（Unknown / Missing）
- **IT-019（UFS連携テスト）**：tests/ 配下にUFS固有の結合テストディレクトリが確認できなかった。テスト手順はソースコード（sys/ufs/）の構造から推測して記述。
  - 候補：sys/ufs/ のソースコード分析 / FreeBSD Test Suiteの外部ドキュメント / pjdfstest（POSIX互換性テスト）
- **IT-022（NFS連携テスト）**：NFSの結合テストは環境依存性が高く、リポジトリ内の自動テストが限定的。ソースコード構造のみが根拠。
  - 候補：sys/fs/nfsclient/ のソースコード / sys/fs/nfsserver/ のソースコード / 外部NFS Connectathonテストスイート
- **IT-032（devfs連携テスト）**：devfsのデバイスノードライフサイクルに特化した結合テストが tests/ 配下で未発見。
  - 候補：sys/fs/devfs/ のソースコード / sys/kern/kern_conf.c / devfs(5)マニュアルページ
- **IT-035（sendfile連携テスト）**：sendfile固有の結合テストが tests/ 配下で未確認。
  - 候補：sys/kern/kern_sendfile.c のソースコード / sendfile(2)マニュアルページ
- **IT-041（モジュールロード連携テスト）**：カーネルリンカの結合テストが tests/ 配下で未確認。
  - 候補：sys/kern/kern_linker.c / sys/kern/kern_module.c / kldload(2)マニュアルページ
- **IT-048（WireGuard）**：テストスクリプト（if_wg.sh）は存在するが、手順の詳細は部分的に推測を含む。
  - 候補：tests/sys/net/if_wg.sh の詳細確認 / sys/dev/wg/ のソースコード
- **IT-049（VMM）**：tests/sys/vmm/ の存在は確認したが、テスト範囲が限定的である可能性がある。
  - 候補：tests/sys/vmm/ の詳細確認 / sys/amd64/vmm/ のソースコード
- **IT-050（サウンド）**：tests/sys/sound/ の存在は確認したが、実機依存テストが多く自動化範囲が不明。
  - 候補：tests/sys/sound/ の詳細確認 / sys/dev/sound/ のソースコード

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**：IT-022（NFS連携）- ネットワークファイルシステムのテストは環境依存性が非常に高く、手順の正確性を実環境で検証する必要がある
- **リスク1（中）**：IT-019（UFS連携）- FreeBSD標準ファイルシステムの結合テストが tests/ 配下で明示的に存在しないため、テスト手順の妥当性を確認すべき
- **リスク1（中）**：IT-032（devfs連携）- デバイスファイルシステムのライフサイクルテストの手順はソースコードからの推測に依存
- **リスク1（中）**：IT-041（モジュールロード連携）- カーネルモジュール管理は安定性に影響する重要な機能だが、専用の結合テストが未確認
- **リスク1（中）**：IT-049（VMM連携）- ハードウェア仮想化テストはCPU機能依存であり、テスト環境の制約がある
- **リスク0（低）**：IT-035（sendfile連携）- sendfileの基本動作は広く使われており、暗黙的にテストされている可能性が高い
- **リスク0（低）**：IT-050（サウンド連携）- サウンドサブシステムは実機依存だが、優先度が低い機能である

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの対象機能が、FreeBSDカーネルの主要なサブシステム間連携を網羅しているか
- [ ] 各テストケースの前提条件がテスト環境で実現可能か（特にVNET/jail関連）
- [ ] テスト手順の記述粒度が実際のテスト実施に十分か
- [ ] 期待結果がテスト手順から導出可能で検証可能な記述になっているか
- [ ] 優先度の設定がプロジェクトの品質要件と整合しているか
- [ ] 根拠なし（△）の8件のテストケースについて、テスト手順の妥当性を実機またはソースコードレビューで確認しているか
- [ ] NFS連携テスト（IT-022）のテスト環境要件が明確化されているか
- [ ] セキュリティ関連テスト（Capsicum、jail、MAC、IPsec）のカバレッジが十分か
