---
generated_at: 2026-02-01 00:00:00
metrics:
  claims_total: 49
  claims_with_evidence: 49
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：49 / 49、根拠なし：0
- 優先レビュー（高）
  1. **網羅性の確認**：FreeBSD カーネルは非常に大規模であり、contrib/ 配下やサードパーティモジュール内の通知が網羅されていない可能性がある
  2. **syslog通知の未収録**：syslog経由の通知（LOG_ERR, LOG_WARNING等）は件数が膨大なため本一覧では devctl_notify に限定している
  3. **kqueue/kevent通知の未収録**：kqueueベースのイベント通知は仕組みが異なるため本一覧では対象外としている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/geom/geom_dev.c` - GEOMデバイスの devctl_notify 呼び出し（8箇所）
- E-02: `sys/geom/geom_disk.c` - GEOMディスクの devctl_notify 呼び出し（1箇所）
- E-03: `sys/kern/kern_conf.c` - DEVFS CDEV の devctl_notify 呼び出し（1箇所）
- E-04: `sys/net/if.c` - ネットワークインターフェースの devctl_notify 呼び出し（4箇所）
- E-05: `sys/net/if_ethersubr.c` - イーサネットの devctl_notify 呼び出し（1箇所）
- E-06: `sys/net/if_infiniband.c` - InfiniBandの devctl_notify 呼び出し（1箇所）
- E-07: `sys/net/route.c` - ルーティングの devctl_notify 呼び出し（2箇所）
- E-08: `sys/netinet/ip_carp.c` - CARPの devctl_notify 呼び出し（1箇所）
- E-09: `sys/dev/usb/usb_device.c` - USBの devctl_notify 呼び出し（2箇所）
- E-10: `sys/dev/acpica/acpi.c` - ACPIの devctl_notify 呼び出し（1箇所）
- E-11: `sys/dev/acpica/acpi_video.c` - ACPI Videoの devctl_notify 呼び出し（1箇所）
- E-12: `sys/dev/asmc/asmc.c` - Apple SMCの devctl_notify 呼び出し（2箇所）
- E-13: `sys/powerpc/powermac/pmu.c` - PMUの devctl_notify 呼び出し（4箇所）
- E-14: `sys/arm/allwinner/axp209.c` - AXP209 PMICの devctl_notify 呼び出し（13箇所）
- E-15: `sys/arm/allwinner/axp81x.c` - AXP81x PMICの devctl_notify 呼び出し（10箇所）
- E-16: `sys/arm/ti/am335x/am335x_pmic.c` - TI PMICの devctl_notify 呼び出し（1箇所）
- E-17: `sys/dev/adb/adb_kbd.c` - ADBキーボードの devctl_notify 呼び出し（1箇所）
- E-18: `sys/dev/adb/adb_buttons.c` - ADBボタンの devctl_notify 呼び出し（6箇所）
- E-19: `sys/kern/subr_bus.c` - カーネルバスの devctl_notify 呼び出し（1箇所）
- E-20: `sys/kern/coredump_vnode.c` - コアダンプの devctl_notify 呼び出し（1箇所）
- E-21: `sys/cam/cam_iosched.c` - CAM I/Oスケジューラの devctl_notify 呼び出し（1箇所）
- E-22: `sys/cam/cam_periph.c` - CAM周辺デバイスの devctl_notify 呼び出し（4箇所）
- E-23: `sys/dev/nvme/nvme_ctrlr.c` - NVMeコントローラの devctl_notify 呼び出し（1箇所）
- E-24: `sys/dev/nvmf/host/nvmf.c` - NVMeファブリックの devctl_notify 呼び出し（1箇所）
- E-25: `sys/kern/vfs_mount.c` - VFSマウントの devctl_notify 呼び出し（1箇所）
- E-26: `sys/kern/kern_rctl.c` - リソース制御の devctl_notify 呼び出し（1箇所）
- E-27: `sys/dev/vt/vt_core.c` - 仮想ターミナルの devctl_notify 呼び出し（1箇所）
- E-28: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` - ZFSイベントの devctl_notify 呼び出し（1箇所）
- E-29: `sys/dev/sound/pci/hda/hdaa.c` - HDオーディオの devctl_notify 呼び出し（1箇所）
- E-30: `sys/dev/coretemp/coretemp.c` - CPU温度の devctl_notify 呼び出し（1箇所）
- E-31: `sys/dev/hyperv/netvsc/if_hn.c` - Hyper-Vネットワークの devctl_notify 呼び出し（1箇所）
- E-32: `sys/powerpc/amigaone/platform_amigaone.c` - AmigaOneの devctl_notify 呼び出し（1箇所）
- E-33: `sys/kern/kern_devctl.c` - devctl_notify の定義・実装（中核コード）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GEOM DEV CREATE通知 | E-01 | ○ |
| C-02 | GEOM DEV DESTROY通知 | E-01 | ○ |
| C-03 | GEOM DEV MEDIACHANGE通知 | E-01 | ○ |
| C-04 | GEOM DEV SIZECHANGE通知 | E-01 | ○ |
| C-05 | GEOM disk属性変更通知 | E-02 | ○ |
| C-06 | DEVFS CDEV MEDIACHANGE通知 | E-01 | ○ |
| C-07 | DEVFS CDEV イベント通知 | E-03 | ○ |
| C-08 | IFNET ATTACH通知 | E-04 | ○ |
| C-09 | IFNET DETACH通知 | E-04 | ○ |
| C-10 | IFNET LINK_STATE通知 | E-04 | ○ |
| C-11 | IFNET RENAME通知 | E-04 | ○ |
| C-12 | IFNET ルート変更通知 | E-07 | ○ |
| C-13 | ETHERNET IFATTACH通知 | E-05 | ○ |
| C-14 | INFINIBAND IFATTACH通知 | E-06 | ○ |
| C-15 | CARP状態変更通知 | E-08 | ○ |
| C-16 | USB DEVICE イベント通知 | E-09 | ○ |
| C-17 | USB INTERFACE イベント通知 | E-09 | ○ |
| C-18 | ACPI汎用通知 | E-10 | ○ |
| C-19 | ACPI Video brightness通知 | E-11 | ○ |
| C-20 | ACPI asmc SMS通知 | E-12 | ○ |
| C-21 | PMU lid close通知 | E-13 | ○ |
| C-22 | PMU lid open通知 | E-13 | ○ |
| C-23 | PMU Button pressed通知 | E-13, E-17 | ○ |
| C-24 | PMU POWER ACLINE通知 | E-13 | ○ |
| C-25 | PMU AC plugged/unplugged通知 | E-14 | ○ |
| C-26 | PMU AC overvoltage通知 | E-14 | ○ |
| C-27 | PMU USB plugged/unplugged通知 | E-14 | ○ |
| C-28 | PMU USB overvoltage/undervoltage通知 | E-14 | ○ |
| C-29 | PMU Battery charged通知 | E-14 | ○ |
| C-30 | PMU Battery charging通知 | E-14 | ○ |
| C-31 | PMU Battery connected/disconnected通知 | E-14 | ○ |
| C-32 | PMU Battery low-temp/high-temp通知 | E-14 | ○ |
| C-33 | PMU Battery warning-threshold通知 | E-15 | ○ |
| C-34 | ACPI ACAD power通知 | E-16 | ○ |
| C-35 | PMU keys メディアキー通知 | E-18 | ○ |
| C-36 | kernel power resume通知 | E-19 | ○ |
| C-37 | kernel signal coredump通知 | E-20 | ○ |
| C-38 | CAM iosched latency通知 | E-21 | ○ |
| C-39 | CAM periph エラー通知 | E-22 | ○ |
| C-40 | NVMe controller イベント通知 | E-23 | ○ |
| C-41 | NVMe controller RECONNECT通知 | E-24 | ○ |
| C-42 | VFS FS マウントイベント通知 | E-25 | ○ |
| C-43 | RCTL rule matched通知 | E-26 | ○ |
| C-44 | VT BELL RING通知 | E-27 | ○ |
| C-45 | ZFS イベント通知 | E-28 | ○ |
| C-46 | HDA CONN イベント通知 | E-29 | ○ |
| C-47 | coretemp Thermal イベント通知 | E-30 | ○ |
| C-48 | HYPERV_NIC_VF status通知 | E-31 | ○ |
| C-49 | AEON power press通知 | E-32 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本一覧はカーネルの `devctl_notify()` API経由の通知に限定して収集している
  - 候補：syslog経由の通知 / kqueue/kevent経由のイベント通知 / SNMP trap / auditd監査通知
- contrib/ 配下のサードパーティコード（OpenZFS以外）に含まれる通知は網羅的に調査していない
  - 候補：contrib/blocklist/ の通知 / contrib/bsnmp/ のSNMP通知
- ユーザランドデーモン（cron, sendmail等）が発行する通知は対象外としている
  - 候補：usr.sbin/cron/ / usr.sbin/mailwrapper/ / usr.sbin/syslogd/

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - syslog通知が含まれていないため、ログベースの通知を期待するレビュアーには不完全に見える可能性がある
- 1: 中リスク - kqueue/kevent通知が含まれていないため、イベント駆動型の通知を期待するレビュアーには不完全に見える可能性がある
- 0: 低リスク - devctl_notify 経由の通知については、sys/ ディレクトリを網羅的に検索しており、高い信頼性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 通知一覧の各項目が、備考に記載されたソースファイルに実在するか確認
- [ ] プロジェクト固有の通知要件（syslog, SNMP等）が別途必要でないか確認
- [ ] devctl_notify 以外の通知メカニズム（kqueue, signal, syslog）を含める必要がないか判断
- [ ] ARM/PowerPC固有の通知（PMU関連）がプロジェクトの対象アーキテクチャに含まれるか確認
