# 通知設計書 13-IFATTACH

## 概要

本ドキュメントは、FreeBSDカーネルにおけるETHERNET IFATTACH通知の設計を記述する。イーサネットインターフェースがシステムにアタッチ（接続・初期化）された際にdevctl(4)サブシステムを通じてユーザーランドに通知を送信する仕組みについて定義する。

### 本通知の処理概要

ETHERNET IFATTACH通知は、イーサネットインターフェースの初期化処理（ether_ifattach()）が完了した時点で発行されるdevctl通知である。

**業務上の目的・背景**：新しいイーサネットインターフェースがシステムに接続された際に、ユーザーランドのネットワーク管理デーモン（devd(8)等）がインターフェースの存在を検知し、自動的なネットワーク設定（DHCPの開始、ブリッジへの追加等）を行うために本通知が必要である。物理NICの挿入、仮想インターフェースの作成、VLANの追加などが契機となる。

**通知の送信タイミング**：ether_ifattach()関数の最終段階で、インターフェースの初期化（if_attach、出力・入力関数の設定、MACアドレスの設定、BPFアタッチ等）がすべて完了した後に送信される。

**通知の受信者**：devctl(4)デバイスをオープンしているユーザーランドプロセス。主にdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「ETHERNET」、サブシステム名としてインターフェース名（if_xname）、タイプ「IFATTACH」、データなし（NULL）が通知される。

**期待されるアクション**：devd(8)がイーサネットインターフェースの接続を検知し、DHCPクライアントの起動、ネットワーク設定の適用、ブリッジやボンディングへの自動参加などを行う。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（devctl(4)キュー経由） |
| 優先度 | 通常 |
| リトライ | なし |

### 送信先決定ロジック

devctl(4)デバイスファイル(/dev/devctl)をオープンしているすべてのプロセスに対してブロードキャスト送信される。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | ETHERNET |
| サブシステム名 | {インターフェース名 (if_xname)} |
| タイプ | IFATTACH |
| データ | NULL（データなし） |

### 本文テンプレート

```
!system=ETHERNET subsystem={ifp->if_xname} type=IFATTACH
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ifp->if_xname | インターフェース名 | ifnet構造体 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| カーネル内部 | ether_ifattach()呼び出し | IS_DEFAULT_VNET(curvnet)がtrueの場合 | イーサネットインターフェース初期化完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非デフォルトVNET | IS_DEFAULT_VNET(curvnet)がfalseの場合、通知は発行されない（VIMAGE環境での重複防止） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ether_ifattach呼び出し] --> B[ifp初期化]
    B --> C[if_attach]
    C --> D[出力/入力関数設定]
    D --> E[MACアドレス設定]
    E --> F[bpfattach]
    F --> G[MACアドレス表示]
    G --> H[uuid_ether_add]
    H --> I[EVENTHANDLER_INVOKE ether_ifattach_event]
    I --> J{IS_DEFAULT_VNET?}
    J -->|Yes| K[devctl_notify ETHERNET/if_xname/IFATTACH/NULL]
    J -->|No| L[通知スキップ]
    K --> M[終了]
    L --> M
```

## データベース参照・更新仕様

該当なし（カーネル内メモリ構造体の操作のみ）

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| ifnet構造体 | インターフェース情報の参照 | if_xname、if_addrlen等 |
| sockaddr_dl | リンク層アドレス情報 | MACアドレスの格納 |

### テーブル別参照項目詳細

#### ifnet構造体

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| if_xname | インターフェース名（devctl通知のサブシステム名） | 対象インターフェースを指定 |
| if_addrlen | アドレス長 | ETHER_ADDR_LEN (6) に設定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ifnet構造体 | UPDATE | if_addrlen, if_hdrlen, if_mtu, if_output, if_input等を設定 |
| sockaddr_dl | UPDATE | sdl_type, sdl_alen, MACアドレスを設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| devctl送信失敗 | devctlキューが満杯 | 通知は破棄される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- devctl(4)デバイスへのアクセスにはroot権限が必要
- 通知データにはNULLが渡されるため、機密情報の漏洩リスクはない

## 備考

- ether_ifattach()関数はsys/net/if_ethersubr.cの974行目に定義されている
- devctl_notify()呼び出しは1017行目で行われる
- EVENTHANDLER_INVOKE(ether_ifattach_event)は1015行目で先に発行される
- IS_DEFAULT_VNET()チェックは1016行目で行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イーサネットインターフェースの基本構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | if_var.h | `sys/net/if_var.h` | ifnet構造体のif_xname、if_addrlenフィールド |
| 1-2 | ethernet.h | `sys/net/ethernet.h` | ETHER_ADDR_LEN、ETHER_HDR_LEN等の定数定義 |
| 1-3 | if_dl.h | `sys/net/if_dl.h` | sockaddr_dl構造体のsdl_type、sdl_alen |

**読解のコツ**: ether_ifattach()はイーサネットインターフェースの「初期化儀式」であり、if_attach()の後にイーサネット固有の設定を行う。

#### Step 2: エントリーポイントを理解する

ether_ifattach()がイーサネットインターフェース初期化の中心関数である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | if_ethersubr.c | `sys/net/if_ethersubr.c` | ether_ifattach()関数（974-1018行目） |

**主要処理フロー**:
1. **980行目**: if_addrlenにETHER_ADDR_LENを設定
2. **984行目**: if_attach()でカーネルにインターフェースを登録
3. **985-988行目**: ether_output/ether_input等の関数ポインタ設定
4. **996-998行目**: sockaddr_dlにMACアドレスを設定
5. **1003行目**: bpfattach()でBPFフィルタをアタッチ
6. **1012行目**: uuid_ether_add()でUUIDにMACアドレスを追加
7. **1015行目**: EVENTHANDLER_INVOKE(ether_ifattach_event)
8. **1016-1017行目**: IS_DEFAULT_VNETチェック後にdevctl_notify()

### プログラム呼び出し階層図

```
[各NICドライバ] (例: em_attach, igb_attach等)
    |
    +-- ether_ifattach() [sys/net/if_ethersubr.c:974]
           |
           +-- if_attach()
           +-- bpfattach()
           +-- uuid_ether_add()
           +-- EVENTHANDLER_INVOKE(ether_ifattach_event)
           +-- devctl_notify("ETHERNET", if_xname, "IFATTACH", NULL)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

ifnet構造体       --->  ether_ifattach()            --->  devctl(4)キュー
MACアドレス(lla)         |                              |
                         +-- ifnet初期化                +-- devd(8)
                         +-- sockaddr_dl設定
                         +-- EVENTHANDLER発行
                         +-- devctl_notify
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| if_ethersubr.c | `sys/net/if_ethersubr.c` | ソース | ether_ifattach()の実装、devctl_notify呼び出し |
| if_var.h | `sys/net/if_var.h` | ヘッダー | ifnet構造体の定義 |
| ethernet.h | `sys/net/ethernet.h` | ヘッダー | イーサネット定数の定義 |
| if_dl.h | `sys/net/if_dl.h` | ヘッダー | sockaddr_dl構造体の定義 |
| devctl.h | `sys/sys/devctl.h` | ヘッダー | devctl_notify()のプロトタイプ |
| vnet.h | `sys/net/vnet.h` | ヘッダー | IS_DEFAULT_VNET()マクロの定義 |
