# 通知設計書 14-IFATTACH

## 概要

本ドキュメントは、FreeBSDカーネルにおけるINFINIBAND IFATTACH通知の設計を記述する。InfiniBandインターフェースがシステムにアタッチ（接続・初期化）された際にdevctl(4)サブシステムを通じてユーザーランドに通知を送信する仕組みについて定義する。

### 本通知の処理概要

INFINIBAND IFATTACH通知は、InfiniBandインターフェースの初期化処理（infiniband_ifattach()）が完了した時点で発行されるdevctl通知である。

**業務上の目的・背景**：InfiniBand（IB）は高性能コンピューティング環境やデータセンターで使用される高速ネットワーク技術である。IBインターフェースがシステムに接続された際に、ユーザーランドのネットワーク管理デーモンが自動的にインターフェースの設定やIPoIB（IP over InfiniBand）の構成を行うために本通知が必要である。

**通知の送信タイミング**：infiniband_ifattach()関数の最終段階で、インターフェースの初期化（if_attach、出力・入力関数の設定、IBアドレスの設定、BPFアタッチ等）がすべて完了した後に送信される。

**通知の受信者**：devctl(4)デバイスをオープンしているユーザーランドプロセス。主にdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「INFINIBAND」、サブシステム名としてインターフェース名（if_xname）、タイプ「IFATTACH」、データなし（NULL）が通知される。

**期待されるアクション**：devd(8)がInfiniBandインターフェースの接続を検知し、IPoIBの設定、サブネットマネージャとの通信開始、ネットワーク設定の適用などを行う。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（devctl(4)キュー経由） |
| 優先度 | 通常 |
| リトライ | なし |

### 送信先決定ロジック

devctl(4)デバイスファイル(/dev/devctl)をオープンしているすべてのプロセスに対してブロードキャスト送信される。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | INFINIBAND |
| サブシステム名 | {インターフェース名 (if_xname)} |
| タイプ | IFATTACH |
| データ | NULL（データなし） |

### 本文テンプレート

```
!system=INFINIBAND subsystem={ifp->if_xname} type=IFATTACH
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ifp->if_xname | インターフェース名 | ifnet構造体 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| カーネル内部 | infiniband_ifattach()呼び出し | IS_DEFAULT_VNET(curvnet)がtrueの場合 | InfiniBandインターフェース初期化完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非デフォルトVNET | IS_DEFAULT_VNET(curvnet)がfalseの場合、通知は発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[infiniband_ifattach呼び出し] --> B[ifp初期化]
    B --> C[if_attach]
    C --> D[出力/入力関数設定]
    D --> E[IBアドレス設定]
    E --> F[bpfattach]
    F --> G[IBアドレス表示]
    G --> H[EVENTHANDLER_INVOKE infiniband_ifattach_event]
    H --> I{IS_DEFAULT_VNET?}
    I -->|Yes| J[devctl_notify INFINIBAND/if_xname/IFATTACH/NULL]
    I -->|No| K[通知スキップ]
    J --> L[終了]
    K --> L
```

## データベース参照・更新仕様

該当なし（カーネル内メモリ構造体の操作のみ）

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| ifnet構造体 | インターフェース情報の参照 | if_xname、if_addrlen等 |
| sockaddr_dl | リンク層アドレス情報 | IBアドレスの格納 |

### テーブル別参照項目詳細

#### ifnet構造体

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| if_xname | インターフェース名（devctl通知のサブシステム名） | 対象インターフェースを指定 |
| if_addrlen | アドレス長 | INFINIBAND_ADDR_LEN (20) に設定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ifnet構造体 | UPDATE | if_addrlen, if_hdrlen, if_mtu, if_output, if_input等を設定 |
| sockaddr_dl | UPDATE | sdl_type (IFT_INFINIBAND), sdl_alen, IBアドレスを設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| devctl送信失敗 | devctlキューが満杯 | 通知は破棄される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- devctl(4)デバイスへのアクセスにはroot権限が必要
- 通知データにはNULLが渡されるため、機密情報の漏洩リスクはない

## 備考

- infiniband_ifattach()関数はsys/net/if_infiniband.cに定義されている
- devctl_notify()呼び出しは700行目で行われる
- EVENTHANDLER_INVOKE(infiniband_ifattach_event)は697行目で先に発行される
- InfiniBandアドレスは20バイト長であり、イーサネット（6バイト）よりも長い
- bpfattach()ではDLT_EN10MB互換としてアタッチされる（687行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

InfiniBandインターフェースの基本構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | if_var.h | `sys/net/if_var.h` | ifnet構造体のif_xname、if_addrlenフィールド |
| 1-2 | infiniband.h | `sys/net/infiniband.h` | INFINIBAND_ADDR_LEN等の定数定義 |
| 1-3 | if_dl.h | `sys/net/if_dl.h` | sockaddr_dl構造体、IFT_INFINIBAND型 |

**読解のコツ**: InfiniBandのインターフェース初期化はイーサネット（ether_ifattach）と構造が類似しているが、アドレス長やリンク層タイプが異なる。

#### Step 2: エントリーポイントを理解する

infiniband_ifattach()がInfiniBandインターフェース初期化の中心関数である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | if_infiniband.c | `sys/net/if_infiniband.c` | infiniband_ifattach()関数（660-701行目付近） |

**主要処理フロー**:
1. **660行目**: if_attach()でカーネルにインターフェースを登録
2. **661-664行目**: infiniband_output/infiniband_input等の関数ポインタ設定
3. **666-667行目**: デフォルトボーレートの設定（10Gbps）
4. **674行目**: sockaddr_dlのsdl_typeをIFT_INFINIBANDに設定
5. **687行目**: bpfattach()でBPFフィルタをアタッチ
6. **697行目**: EVENTHANDLER_INVOKE(infiniband_ifattach_event)
7. **699-700行目**: IS_DEFAULT_VNETチェック後にdevctl_notify()

### プログラム呼び出し階層図

```
[InfiniBandドライバ] (例: mlx4_ib, mlx5_ib等)
    |
    +-- infiniband_ifattach() [sys/net/if_infiniband.c]
           |
           +-- if_attach()
           +-- bpfattach()
           +-- EVENTHANDLER_INVOKE(infiniband_ifattach_event)
           +-- devctl_notify("INFINIBAND", if_xname, "IFATTACH", NULL)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

ifnet構造体       --->  infiniband_ifattach()       --->  devctl(4)キュー
IBアドレス(lla)          |                              |
ブロードキャスト(llb)     +-- ifnet初期化                +-- devd(8)
                         +-- sockaddr_dl設定
                         +-- EVENTHANDLER発行
                         +-- devctl_notify
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| if_infiniband.c | `sys/net/if_infiniband.c` | ソース | infiniband_ifattach()の実装、devctl_notify呼び出し |
| infiniband.h | `sys/net/infiniband.h` | ヘッダー | InfiniBand定数の定義 |
| if_var.h | `sys/net/if_var.h` | ヘッダー | ifnet構造体の定義 |
| if_dl.h | `sys/net/if_dl.h` | ヘッダー | sockaddr_dl構造体の定義 |
| devctl.h | `sys/sys/devctl.h` | ヘッダー | devctl_notify()のプロトタイプ |
| vnet.h | `sys/net/vnet.h` | ヘッダー | IS_DEFAULT_VNET()マクロの定義 |
