# 通知設計書 22-PMU lid open

## 概要

本ドキュメントは、FreeBSDカーネルにおけるPMU（Power Management Unit）のノートPC蓋開き通知「PMU lid open」の設計仕様を記述する。Apple PowerMac/PowerBookプラットフォームにおいて、ノートPCの蓋（lid）が開かれた際にdevctl_notifyを通じてユーザーランドのdevd(8)デーモンへ通知を発行する仕組みである。

### 本通知の処理概要

本通知は、Apple PowerMacプラットフォームのPMUコントローラが、ノートPCの蓋が開かれたことを検出した際にカーネルからユーザーランドへ通知するためのdevctl通知イベントである。No.21（lid close）と対になる通知である。

**業務上の目的・背景**：ノートPCの蓋が開かれた際に、システムはスリープからの復帰やディスプレイの再点灯などの処理を実行する必要がある。devdデーモンがこの通知を受け取ることで、ユーザーが設定したスクリプト（例: /etc/devd.conf内のルール）を実行し、スクリーンのアンロックやバックライトの点灯などのアクションを自動的にトリガーできる。

**通知の送信タイミング**：PMUからの環境割り込み（PMU_INT_ENVIRONMENT）を受信し、割り込み応答のresp[2]にPMU_ENV_LID_CLOSED（0x01）ビットがセットされておらず、かつ前回の状態が蓋が閉じていた状態（sc->lid_closed == 1）であった場合に送信される。つまり、蓋が開かれた瞬間（状態遷移）にのみ送信される。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。devdはdevctl_notify経由で/dev/devctlデバイスからイベントを読み取り、/etc/devd.confに記述されたマッチングルールに基づいて対応するアクションスクリプトを実行する。

**通知内容の概要**：システム名「PMU」、サブシステム名「lid」、タイプ「open」の3つの文字列で構成される。追加データ（data引数）はNULLであり、付随情報は含まれない。

**期待されるアクション**：受信者（devd）は、この通知に基づいてスリープからの復帰処理、ディスプレイの再点灯、スクリーンのアンロック、外部モニタの再検出などを実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（割り込みハンドラからdevctl_notifyを呼び出し） |
| 優先度 | 高（ハードウェア割り込みレベルで処理） |
| リトライ | 無（カーネル通知は一度のみ発行） |

### 送信先決定ロジック

devctl_notifyはカーネル内の通知キューにイベントを追加する。devd(8)デーモンが/dev/devctlデバイスを通じてこのキューを監視・読み取りする。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | PMU |
| サブシステム名 | lid |
| タイプ | open |
| 追加データ | NULL（なし） |

### 本文テンプレート

```
!system=PMU subsystem=lid type=open
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "lid" | Yes |
| type | 通知タイプ | 固定値 "open" | Yes |
| data | 追加情報 | NULL | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | PMU環境割り込み（PMU_INT_ENVIRONMENT） | !(resp[2] & PMU_ENV_LID_CLOSED) かつ sc->lid_closed == 1 | PMUから蓋開き状態が検出され、前回が閉じていた場合のみ通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| sc->lid_closed == 0 | 既に蓋が開いた状態として記録されている場合、重複通知を抑止する |
| resp[2] & PMU_ENV_LID_CLOSED | LID_CLOSEDビットがセットされている場合はopen通知を発行しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PMU割り込み発生] --> B[pmu_intr関数呼び出し]
    B --> C[PMU_INT_ACK送信・応答取得]
    C --> D{resp[1] & PMU_INT_ENVIRONMENT?}
    D -->|No| E[終了]
    D -->|Yes| F{!(resp[2] & PMU_ENV_LID_CLOSED)?}
    F -->|No| E
    F -->|Yes| G{sc->lid_closed == 1?}
    G -->|No| E
    G -->|Yes| H[sc->lid_closed = 0]
    H --> I[devctl_notify PMU lid open NULL]
    I --> E
```

## データベース参照・更新仕様

該当なし（カーネルドライバのためデータベースは使用しない）。カーネル内のstruct pmu_softcのlid_closedフィールドを0に更新する。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 割り込み応答なし | PMU_INT_ACKの応答長が1未満またはresp[1]が0 | 何もせず関数からリターン |
| devctl_notify失敗 | devctlキューが満杯の場合 | カーネル内でイベントを破棄 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（状態遷移時のみ発火するため実質1回） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。ハードウェアイベント駆動のため常時有効。

## セキュリティ考慮事項

- /dev/devctlデバイスへのアクセスにはroot権限が必要
- 通知データにNULLが渡されるため、個人情報や機密情報の漏洩リスクはない

## 備考

- この通知はApple PowerMac99プラットフォーム専用
- No.21（lid close）と対になる通知であり、lid_closedフラグで排他的に制御される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pmuvar.h | `sys/powerpc/powermac/pmuvar.h` | struct pmu_softcのlid_closedフィールド（行163）、PMU_ENV_LID_CLOSED（行101）、PMU_INT_ENVIRONMENT（行84） |

**読解のコツ**: PMU_ENV_LID_CLOSED（0x01）のビットが「セットされていない」ことがlid openの条件であることに注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pmu.c | `sys/powerpc/powermac/pmu.c` | pmu_intr関数（行696-757）の行749-752がlid open通知のロジック |

**主要処理フロー**:
1. **行749**: else if条件でLID_CLOSEDビットが未セットかつsc->lid_closedが1であることを確認
2. **行751**: sc->lid_closedを0にリセット
3. **行752**: devctl_notify("PMU", "lid", "open", NULL)を呼び出し

#### Step 3: lid_closed状態管理の全体像を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pmu.c | `sys/powerpc/powermac/pmu.c` | 行743-756の環境割り込み処理ブロック全体。lid_closedの状態遷移（0→1でclose通知、1→0でopen通知）を確認 |

### プログラム呼び出し階層図

```
[ハードウェア割り込み]
    |
    +-- pmu_intr(arg)                           [sys/powerpc/powermac/pmu.c:696]
           |
           +-- pmu_send(sc, PMU_INT_ACK, ...)   [sys/powerpc/powermac/pmu.c:596]
           |
           +-- [resp[1] & PMU_INT_ENVIRONMENT チェック]
           |
           +-- [!(resp[2] & PMU_ENV_LID_CLOSED) && sc->lid_closed チェック]
           |
           +-- devctl_notify("PMU","lid","open",NULL)  [sys/kern/subr_bus.c]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

PMU割り込み信号 ---------> pmu_intr()                ------> devctl_notify()
                           |                                   |
                           +- PMU_INT_ACK応答取得              +- /dev/devctl
                           +- resp[2]のLID_CLOSEDビット確認        |
                           +- sc->lid_closed = 0               +- devd(8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pmu.c | `sys/powerpc/powermac/pmu.c` | ソース | PMUドライバ本体。行749-752でlid open通知を発行 |
| pmuvar.h | `sys/powerpc/powermac/pmuvar.h` | ヘッダ | PMU定数定義とpmu_softc構造体 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
