# 通知設計書 23-PMU Button pressed

## 概要

本ドキュメントは、FreeBSDカーネルにおける電源ボタン押下通知「PMU Button pressed」の設計仕様を記述する。Apple PowerMac/PowerBookプラットフォームにおいて、電源ボタンが押された際にdevctl_notifyを通じてユーザーランドのdevd(8)デーモンへ通知を発行する。この通知は2つの異なるソースから発行される：PMU環境割り込みハンドラ（pmu.c）とADBキーボードドライバ（adb_kbd.c）。

### 本通知の処理概要

本通知は、Apple PowerMacプラットフォームにおける電源ボタン押下イベントをユーザーランドへ伝達するためのdevctl通知イベントである。

**業務上の目的・背景**：電源ボタンの押下はシステムのシャットダウン、スリープ、またはシャットダウンダイアログの表示を開始するための重要なユーザー操作である。devdデーモンがこの通知を受け取ることで、ユーザーが設定したシャットダウンシーケンスやスリープ処理をトリガーできる。

**通知の送信タイミング**：2つの異なるパスから送信される。(1) PMU環境割り込み処理において、resp[2]にPMU_ENV_POWER（0x08）ビットがセットされている場合（pmu.c:754-755）。(2) ADBキーボードドライバにおいて、キーコード0x7f（電源キー）が受信された場合（adb_kbd.c:424-425）。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「PMU」、サブシステム名「Button」、タイプ「pressed」の3つの文字列で構成される。追加データはNULL。

**期待されるアクション**：受信者はシステムのシャットダウン処理の開始、スリープダイアログの表示、またはユーザー定義のカスタムアクションを実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（割り込みハンドラ/パケット受信ハンドラからdevctl_notifyを呼び出し） |
| 優先度 | 高（ハードウェア割り込みレベルで処理） |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notifyによりカーネル通知キューにイベントを追加し、devd(8)が/dev/devctlを介して受信する。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | PMU |
| サブシステム名 | Button |
| タイプ | pressed |
| 追加データ | NULL（なし） |

### 本文テンプレート

```
!system=PMU subsystem=Button type=pressed
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "Button" | Yes |
| type | 通知タイプ | 固定値 "pressed" | Yes |
| data | 追加情報 | NULL | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | PMU環境割り込み | resp[2] & PMU_ENV_POWER | PMU経由で電源ボタン押下を検出（pmu.c:754-755） |
| ADBパケット受信 | ADB TALKコマンド応答 | data[0] == 0x7f | ADBキーボード経由で電源キー押下を検出（adb_kbd.c:424-425） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| data[0] == 0xff | ADBキーボードでは電源ボタンのリリース（0xff）は無視される（adb_kbd.c:428-431） |
| PMU_INT_ENVIRONMENT未設定 | PMU割り込みで環境ビットがない場合はPOWERチェックしない |

## 処理フロー

### 送信フロー（PMU環境割り込みパス）

```mermaid
flowchart TD
    A[PMU割り込み発生] --> B[pmu_intr関数呼び出し]
    B --> C[PMU_INT_ACK送信・応答取得]
    C --> D{resp[1] & PMU_INT_ENVIRONMENT?}
    D -->|No| E[終了]
    D -->|Yes| F{resp[2] & PMU_ENV_POWER?}
    F -->|No| E
    F -->|Yes| G[devctl_notify PMU Button pressed NULL]
    G --> E
```

### 送信フロー（ADBキーボードパス）

```mermaid
flowchart TD
    A[ADBパケット受信] --> B[adb_kbd_receive_packet関数]
    B --> C{command == ADB_COMMAND_TALK?}
    C -->|No| D[終了]
    C -->|Yes| E{reg == 0 && len == 2?}
    E -->|No| D
    E -->|Yes| F{data[0] == 0x7f?}
    F -->|No| G[通常キー処理]
    F -->|Yes| H[devctl_notify PMU Button pressed NULL]
    H --> D
```

## データベース参照・更新仕様

該当なし（カーネルドライバのためデータベースは使用しない）。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 割り込み応答なし | PMU_INT_ACKの応答長が1未満またはresp[1]が0 | 何もせずリターン |
| ADBパケット不正 | commandがTALKでない、regが0でない、lenが2でない | 何もせずリターン |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。ハードウェアイベント駆動のため常時有効。

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 電源ボタンイベントは物理的なアクセスを必要とするため、リモート攻撃のリスクは低い
- 通知データはNULLのため情報漏洩リスクなし

## 備考

- PMU経由（pmu.c）とADBキーボード経由（adb_kbd.c）の2つの検出パスが存在する
- PMU経由はPMU_ENV_POWERビット（0x08）による検出で、lid close/open処理と同じ環境割り込みブロック内で処理される
- ADBキーボード経由はキーコード0x7fで検出され、リリースイベント（0xff）は明示的に無視される
- 両方のパスが同時に発火する可能性があり、この場合devdには2つの通知が到達する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pmuvar.h | `sys/powerpc/powermac/pmuvar.h` | PMU_ENV_POWER定数（行102、0x08）とPMU_INT_ENVIRONMENT（行84） |
| 1-2 | adb.h | `sys/dev/adb/adb.h` | ADB_COMMAND_TALK定数の定義 |

**読解のコツ**: PMU_ENV_POWERはPMU環境レジスタのビット3（0x08）であり、電源ボタンの物理的な押下状態を示す。ADBキーボードでは電源キーはスキャンコード0x7fとして送信される。

#### Step 2: エントリーポイント1 -- PMU割り込みハンドラ

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pmu.c | `sys/powerpc/powermac/pmu.c` | pmu_intr関数（行696-757）の行754-755 |

**主要処理フロー**:
1. **行743**: resp[1] & PMU_INT_ENVIRONMENTチェック
2. **行754**: resp[2] & PMU_ENV_POWERチェック
3. **行755**: devctl_notify("PMU", "Button", "pressed", NULL)

#### Step 3: エントリーポイント2 -- ADBキーボードドライバ

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | adb_kbd.c | `sys/dev/adb/adb_kbd.c` | adb_kbd_receive_packet関数（行408-471）の行424-425 |

**主要処理フロー**:
1. **行416**: command != ADB_COMMAND_TALKならリターン
2. **行419**: reg != 0 || len != 2ならリターン
3. **行424**: data[0] == 0x7fなら電源キー押下
4. **行425**: devctl_notify("PMU", "Button", "pressed", NULL)
5. **行428-431**: data[0] == 0xffなら電源ボタンリリースを無視

### プログラム呼び出し階層図

```
パス1: PMU環境割り込み
[ハードウェア割り込み]
    |
    +-- pmu_intr(arg)                               [pmu.c:696]
           |
           +-- pmu_send(sc, PMU_INT_ACK, ...)       [pmu.c:596]
           |
           +-- [PMU_INT_ENVIRONMENT & PMU_ENV_POWER チェック]
           |
           +-- devctl_notify("PMU","Button","pressed",NULL)

パス2: ADBキーボード
[ADBパケット受信]
    |
    +-- adb_kbd_receive_packet(dev, status, ...)     [adb_kbd.c:408]
           |
           +-- [data[0] == 0x7f チェック]
           |
           +-- devctl_notify("PMU","Button","pressed",NULL)
```

### データフロー図

```
[入力]                           [処理]                    [出力]

PMU環境割り込み -----+
                     +-------> devctl_notify() ------> /dev/devctl --> devd(8)
ADBキーコード0x7f ---+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pmu.c | `sys/powerpc/powermac/pmu.c` | ソース | PMU割り込みハンドラでのButton pressed通知発行（行754-755） |
| adb_kbd.c | `sys/dev/adb/adb_kbd.c` | ソース | ADBキーボードドライバでのButton pressed通知発行（行424-425） |
| pmuvar.h | `sys/powerpc/powermac/pmuvar.h` | ヘッダ | PMU_ENV_POWER定数定義（行102） |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
