# 通知設計書 24-PMU POWER ACLINE

## 概要

本ドキュメントは、FreeBSDカーネルにおけるPMU（Power Management Unit）のAC電源接続状態変更通知「PMU POWER ACLINE」の設計仕様を記述する。Apple PowerMac/PowerBookプラットフォームにおいて、AC電源の接続状態が変化した際にdevctl_notifyを通じてユーザーランドのdevd(8)デーモンへ通知を発行する。

### 本通知の処理概要

本通知は、PowerMacプラットフォームのPMUドライバにおけるバッテリー監視プロセスが、AC電源の接続状態変化（接続/切断）を検出した際にカーネルからユーザーランドへ通知するためのdevctl通知イベントである。

**業務上の目的・背景**：ノートPCのAC電源の接続・切断は、電源管理ポリシーの切り替え（バッテリー節約モード/パフォーマンスモード）、ディスプレイの輝度調整、CPUクロック制御などに影響する重要なイベントである。devdデーモンがこの通知を受け取ることで、適切な電源管理ポリシーへの切り替えを自動的に実行できる。

**通知の送信タイミング**：バッテリー監視カーネルスレッド（pmu_battquery_proc）が1秒間隔でバッテリー状態をポーリングし、AC電源の接続状態（PMU_PWR_AC_PRESENT）が前回のポーリング結果と異なる場合に送信される。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「PMU」、サブシステム名「POWER」、タイプ「ACLINE」、追加データとして「notify=0xNN」形式のAC接続状態値（0x00=未接続、0x01=接続）を含む。

**期待されるアクション**：受信者は、AC電源の接続状態に応じて電源管理プロファイルの切り替え、画面輝度の調整、省電力モードの有効化/無効化などを実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（カーネルスレッドからdevctl_notifyを呼び出し） |
| 優先度 | 中（1秒間隔のポーリングで検出） |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notifyによりカーネル通知キューにイベントを追加し、devd(8)が/dev/devctlを介して受信する。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | PMU |
| サブシステム名 | POWER |
| タイプ | ACLINE |
| 追加データ | notify=0xNN（0x00または0x01） |

### 本文テンプレート

```
!system=PMU subsystem=POWER type=ACLINE notify=0x01
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "POWER" | Yes |
| type | 通知タイプ | 固定値 "ACLINE" | Yes |
| notify | AC接続状態 | batt.state & PMU_PWR_AC_PRESENT の結果（0x00 or 0x01） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| カーネルスレッドポーリング | pmu_battquery_proc（1秒周期） | new_acline != old_acline | AC電源の接続状態が前回と異なる場合に通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| new_acline == old_acline | AC電源状態に変化がない場合は通知を抑止 |
| pmu_query_battery失敗 | バッテリー状態の取得に失敗した場合は通知をスキップ |
| pmu_battmon_enabled == 0 | バッテリーモニタリングがsysctlで無効化されている場合、監視スレッドが停止 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[pmu_battquery_proc開始] --> B[1秒スリープ]
    B --> C[pmu_query_battery呼び出し]
    C --> D{バッテリー状態取得成功?}
    D -->|No| B
    D -->|Yes| E[pmu_battery_notify呼び出し]
    E --> F{new_acline != old_acline?}
    F -->|No| G[cur_batt更新]
    F -->|Yes| H[snprintfでnotify_buf生成]
    H --> I[devctl_notify PMU POWER ACLINE notify_buf]
    I --> G
    G --> B
```

## データベース参照・更新仕様

該当なし（カーネルドライバのためデータベースは使用しない）。カーネル内のcur_battローカル変数でバッテリー状態を保持し、比較に使用する。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バッテリー状態取得失敗 | pmu_query_batteryが-1を返す場合 | 通知をスキップし、次回ポーリングで再試行 |
| PMU通信エラー | pmu_sendの応答長が3未満 | pmu_query_batteryが-1を返す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 実質無限（1秒間隔でポーリング継続） |
| リトライ間隔 | 1秒（pause("pmu_batt", hz)） |
| リトライ対象エラー | バッテリー状態取得失敗 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（状態変化時のみ発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。カーネルスレッドは常時稼働。

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 追加データにはAC接続状態のみが含まれ、個人情報の漏洩リスクはない

## 備考

- この通知はApple PowerMac99プラットフォーム専用であり、No.25（AC plugged/unplugged）のAllwinnerプラットフォーム版とは異なるメカニズム
- バッテリーモニタリングはsysctlの`dev.pmu.0.monitor_batteries`で有効/無効を切り替え可能
- ポーリング方式のため、AC接続状態変化の検出には最大1秒の遅延が生じる
- バッテリーが0個のシステムではバッテリー監視スレッドが起動されないため、この通知は発行されない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pmuvar.h | `sys/powerpc/powermac/pmuvar.h` | struct pmu_battstate（行167-174）でバッテリー状態を保持。PMU_PWR_AC_PRESENT（行116、ビット0）がAC接続フラグ |

**読解のコツ**: pmu_battstateのstateフィールドにPMU応答のバイト2（バッテリーフラグ）が格納される。PMU_PWR_AC_PRESENTはビット0で、AC電源が接続されているとセットされる。

#### Step 2: バッテリー監視スレッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pmu.c | `sys/powerpc/powermac/pmu.c` | pmu_battquery_proc関数（行966-985）がバッテリー監視カーネルスレッド |

**主要処理フロー**:
1. **行973**: device_get_softcでPMUソフトコンテキスト取得
2. **行975**: cur_battをゼロ初期化
3. **行976-984**: 無限ループで1秒間隔ポーリング
4. **行978**: pmu_query_batteryでバッテリー状態取得
5. **行980**: pmu_battery_notifyで状態変化を通知
6. **行983**: pause("pmu_batt", hz)で1秒スリープ

#### Step 3: 通知発行ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pmu.c | `sys/powerpc/powermac/pmu.c` | pmu_battery_notify関数（行950-963）がACLINE通知の発行ロジック |

**主要処理フロー**:
- **行955**: new_acline = (batt->state & PMU_PWR_AC_PRESENT) ? 1 : 0
- **行956**: old_acline = (old->state & PMU_PWR_AC_PRESENT) ? 1 : 0
- **行958**: new_acline != old_aclineの場合のみ通知
- **行959-960**: snprintfでnotify_bufに"notify=0x%02x"形式でAC状態を格納
- **行961**: devctl_notify("PMU", "POWER", "ACLINE", notify_buf)

#### Step 4: バッテリー状態取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pmu.c | `sys/powerpc/powermac/pmu.c` | pmu_query_battery関数（行886-947）でPMU_SMART_BATTERY_STATEコマンドを送信し応答を解析 |

### プログラム呼び出し階層図

```
pmu_battquery_proc()                         [pmu.c:966]
    |
    +-- [無限ループ: 1秒間隔]
           |
           +-- pmu_query_battery(sc, 0, &batt)   [pmu.c:886]
           |       |
           |       +-- pmu_send(sc, PMU_SMART_BATTERY_STATE, ...)
           |
           +-- pmu_battery_notify(&batt, &cur_batt) [pmu.c:950]
                   |
                   +-- [new_acline != old_acline チェック]
                   |
                   +-- snprintf(notify_buf, ...)
                   |
                   +-- devctl_notify("PMU","POWER","ACLINE", notify_buf)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

PMUバッテリー状態 -------> pmu_query_battery()
    |                       |
    |                       +-> pmu_battstate.state
    |                                |
    |                       pmu_battery_notify()
    |                                |
    |                       +-> new_acline計算
    |                       +-> old_acline比較
    |                                |
    +--                     devctl_notify() --------> /dev/devctl
                                                          |
                                                     devd(8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pmu.c | `sys/powerpc/powermac/pmu.c` | ソース | PMUドライバ本体。バッテリー監視スレッドとACLINE通知ロジック |
| pmuvar.h | `sys/powerpc/powermac/pmuvar.h` | ヘッダ | PMU_PWR_AC_PRESENT定数、pmu_battstate構造体定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
