# 通知設計書 25-PMU AC plugged/unplugged

## 概要

本ドキュメントは、FreeBSDカーネルにおけるX-Power AXP209/AXP221 PMUのAC電源挿入・抜去通知「PMU AC plugged/unplugged」の設計仕様を記述する。Allwinner SoCプラットフォームにおいて、AC電源の物理的な接続・切断を検出した際にdevctl_notifyを通じてユーザーランドへ通知する。

### 本通知の処理概要

本通知は、Allwinner SoC向けX-Power AXP209/AXP221 PMICの割り込みハンドラが、AC電源の接続（plugged）または切断（unplugged）を検出した際に発行するdevctl通知イベントである。

**業務上の目的・背景**：組み込みLinuxボード（例: Allwinner A20搭載のCubieboard2等）において、AC電源の接続・切断はバッテリー運用モードの切り替えや充電制御に直結する重要なイベントである。devdデーモンがこの通知を受け取ることで、充電制御スクリプトや電源管理ポリシーの切り替えを自動実行できる。

**通知の送信タイミング**：AXP2XX PMICの割り込みステータスレジスタ（IRQ1_STATUS: 0x48）をポーリングし、AXP2XX_IRQ1_AC_CONN（ビット6）またはAXP2XX_IRQ1_AC_DISCONN（ビット5）がセットされた際に送信される。ハードウェア割り込み駆動で即座に検出される。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「PMU」、サブシステム名「AC」、タイプは接続時「plugged」、切断時「unplugged」。追加データはNULL。

**期待されるアクション**：受信者は、AC接続時には充電開始・パフォーマンスモード切替を、AC切断時にはバッテリー節約モードへの切替を実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（割り込みハンドラからdevctl_notifyを呼び出し） |
| 優先度 | 高（ハードウェア割り込みレベル） |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notifyによりカーネル通知キューにイベントを追加し、devd(8)が受信する。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容（接続時） | 内容（切断時） |
|-----|------|------|
| システム名 | PMU | PMU |
| サブシステム名 | AC | AC |
| タイプ | plugged | unplugged |
| 追加データ | NULL | NULL |

### 本文テンプレート

```
!system=PMU subsystem=AC type=plugged
```
または
```
!system=PMU subsystem=AC type=unplugged
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "AC" | Yes |
| type | 通知タイプ | "plugged" or "unplugged" | Yes |
| data | 追加情報 | NULL | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | AXP2XX IRQ1割り込み | reg & AXP2XX_IRQ1_AC_CONN | AC電源が接続された |
| ハードウェア割り込み | AXP2XX IRQ1割り込み | reg & AXP2XX_IRQ1_AC_DISCONN | AC電源が切断された |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| IRQ1ステータスレジスタが0 | IRQ1に該当する割り込みがない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AXP2XX割り込み発生] --> B[axp2xx_intr関数呼び出し]
    B --> C[AXP2XX_IRQ1_STATUSレジスタ読み取り]
    C --> D{reg != 0?}
    D -->|No| E[IRQ2処理へ]
    D -->|Yes| F{reg & AXP2XX_IRQ1_AC_CONN?}
    F -->|Yes| G[devctl_notify PMU AC plugged NULL]
    F -->|No| H{reg & AXP2XX_IRQ1_AC_DISCONN?}
    H -->|Yes| I[devctl_notify PMU AC unplugged NULL]
    H -->|No| E
    G --> E
    I --> E
    E --> J[IRQ1_STATUSをACKでクリア]
```

## データベース参照・更新仕様

該当なし（カーネルドライバのためデータベースは使用しない）。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| I2C通信エラー | axp2xx_readが失敗した場合 | IRQステータスが読み取れず通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ハードウェアイベント駆動） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 通知データはNULLのため情報漏洩リスクなし

## 備考

- AXP209（x-powers,axp209）とAXP221（x-powers,axp221）の両チップで共通のIRQ1レジスタ定義を使用
- AXP2XX_IRQ1_AC_CONNはビット6（0x40）、AXP2XX_IRQ1_AC_DISCONNはビット5（0x20）
- IRQ1の割り込み有効化はaxp2xx_start関数（axp209.c:1228-1234）で設定
- No.24（PMU POWER ACLINE）はPowerMacプラットフォーム向けの類似通知だが、検出メカニズムが異なる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | axp209reg.h | `sys/arm/allwinner/axp209reg.h` | AXP2XX_IRQ1_AC_CONN（行88、ビット6）、AXP2XX_IRQ1_AC_DISCONN（行89、ビット5）、AXP2XX_IRQ1_STATUS（行86、レジスタ0x48） |

**読解のコツ**: IRQ1ステータスレジスタ（0x48）は読み取り後にAXP2XX_IRQ_ACK（0xff）を書き込むことでクリアされる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_intr関数（行827-886）の行834-851がIRQ1処理ブロック |

**主要処理フロー**:
1. **行834**: AXP2XX_IRQ1_STATUSレジスタを読み取り
2. **行842**: AXP2XX_IRQ1_AC_CONNチェック -> "plugged"通知
3. **行844**: AXP2XX_IRQ1_AC_DISCONNチェック -> "unplugged"通知
4. **行850**: IRQ1_STATUSをAXP2XX_IRQ_ACKでクリア

#### Step 3: 割り込み有効化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_start関数（行1198-1279）の行1228-1234でIRQ1_ENABLEにAC_CONN/AC_DISCONNビットを設定 |

### プログラム呼び出し階層図

```
[ハードウェア割り込み（I2Cバス経由）]
    |
    +-- axp2xx_intr(arg)                          [axp209.c:827]
           |
           +-- axp2xx_read(dev, IRQ1_STATUS, &reg) [axp209.c:834]
           |
           +-- [AXP2XX_IRQ1_AC_CONN チェック]
           |       +-- devctl_notify("PMU","AC","plugged",NULL)   [axp209.c:843]
           |
           +-- [AXP2XX_IRQ1_AC_DISCONN チェック]
           |       +-- devctl_notify("PMU","AC","unplugged",NULL) [axp209.c:845]
           |
           +-- axp2xx_write(dev, IRQ1_STATUS, ACK)  [axp209.c:850]
```

### データフロー図

```
[入力]                         [処理]                        [出力]

AXP2XX IRQ1 割り込み -------> axp2xx_intr()
                               |
                               +- IRQ1_STATUS読み取り
                               +- AC_CONN/AC_DISCONN判定
                               |
                               +-> devctl_notify() -------> /dev/devctl
                                                                |
                                                           devd(8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| axp209.c | `sys/arm/allwinner/axp209.c` | ソース | AXP2XX PMICドライバ本体。割り込みハンドラでAC plugged/unplugged通知を発行 |
| axp209reg.h | `sys/arm/allwinner/axp209reg.h` | ヘッダ | IRQレジスタアドレス、ビットマスク定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
