# 通知設計書 26-PMU AC overvoltage

## 概要

本ドキュメントは、FreeBSDカーネルにおけるX-Power AXP209/AXP221 PMUのAC電源過電圧通知「PMU AC overvoltage」の設計仕様を記述する。Allwinner SoCプラットフォームにおいて、AC電源入力の過電圧状態を検出した際にdevctl_notifyを通じてユーザーランドへ通知する。

### 本通知の処理概要

本通知は、AXP2XX PMICの割り込みハンドラが、AC電源入力（ACIN端子）の過電圧状態を検出した際に発行するdevctl通知イベントである。

**業務上の目的・背景**：AC電源の過電圧はハードウェアの損傷やシステムの不安定化を引き起こす可能性がある。この通知により、システム管理者やユーザースペースの電源管理デーモンが過電圧状態を即座に検知し、シャットダウンや警告表示などの保護アクションを実行できる。

**通知の送信タイミング**：AXP2XX PMICの割り込みステータスレジスタ（IRQ1_STATUS: 0x48）をポーリングし、AXP2XX_IRQ1_AC_OVERVOLT（ビット7）がセットされた際に送信される。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「PMU」、サブシステム名「AC」、タイプ「overvoltage」。追加データはNULL。

**期待されるアクション**：受信者は、ハードウェア保護のための緊急シャットダウン、過電圧警告のログ記録、管理者へのアラート通知などを実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（割り込みハンドラからdevctl_notifyを呼び出し） |
| 優先度 | 高（ハードウェア割り込みレベル、安全性に関わるイベント） |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notifyによりカーネル通知キューにイベントを追加し、devd(8)が受信する。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | PMU |
| サブシステム名 | AC |
| タイプ | overvoltage |
| 追加データ | NULL（なし） |

### 本文テンプレート

```
!system=PMU subsystem=AC type=overvoltage
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "AC" | Yes |
| type | 通知タイプ | 固定値 "overvoltage" | Yes |
| data | 追加情報 | NULL | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | AXP2XX IRQ1割り込み | reg & AXP2XX_IRQ1_AC_OVERVOLT | AC電源入力の過電圧を検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| IRQ1ステータスレジスタが0 | IRQ1に該当する割り込みがない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AXP2XX割り込み発生] --> B[axp2xx_intr関数呼び出し]
    B --> C[AXP2XX_IRQ1_STATUSレジスタ読み取り]
    C --> D{reg != 0?}
    D -->|No| E[次のIRQ処理へ]
    D -->|Yes| F{reg & AXP2XX_IRQ1_AC_OVERVOLT?}
    F -->|Yes| G[devctl_notify PMU AC overvoltage NULL]
    F -->|No| H[他のIRQ1ビットチェック]
    G --> H
    H --> I[IRQ1_STATUSをACKでクリア]
    I --> E
```

## データベース参照・更新仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| I2C通信エラー | axp2xx_readが失敗した場合 | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 過電圧通知は安全性に関わる重要なイベントであり、devd.confで適切なアクションを設定すべき
- 通知データはNULLのため情報漏洩リスクなし

## 備考

- AXP2XX_IRQ1_AC_OVERVOLTはビット7（0x80）
- IRQ1_ENABLEレジスタ（0x40）でAXP2XX_IRQ1_AC_OVERVOLTが有効化される（axp209.c:1229）
- 過電圧の閾値はAXP209/AXP221チップ内部で設定されており、ソフトウェアからの変更はこのドライバでは行っていない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | axp209reg.h | `sys/arm/allwinner/axp209reg.h` | AXP2XX_IRQ1_AC_OVERVOLT（行87、ビット7 = 0x80） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_intr関数（行827-886）の行836-837 |

**主要処理フロー**:
1. **行834**: AXP2XX_IRQ1_STATUSレジスタ読み取り
2. **行836**: AXP2XX_IRQ1_AC_OVERVOLTチェック
3. **行837**: devctl_notify("PMU", "AC", "overvoltage", NULL)
4. **行850**: IRQ1_STATUSをACKでクリア

#### Step 3: 割り込み有効化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_start関数（行1228-1229）でIRQ1_ENABLEにAC_OVERVOLTを含むビットマスクを設定 |

### プログラム呼び出し階層図

```
[ハードウェア割り込み（I2Cバス経由）]
    |
    +-- axp2xx_intr(arg)                            [axp209.c:827]
           |
           +-- axp2xx_read(dev, IRQ1_STATUS, &reg)   [axp209.c:834]
           |
           +-- [AXP2XX_IRQ1_AC_OVERVOLT チェック]
           |       +-- devctl_notify("PMU","AC","overvoltage",NULL) [axp209.c:837]
           |
           +-- axp2xx_write(dev, IRQ1_STATUS, ACK)    [axp209.c:850]
```

### データフロー図

```
[入力]                         [処理]                        [出力]

AXP2XX IRQ1 割り込み -------> axp2xx_intr()
(AC_OVERVOLT bit)              |
                               +-> devctl_notify() -------> /dev/devctl
                                                                |
                                                           devd(8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| axp209.c | `sys/arm/allwinner/axp209.c` | ソース | AXP2XX PMICドライバ。割り込みハンドラでAC overvoltage通知を発行 |
| axp209reg.h | `sys/arm/allwinner/axp209reg.h` | ヘッダ | AXP2XX_IRQ1_AC_OVERVOLT定数定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
