# 通知設計書 27-PMU USB plugged/unplugged

## 概要

本ドキュメントは、FreeBSDカーネルにおけるX-Power AXP209/AXP221 PMUのUSB電源挿入・抜去通知「PMU USB plugged/unplugged」の設計仕様を記述する。Allwinner SoCプラットフォームにおいて、VBUS（USB電源）の接続・切断を検出した際にdevctl_notifyを通じてユーザーランドへ通知する。

### 本通知の処理概要

本通知は、AXP2XX PMICの割り込みハンドラが、VBUS端子へのUSB電源の接続（plugged）または切断（unplugged）を検出した際に発行するdevctl通知イベントである。

**業務上の目的・背景**：USB電源（VBUS）の接続・切断はバッテリー充電経路の切り替えやUSBデバイスの給電状態に影響する。組み込みボードではUSB電源がバッテリー充電の主要ソースとなることがあるため、その状態変化を検知して適切な電源管理を行うことが重要である。

**通知の送信タイミング**：AXP2XX PMICの割り込みステータスレジスタ（IRQ1_STATUS: 0x48）から、AXP2XX_IRQ1_VBUS_CONN（ビット3）またはAXP2XX_IRQ1_VBUS_DISCONN（ビット2）がセットされた際に送信される。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「PMU」、サブシステム名「USB」、タイプは接続時「plugged」、切断時「unplugged」。追加データはNULL。

**期待されるアクション**：受信者は、USB電源の接続・切断に応じてバッテリー充電制御の切り替えやUSBデバイス管理の調整を実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（割り込みハンドラからdevctl_notifyを呼び出し） |
| 優先度 | 高（ハードウェア割り込みレベル） |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notifyによりカーネル通知キューにイベントを追加し、devd(8)が受信する。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容（接続時） | 内容（切断時） |
|-----|------|------|
| システム名 | PMU | PMU |
| サブシステム名 | USB | USB |
| タイプ | plugged | unplugged |
| 追加データ | NULL | NULL |

### 本文テンプレート

```
!system=PMU subsystem=USB type=plugged
```
または
```
!system=PMU subsystem=USB type=unplugged
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "USB" | Yes |
| type | 通知タイプ | "plugged" or "unplugged" | Yes |
| data | 追加情報 | NULL | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | AXP2XX IRQ1割り込み | reg & AXP2XX_IRQ1_VBUS_CONN | USB電源（VBUS）が接続された |
| ハードウェア割り込み | AXP2XX IRQ1割り込み | reg & AXP2XX_IRQ1_VBUS_DISCONN | USB電源（VBUS）が切断された |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| IRQ1ステータスレジスタが0 | IRQ1に該当する割り込みがない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AXP2XX割り込み発生] --> B[axp2xx_intr関数呼び出し]
    B --> C[AXP2XX_IRQ1_STATUSレジスタ読み取り]
    C --> D{reg != 0?}
    D -->|No| E[次のIRQ処理へ]
    D -->|Yes| F{reg & AXP2XX_IRQ1_VBUS_CONN?}
    F -->|Yes| G[devctl_notify PMU USB plugged NULL]
    F -->|No| H{reg & AXP2XX_IRQ1_VBUS_DISCONN?}
    H -->|Yes| I[devctl_notify PMU USB unplugged NULL]
    H -->|No| E
    G --> J[IRQ1_STATUSをACKでクリア]
    I --> J
    J --> E
```

## データベース参照・更新仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| I2C通信エラー | axp2xx_readが失敗した場合 | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 通知データはNULLのため情報漏洩リスクなし

## 備考

- AXP2XX_IRQ1_VBUS_CONNはビット3（0x08）、AXP2XX_IRQ1_VBUS_DISCONNはビット2（0x04）
- IRQ1_ENABLEレジスタでVBUS_CONN/VBUS_DISCONNが有効化される（axp209.c:1228-1234）
- No.16/17のUSB DEVICEイベント/INTERFACEイベント通知はUSBデバイスレベルの通知であり、本通知はPMIC電源レベルの通知である点で異なる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | axp209reg.h | `sys/arm/allwinner/axp209reg.h` | AXP2XX_IRQ1_VBUS_CONN（行91、ビット3）、AXP2XX_IRQ1_VBUS_DISCONN（行92、ビット2） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_intr関数（行827-886）の行846-849 |

**主要処理フロー**:
1. **行834**: AXP2XX_IRQ1_STATUSレジスタ読み取り
2. **行846**: AXP2XX_IRQ1_VBUS_CONNチェック -> "plugged"通知
3. **行848**: AXP2XX_IRQ1_VBUS_DISCONNチェック -> "unplugged"通知
4. **行850**: IRQ1_STATUSをACKでクリア

#### Step 3: 割り込み有効化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_start関数の行1228-1234でVBUS_CONN/VBUS_DISCONNを有効化 |

### プログラム呼び出し階層図

```
[ハードウェア割り込み（I2Cバス経由）]
    |
    +-- axp2xx_intr(arg)                            [axp209.c:827]
           |
           +-- axp2xx_read(dev, IRQ1_STATUS, &reg)   [axp209.c:834]
           |
           +-- [AXP2XX_IRQ1_VBUS_CONN チェック]
           |       +-- devctl_notify("PMU","USB","plugged",NULL)   [axp209.c:847]
           |
           +-- [AXP2XX_IRQ1_VBUS_DISCONN チェック]
           |       +-- devctl_notify("PMU","USB","unplugged",NULL) [axp209.c:849]
           |
           +-- axp2xx_write(dev, IRQ1_STATUS, ACK)    [axp209.c:850]
```

### データフロー図

```
[入力]                         [処理]                        [出力]

AXP2XX IRQ1 割り込み -------> axp2xx_intr()
(VBUS_CONN/DISCONN bit)        |
                               +-> devctl_notify() -------> /dev/devctl
                                                                |
                                                           devd(8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| axp209.c | `sys/arm/allwinner/axp209.c` | ソース | AXP2XX PMICドライバ。割り込みハンドラでUSB plugged/unplugged通知を発行 |
| axp209reg.h | `sys/arm/allwinner/axp209reg.h` | ヘッダ | VBUS_CONN/VBUS_DISCONN定数定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
