# 通知設計書 28-PMU USB overvoltage/undervoltage

## 概要

本ドキュメントは、FreeBSDカーネルにおけるX-Power AXP209/AXP221 PMUのUSB電源過電圧・低電圧通知「PMU USB overvoltage/undervoltage」の設計仕様を記述する。Allwinner SoCプラットフォームにおいて、VBUS（USB電源）の過電圧または低電圧状態を検出した際にdevctl_notifyを通じてユーザーランドへ通知する。

### 本通知の処理概要

本通知は、AXP2XX PMICの割り込みハンドラが、VBUS端子の過電圧（overvoltage）または低電圧（undervoltage）状態を検出した際に発行するdevctl通知イベントである。

**業務上の目的・背景**：USB電源（VBUS）の電圧異常はバッテリー充電の異常やハードウェアの損傷リスクを示す重要なイベントである。過電圧はハードウェア損傷の危険性を、低電圧は不安定な給電やバッテリー充電不能の状態を示す。devdデーモンがこの通知を受け取ることで、保護措置やアラート通知を自動実行できる。

**通知の送信タイミング**：AXP2XX PMICの割り込みステータスレジスタ（IRQ1_STATUS: 0x48）から、AXP2XX_IRQ1_VBUS_OVERVOLT（ビット4）またはAXP2XX_IRQ1_VBUS_LOW（ビット1）がセットされた際に送信される。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「PMU」、サブシステム名「USB」、タイプは過電圧時「overvoltage」、低電圧時「undervoltage」。追加データはNULL。

**期待されるアクション**：受信者は、過電圧時にはハードウェア保護のための対処（充電停止、シャットダウン等）を、低電圧時にはUSB電源品質の警告ログ記録や代替電源への切り替えを実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（割り込みハンドラからdevctl_notifyを呼び出し） |
| 優先度 | 高（安全性に関わるイベント） |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notifyによりカーネル通知キューにイベントを追加し、devd(8)が受信する。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容（過電圧時） | 内容（低電圧時） |
|-----|------|------|
| システム名 | PMU | PMU |
| サブシステム名 | USB | USB |
| タイプ | overvoltage | undervoltage |
| 追加データ | NULL | NULL |

### 本文テンプレート

```
!system=PMU subsystem=USB type=overvoltage
```
または
```
!system=PMU subsystem=USB type=undervoltage
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "USB" | Yes |
| type | 通知タイプ | "overvoltage" or "undervoltage" | Yes |
| data | 追加情報 | NULL | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | AXP2XX IRQ1割り込み | reg & AXP2XX_IRQ1_VBUS_OVERVOLT | VBUS過電圧を検出 |
| ハードウェア割り込み | AXP2XX IRQ1割り込み | reg & AXP2XX_IRQ1_VBUS_LOW | VBUS低電圧を検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| IRQ1ステータスレジスタが0 | IRQ1に該当する割り込みがない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AXP2XX割り込み発生] --> B[axp2xx_intr関数呼び出し]
    B --> C[AXP2XX_IRQ1_STATUSレジスタ読み取り]
    C --> D{reg != 0?}
    D -->|No| E[次のIRQ処理へ]
    D -->|Yes| F{reg & AXP2XX_IRQ1_VBUS_OVERVOLT?}
    F -->|Yes| G[devctl_notify PMU USB overvoltage NULL]
    F -->|No| H{reg & AXP2XX_IRQ1_VBUS_LOW?}
    H -->|Yes| I[devctl_notify PMU USB undervoltage NULL]
    H -->|No| E
    G --> J[IRQ1_STATUSをACKでクリア]
    I --> J
    J --> E
```

## データベース参照・更新仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| I2C通信エラー | axp2xx_readが失敗した場合 | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 電圧異常通知は安全性に関わる重要なイベント
- 通知データはNULLのため情報漏洩リスクなし

## 備考

- AXP2XX_IRQ1_VBUS_OVERVOLTはビット4（0x10）、AXP2XX_IRQ1_VBUS_LOWはビット1（0x02）
- IRQ1_ENABLEレジスタでVBUS_OVERVOLTが有効化される（axp209.c:1228-1234）
- 過電圧・低電圧の閾値はAXP209/AXP221チップ内部で設定されており、このドライバからの変更は行っていない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | axp209reg.h | `sys/arm/allwinner/axp209reg.h` | AXP2XX_IRQ1_VBUS_OVERVOLT（行90、ビット4）、AXP2XX_IRQ1_VBUS_LOW（行93、ビット1） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_intr関数（行827-886）の行838-841 |

**主要処理フロー**:
1. **行834**: AXP2XX_IRQ1_STATUSレジスタ読み取り
2. **行838**: AXP2XX_IRQ1_VBUS_OVERVOLTチェック -> "overvoltage"通知
3. **行840**: AXP2XX_IRQ1_VBUS_LOWチェック -> "undervoltage"通知
4. **行850**: IRQ1_STATUSをACKでクリア

### プログラム呼び出し階層図

```
[ハードウェア割り込み（I2Cバス経由）]
    |
    +-- axp2xx_intr(arg)                            [axp209.c:827]
           |
           +-- axp2xx_read(dev, IRQ1_STATUS, &reg)   [axp209.c:834]
           |
           +-- [AXP2XX_IRQ1_VBUS_OVERVOLT チェック]
           |       +-- devctl_notify("PMU","USB","overvoltage",NULL)   [axp209.c:839]
           |
           +-- [AXP2XX_IRQ1_VBUS_LOW チェック]
           |       +-- devctl_notify("PMU","USB","undervoltage",NULL)  [axp209.c:841]
           |
           +-- axp2xx_write(dev, IRQ1_STATUS, ACK)    [axp209.c:850]
```

### データフロー図

```
[入力]                         [処理]                        [出力]

AXP2XX IRQ1 割り込み -------> axp2xx_intr()
(VBUS_OVERVOLT/LOW bit)        |
                               +-> devctl_notify() -------> /dev/devctl
                                                                |
                                                           devd(8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| axp209.c | `sys/arm/allwinner/axp209.c` | ソース | AXP2XX PMICドライバ。USB overvoltage/undervoltage通知を発行 |
| axp209reg.h | `sys/arm/allwinner/axp209reg.h` | ヘッダ | VBUS_OVERVOLT/VBUS_LOW定数定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
