# 通知設計書 29-PMU Battery charged

## 概要

本ドキュメントは、FreeBSDカーネルにおけるX-Power AXP209/AXP221 PMUのバッテリー充電完了通知「PMU Battery charged」の設計仕様を記述する。Allwinner SoCプラットフォームにおいて、バッテリーの充電が完了した際にdevctl_notifyを通じてユーザーランドへ通知する。

### 本通知の処理概要

本通知は、AXP2XX PMICの割り込みハンドラが、バッテリーの充電完了を検出した際に発行するdevctl通知イベントである。

**業務上の目的・背景**：バッテリー充電の完了は、電源管理ポリシーの切り替え（充電維持モードへの移行）やユーザーへのバッテリー状態通知に必要な情報である。devdデーモンがこの通知を受け取ることで、充電完了の通知音再生やLEDインジケータの更新、充電管理スクリプトの実行などを自動化できる。

**通知の送信タイミング**：AXP2XX PMICの割り込みステータスレジスタ（IRQ2_STATUS: 0x49）から、AXP2XX_IRQ2_BATT_CHARGED（ビット2）がセットされた際に送信される。

**通知の受信者**：ユーザーランドのdevd(8)デーモンが受信する。

**通知内容の概要**：システム名「PMU」、サブシステム名「Battery」、タイプ「charged」。追加データはNULL。

**期待されるアクション**：受信者は、充電完了の通知表示、LEDインジケータの更新、充電管理ログの記録などを実行することが期待される。

## 通知種別

カーネルdevctl通知（devctl_notify経由のデバイスイベント通知）。

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（割り込みハンドラからdevctl_notifyを呼び出し） |
| 優先度 | 中（バッテリー状態変化イベント） |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notifyによりカーネル通知キューにイベントを追加し、devd(8)が受信する。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | PMU |
| サブシステム名 | Battery |
| タイプ | charged |
| 追加データ | NULL（なし） |

### 本文テンプレート

```
!system=PMU subsystem=Battery type=charged
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | 固定値 "PMU" | Yes |
| subsystem | 通知のサブシステム名 | 固定値 "Battery" | Yes |
| type | 通知タイプ | 固定値 "charged" | Yes |
| data | 追加情報 | NULL | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | AXP2XX IRQ2割り込み | reg & AXP2XX_IRQ2_BATT_CHARGED | バッテリー充電が完了した |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| IRQ2ステータスレジスタが0 | IRQ2に該当する割り込みがない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AXP2XX割り込み発生] --> B[axp2xx_intr関数呼び出し]
    B --> C[IRQ1処理]
    C --> D[AXP2XX_IRQ2_STATUSレジスタ読み取り]
    D --> E{reg != 0?}
    E -->|No| F[次のIRQ処理へ]
    E -->|Yes| G{reg & AXP2XX_IRQ2_BATT_CHARGED?}
    G -->|Yes| H[devctl_notify PMU Battery charged NULL]
    G -->|No| I[他のIRQ2ビットチェック]
    H --> I
    I --> J[IRQ2_STATUSをACKでクリア]
    J --> F
```

## データベース参照・更新仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| I2C通信エラー | axp2xx_readが失敗した場合 | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 通知データはNULLのため情報漏洩リスクなし

## 備考

- AXP2XX_IRQ2_BATT_CHARGEDはビット2（0x04）
- IRQ2_ENABLEレジスタ（0x41）でAXP2XX_IRQ2_BATT_CHARGEDが有効化される（axp209.c:1235-1243）
- No.30（Battery charging）は充電中の通知であり、本通知は充電完了の通知である点で異なる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | axp209reg.h | `sys/arm/allwinner/axp209reg.h` | AXP2XX_IRQ2_BATT_CHARGED（行102、ビット2）、AXP2XX_IRQ2_STATUS（行96、レジスタ0x49）、AXP2XX_IRQ2_ENABLE（行95、レジスタ0x41） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_intr関数（行827-886）の行853-856がIRQ2処理ブロック |

**主要処理フロー**:
1. **行853**: AXP2XX_IRQ2_STATUSレジスタ読み取り
2. **行855**: AXP2XX_IRQ2_BATT_CHARGEDチェック -> "charged"通知
3. **行856**: devctl_notify("PMU", "Battery", "charged", NULL)
4. **行867**: IRQ2_STATUSをACKでクリア

#### Step 3: 割り込み有効化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | axp209.c | `sys/arm/allwinner/axp209.c` | axp2xx_start関数（行1235-1243）でIRQ2_ENABLEにBATT_CHARGEDを含むビットマスクを設定 |

### プログラム呼び出し階層図

```
[ハードウェア割り込み（I2Cバス経由）]
    |
    +-- axp2xx_intr(arg)                            [axp209.c:827]
           |
           +-- [IRQ1処理ブロック]
           |
           +-- axp2xx_read(dev, IRQ2_STATUS, &reg)   [axp209.c:853]
           |
           +-- [AXP2XX_IRQ2_BATT_CHARGED チェック]
           |       +-- devctl_notify("PMU","Battery","charged",NULL) [axp209.c:856]
           |
           +-- axp2xx_write(dev, IRQ2_STATUS, ACK)    [axp209.c:867]
```

### データフロー図

```
[入力]                         [処理]                        [出力]

AXP2XX IRQ2 割り込み -------> axp2xx_intr()
(BATT_CHARGED bit)             |
                               +-> devctl_notify() -------> /dev/devctl
                                                                |
                                                           devd(8)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| axp209.c | `sys/arm/allwinner/axp209.c` | ソース | AXP2XX PMICドライバ。割り込みハンドラでBattery charged通知を発行 |
| axp209reg.h | `sys/arm/allwinner/axp209reg.h` | ヘッダ | AXP2XX_IRQ2_BATT_CHARGED定数定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
