# 通知設計書 34-ACPI ACAD power

## 概要

本ドキュメントは、FreeBSDカーネルのPMU（電源管理ユニット）サブシステムにおけるACPI ACアダプター電源通知（ACPI ACAD power）の設計を記述する。TI AM335x SoC向けTPS65217 PMICドライバ（am335x_pmic.c）が、AC電源の接続状態変化を検知した際にdevctl経由でユーザランドへ通知を発行する仕組みを対象とする。

### 本通知の処理概要

本通知は、TI TPS65217 PMIC（BeagleBone等のAM335x SoCプラットフォームで使用）が、AC電源入力の状態変化（接続/切断）を検出した際に発行されるカーネルレベルの通知である。ACPIサブシステムの命名規則に従い、「ACPI」「ACAD」「power」のフィールド名で通知される。

**業務上の目的・背景**：組み込みシステムにおけるAC電源の接続状態変化は、電源管理ポリシーの切り替えトリガーとなる重要なイベントである。AC電源接続時はフルパフォーマンスモード、バッテリー駆動時は省電力モードへの切り替えなど、電源状態に応じた動作モード変更をユーザランドで実施するために必要である。

**通知の送信タイミング**：TPS65217のINTレジスタにおいてaci（AC input interrupt）ビットがセットされた際にハードウェア割り込みが発生し、割り込みハンドラam335x_pmic_intr内でdevctl_notifyが呼び出される。

**通知の受信者**：devd(8)デーモンおよびdevctl(4)インターフェースを監視するユーザランドプロセス。

**通知内容の概要**：システム名「ACPI」、サブシステム名「ACAD」、タイプ「power」、データとしてAC電源のステータス値（notify=0xNN形式）。

**期待されるアクション**：電源管理デーモンによる電源ポリシーの切り替え、バッテリー充電制御の調整、ユーザへの電源状態通知表示。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（ハードウェア割り込みハンドラから発行） |
| 優先度 | 高（ハードウェア割り込みレベル） |
| リトライ | 無し |

### 送信先決定ロジック

devctl_notifyによるブロードキャスト。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | ACPI |
| サブシステム名 | ACAD |
| タイプ | power |
| データ | notify=0xNN（status_reg.acpwrの値） |

### 本文テンプレート

```
!system=ACPI subsystem=ACAD type=power notify=0x01
!system=ACPI subsystem=ACAD type=power notify=0x00
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | ハードコード "ACPI" | Yes |
| subsystem | サブシステム名 | ハードコード "ACAD" | Yes |
| type | イベントタイプ | ハードコード "power" | Yes |
| notify | AC電源ステータス値 | TPS65217_STATUS_REG.acpwr | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | TPS65217 INTレジスタ aci ビットセット | int_reg.aci が真 | AC入力の状態変化が発生 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 割り込みリソース未取得 | sc_irq_resがNULLの場合、割り込みハンドラが登録されない |
| aci以外の割り込みのみ | int_reg.aciが偽の場合はAC電源通知は発行されない（pbiの場合はシャットダウン） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ハードウェア割り込み発生] --> B[am335x_pmic_intr 呼び出し]
    B --> C[TPS65217_INT_REG 読み取り]
    C --> D[TPS65217_STATUS_REG 読み取り]
    D --> E{int_reg.aci が真?}
    E -->|Yes| F[notify_buf に status_reg.acpwr を格納]
    E -->|No| G{int_reg.pbi && status_reg.pb?}
    F --> H["devctl_notify(ACPI, ACAD, power, notify_buf)"]
    G -->|Yes| I[shutdown_nice]
    G -->|No| J[終了]
    H --> J
    I --> J
```

## データベース参照・更新仕様

該当なし（カーネルドライバのため）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| INTレジスタ読み取りエラー | I2Cバス通信失敗 | device_printfでエラー出力後return |
| STATUSレジスタ読み取りエラー | I2Cバス通信失敗 | device_printfでエラー出力後return |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

/dev/devctlへのアクセスはrootのみ。通知にはAC電源の接続状態のみが含まれる。

## 備考

- TPS65217はBeagleBone Black等のAM335xベースボードで広く使用されるPMIC
- "ACPI" "ACAD" の命名はACPIのACアダプターデバイスオブジェクト名に由来するが、実際のACPIサブシステムではなくPMICドライバから発行される
- 同一割り込みハンドラ内でパワーボタン押下（pbi）も処理され、その場合はshutdown_niceが呼び出される
- notify_bufのフォーマットは "notify=0x%02x" でstatus_reg.acpwrの値が格納される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tps65217x.h | `sys/arm/ti/am335x/tps65217x.h` | TPS65217_INT_REG, TPS65217_STATUS_REGのレジスタ定義、tps65217_int_reg構造体、tps65217_status_reg構造体 |
| 1-2 | am335x_pmic.c | `sys/arm/ti/am335x/am335x_pmic.c` | am335x_pmic_softc構造体（58-63行目） |

**読解のコツ**: TPS65217のレジスタはビットフィールド構造体で定義されている。int_reg.aciがAC入力割り込み、status_reg.acpwrがAC電源ステータス。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | am335x_pmic.c | `sys/arm/ti/am335x/am335x_pmic.c` | am335x_pmic_start関数（200-278行目）での割り込みハンドラ登録 |

**主要処理フロー**:
1. **266-267行目**: 全割り込みのアンマスクとステータスクリア
2. **271-273行目**: bus_setup_intrでam335x_pmic_intrを割り込みハンドラとして登録

#### Step 3: 割り込みハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | am335x_pmic.c | `sys/arm/ti/am335x/am335x_pmic.c` | am335x_pmic_intr関数（86-117行目） |

**主要処理フロー**:
- **96行目**: TPS65217_INT_REGの読み取り
- **102行目**: TPS65217_STATUS_REGの読み取り
- **110-111行目**: pbi（パワーボタン割り込み）の処理（shutdown_nice）
- **112-116行目**: aci（AC入力割り込み）の処理でsnprintfとdevctl_notify発行

### プログラム呼び出し階層図

```
ハードウェア割り込み（TPS65217 AC入力状態変化）
    |
    +-- am335x_pmic_intr(sc)                      [sys/arm/ti/am335x/am335x_pmic.c:87]
            |
            +-- am335x_pmic_read(TPS65217_INT_REG)  [96]
            |
            +-- am335x_pmic_read(TPS65217_STATUS_REG) [102]
            |
            +-- snprintf(notify_buf, "notify=0x%02x", acpwr) [113-114]
            |
            +-- devctl_notify("ACPI","ACAD","power",notify_buf) [115]
```

### データフロー図

```
[入力]                     [処理]                        [出力]

TPS65217 INT_REG        am335x_pmic_intr()          /dev/devctl
(aci ビット) ---------> INT/STATUS読取 -----------> devctl_notify()
TPS65217 STATUS_REG     notify_buf生成              devdデーモン
(acpwr フィールド)      devctl_notify呼出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| am335x_pmic.c | `sys/arm/ti/am335x/am335x_pmic.c` | ソース | TPS65217 PMICドライバ本体 |
| tps65217x.h | `sys/arm/ti/am335x/tps65217x.h` | ヘッダ | TPS65217レジスタ定義と構造体 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
