# 通知設計書 35-keys brightness/mute/volume/eject

## 概要

本ドキュメントは、FreeBSDカーネルのPMU（電源管理ユニット）サブシステムにおけるキーボードメディアキー通知（keys brightness/mute/volume/eject）の設計を記述する。Apple ADB（Apple Desktop Bus）ボタンドライバ（adb_buttons.c）が、Mac向けキーボードの輝度、ミュート、音量、イジェクトボタンの押下を検知した際にdevctl経由でユーザランドへ通知を発行する仕組みを対象とする。

### 本通知の処理概要

本通知は、PowerMac等のAppleハードウェアに搭載されるADBバス上のメディアキーデバイスが、特殊キーの押下を検出した際に発行される複数種類のカーネルレベル通知である。

**業務上の目的・背景**：Appleハードウェアのキーボードには、通常のキーに加えて輝度調整、音量調整、CDイジェクト等のメディアコントロールキーが搭載されている。これらのキーイベントはADBプロトコルを通じてカーネルに到達するが、標準のキーボード入力としては処理されないため、devctl経由でユーザランドに通知し、デスクトップ環境やメディア制御デーモンが適切なアクションを実行できるようにする必要がある。

**通知の送信タイミング**：ADBデバイスからのパケット受信時に、abtn_receive_packet関数が呼び出され、受信したコマンドバイト（data[0]）の値に応じて対応するdevctl_notifyが発行される。

**通知の受信者**：devd(8)デーモンおよびdevctl(4)インターフェースを監視するユーザランドプロセス。

**通知内容の概要**：システム名「PMU」、サブシステム名「keys」、タイプは「brightness」「mute」「volume」「eject」のいずれか。データは方向指定（"notify=up"/"notify=down"）またはNULL。

**期待されるアクション**：輝度変更コマンドの実行、オーディオミュートのトグル、音量の増減、CD/DVDドライブのイジェクト実行。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（ADBパケット受信コールバックから発行） |
| 優先度 | 中（デバイスドライバコールバック） |
| リトライ | 無し |

### 送信先決定ロジック

devctl_notifyによるブロードキャスト。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | PMU |
| サブシステム名 | keys |
| タイプ | brightness / mute / volume / eject |
| データ | "notify=up" / "notify=down" / NULL |

### 本文テンプレート

```
!system=PMU subsystem=keys type=brightness notify=down
!system=PMU subsystem=keys type=brightness notify=up
!system=PMU subsystem=keys type=mute
!system=PMU subsystem=keys type=volume notify=down
!system=PMU subsystem=keys type=volume notify=up
!system=PMU subsystem=keys type=eject
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | ハードコード "PMU" | Yes |
| subsystem | サブシステム名 | ハードコード "keys" | Yes |
| type | キータイプ | ADBコマンドバイトから決定 | Yes |
| notify | 方向（up/down） | ADBコマンドバイトから決定 | brightness/volumeの場合のみ |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ADBパケット受信 | data[0] = 0x0a | 常時 | 輝度ダウンキー押下 |
| ADBパケット受信 | data[0] = 0x09 | 常時 | 輝度アップキー押下 |
| ADBパケット受信 | data[0] = 0x08 または 0x01 | 常時 | ミュートキー押下 |
| ADBパケット受信 | data[0] = 0x07 または 0x02 | 常時 | 音量ダウンキー押下 |
| ADBパケット受信 | data[0] = 0x06 または 0x03 | 常時 | 音量アップキー押下 |
| ADBパケット受信 | data[0] = 0x0b | 常時 | イジェクトキー押下 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ADBデバイスタイプがADB_DEVICE_MISCでない場合 | probe段階で拒否されるためドライバがアタッチされない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ADBパケット受信] --> B[abtn_receive_packet 呼び出し]
    B --> C[cmd = data 0 取得]
    C --> D{cmd の値判定}
    D -->|0x0a| E["devctl_notify(PMU, keys, brightness, notify=down)"]
    D -->|0x09| F["devctl_notify(PMU, keys, brightness, notify=up)"]
    D -->|0x08/0x01| G["devctl_notify(PMU, keys, mute, NULL)"]
    D -->|0x07/0x02| H["devctl_notify(PMU, keys, volume, notify=down)"]
    D -->|0x06/0x03| I["devctl_notify(PMU, keys, volume, notify=up)"]
    D -->|0x0b| J["devctl_notify(PMU, keys, eject, NULL)"]
    D -->|その他| K[無視]
    E --> L[終了]
    F --> L
    G --> L
    H --> L
    I --> L
    J --> L
    K --> L
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不明なADBコマンド | data[0]が定義済みコマンドに一致しない | DEBUGビルド時のみdevice_printfで出力、通常は無視 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（キー押下イベント駆動） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

/dev/devctlへのアクセスはrootのみ。通知にはキー押下イベントの種別のみが含まれる。

## 備考

- 本ドライバはPowerMac/PowerBook等のApple ADBバスを持つハードウェア専用
- ADB_DEVICE_MISCタイプのデバイスとして認識される
- コマンドバイト0x01-0x03はAVハードウェア向けの別系統のキーコード
- コマンド0x0c（ミラーディスプレイ）と0x7f（NumLock）はdevctl通知が実装されていない
- handler_idはadb_get_device_handler()で取得されるが、通知処理では使用されない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | adb.h | `sys/dev/adb/adb.h` | ADB_DEVICE_MISCの定義、ADBデバイスタイプの列挙 |
| 1-2 | adb_buttons.c | `sys/dev/adb/adb_buttons.c` | abtn_softc構造体（49-53行目） |

**読解のコツ**: ADBプロトコルでは、デバイスタイプ（keyboard, mouse, misc等）と、パケットデータの先頭バイトがコマンドを示す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | adb_buttons.c | `sys/dev/adb/adb_buttons.c` | abtn_probe関数（81-93行目）でADB_DEVICE_MISCタイプの判定 |
| 2-2 | adb_buttons.c | `sys/dev/adb/adb_buttons.c` | abtn_attach関数（95-106行目）でhandler_id取得 |

**主要処理フロー**:
1. **88行目**: ADB_DEVICE_MISCタイプチェック
2. **91行目**: "ADB Brightness/Volume/Eject Buttons" としてデバイス説明を設定

#### Step 3: パケット受信ハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | adb_buttons.c | `sys/dev/adb/adb_buttons.c` | abtn_receive_packet関数（108-156行目）でコマンドバイトに応じたswitch文 |

**主要処理フロー**:
- **114行目**: cmd = data[0] でコマンドバイト取得
- **117-119行目**: 0x0a -> brightness down通知
- **122-123行目**: 0x09 -> brightness up通知
- **126-128行目**: 0x08/0x01 -> mute通知
- **130-132行目**: 0x07/0x02 -> volume down通知
- **134-136行目**: 0x06/0x03 -> volume up通知
- **141-142行目**: 0x0b -> eject通知

### プログラム呼び出し階層図

```
ADBバスからのパケット受信
    |
    +-- abtn_receive_packet(dev, status, command, reg, len, data)
            |                                   [sys/dev/adb/adb_buttons.c:108]
            +-- switch(data[0])
                    |
                    +-- 0x0a: devctl_notify("PMU","keys","brightness","notify=down") [118]
                    +-- 0x09: devctl_notify("PMU","keys","brightness","notify=up")   [123]
                    +-- 0x08: devctl_notify("PMU","keys","mute",NULL)                [128]
                    +-- 0x07: devctl_notify("PMU","keys","volume","notify=down")     [132]
                    +-- 0x06: devctl_notify("PMU","keys","volume","notify=up")       [136]
                    +-- 0x0b: devctl_notify("PMU","keys","eject",NULL)               [142]
```

### データフロー図

```
[入力]                     [処理]                        [出力]

ADBデバイス              abtn_receive_packet()      /dev/devctl
(キー押下) -----------> コマンドバイト判定 -------> devctl_notify()
                        switch(cmd)               devdデーモン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| adb_buttons.c | `sys/dev/adb/adb_buttons.c` | ソース | ADBメディアキードライバ本体 |
| adb.h | `sys/dev/adb/adb.h` | ヘッダ | ADBデバイスタイプとインターフェース定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
