# 通知設計書 36-kernel power resume

## 概要

本ドキュメントは、FreeBSDカーネルにおけるシステム電源復帰（レジューム）通知（kernel power resume）の設計を記述する。カーネルのバスサブシステム（subr_bus.c）が、システムのサスペンドからの復帰完了後にdevctl経由でユーザランドへ通知を発行する仕組みを対象とする。

### 本通知の処理概要

本通知は、システムがサスペンド（スリープ）状態から復帰した際に、すべてのデバイスのレジューム処理が正常に完了した後に発行されるカーネルレベルの通知である。

**業務上の目的・背景**：サスペンドからの復帰は、ネットワーク接続の再確立、ディスプレイの復旧、時刻同期、デーモンの再活性化など、多くのユーザランドサービスの再初期化を必要とするイベントである。この通知により、devd(8)や電源管理デーモンがレジューム完了を検知し、必要な後処理を自動実行できる。

**通知の送信タイミング**：root_resume関数内で、bus_generic_resumeによる全デバイスのレジューム処理が成功（error == 0）した後にdevctl_notifyが呼び出される。

**通知の受信者**：devd(8)デーモンおよびdevctl(4)インターフェースを監視するユーザランドプロセス。

**通知内容の概要**：システム名「kernel」、サブシステム名「power」、タイプ「resume」。追加データはNULL。

**期待されるアクション**：ネットワーク再接続、NTPによる時刻同期、ディスプレイ設定の復元、各種サービスのウェイクアップ通知、ファイルシステムの整合性チェック。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（レジューム処理完了後に直接発行） |
| 優先度 | 高（カーネルバスサブシステムから発行） |
| リトライ | 無し |

### 送信先決定ロジック

devctl_notifyによるブロードキャスト。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | kernel |
| サブシステム名 | power |
| タイプ | resume |
| データ | NULL |

### 本文テンプレート

```
!system=kernel subsystem=power type=resume
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | ハードコード "kernel" | Yes |
| subsystem | サブシステム名 | ハードコード "power" | Yes |
| type | イベントタイプ | ハードコード "resume" | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| カーネル内部イベント | root_resume関数の呼び出し | bus_generic_resumeが成功（error == 0） | 全デバイスのレジューム処理が正常完了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| bus_generic_resumeが失敗 | error != 0 の場合は通知が発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[システムレジューム開始] --> B[root_resume 呼び出し]
    B --> C[bus_generic_resume 呼び出し]
    C --> D{error == 0?}
    D -->|Yes| E["devctl_notify(kernel, power, resume, NULL)"]
    D -->|No| F[通知なしでエラーコード返却]
    E --> G[error を返却]
    F --> G
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| デバイスレジューム失敗 | bus_generic_resumeがエラーを返した場合 | 通知を発行せずにエラーコードを返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（システムイベント駆動） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

/dev/devctlへのアクセスはrootのみ。通知にはシステムのレジューム完了の事実のみが含まれる。

## 備考

- root_resumeはルートバスデバイスのレジュームメソッドとして登録されている
- サスペンド（スリープ）開始時の対応する通知は実装されていない
- この通知はACPIのS3（スリープ）やS4（ハイバネーション）からの復帰時に発行される
- bus_generic_resumeは子デバイスを再帰的にレジュームするため、全ハードウェアの復帰完了を保証する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | subr_bus.c | `sys/kern/subr_bus.c` | ルートバスデバイスのメソッドテーブルにおけるroot_resumeの登録 |

**読解のコツ**: FreeBSDのデバイスツリーでは、ルートバス（nexus）がすべてのデバイスの祖先であり、root_resumeはこのルートバスのレジュームメソッド。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | subr_bus.c | `sys/kern/subr_bus.c` | root_resume関数（5124-5134行目） |

**主要処理フロー**:
1. **5129行目**: bus_generic_resumeを呼び出し、全子デバイスをレジューム
2. **5130-5131行目**: error == 0 の場合に `devctl_notify("kernel", "power", "resume", NULL)` を発行
3. **5133行目**: エラーコードを返却

### プログラム呼び出し階層図

```
電源管理サブシステム（ACPI等）
    |
    +-- root_resume(dev)                          [sys/kern/subr_bus.c:5125]
            |
            +-- bus_generic_resume(dev)            [5129]
            |       |
            |       +-- 各デバイスドライバのresume()
            |
            +-- devctl_notify("kernel","power","resume",NULL) [5131]
```

### データフロー図

```
[入力]                     [処理]                        [出力]

電源管理                 root_resume()              /dev/devctl
(レジューム要求) -----> bus_generic_resume -------> devctl_notify()
                        成功判定                    devdデーモン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | ルートバスデバイスのレジュームハンドラとdevctl_notify発行 |
| devctl.h | `sys/sys/devctl.h` | ヘッダ | devctl_notifyプロトタイプ |
| acpi.c | `sys/dev/acpica/acpi.c` | ソース | ACPIサブシステム（レジュームトリガー元） |
