# 通知設計書 37-kernel signal coredump

## 概要

本ドキュメントは、FreeBSDカーネルにおけるプロセスコアダンプ生成通知（kernel signal coredump）の設計を記述する。カーネルのvnodeコアダンプハンドラ（coredump_vnode.c）が、プロセスのコアダンプファイル生成に成功した際にdevctl経由でユーザランドへ通知を発行する仕組みを対象とする。

### 本通知の処理概要

本通知は、プロセスがシグナルを受信してコアダンプファイルを生成した際に発行されるカーネルレベルの通知である。通知にはプロセスの実行ファイルパス、コアファイルパス、JailID、PID、親PID、シグナル番号が含まれる。

**業務上の目的・背景**：プロセスのクラッシュとコアダンプの発生は、ソフトウェア障害の重要な指標である。この通知により、運用監視システムやCI/CDパイプラインがクラッシュイベントを自動検知し、デバッグセッションの自動開始、障害報告の作成、クラッシュ統計の収集などを実行できる。コアダンプの発生は品質管理上の重要なイベントであり、見落としなく捕捉する必要がある。

**通知の送信タイミング**：coredump_vnode関数内で、プロセスのコアダンプファイルの書き込みが成功し、かつsysctlのkern.coredump_devctlが1に設定されている場合に通知が発行される。

**通知の受信者**：devd(8)デーモンおよびdevctl(4)インターフェースを監視するユーザランドプロセス。

**通知内容の概要**：システム名「kernel」、サブシステム名「signal」、タイプ「coredump」。データにはcomm（実行ファイルパス）、core（コアファイルパス）、jid、pid、ppid、signoが含まれる。

**期待されるアクション**：自動デバッグセッションの起動、クラッシュレポートの生成、管理者への通知、コアファイルの自動バックアップ・分析。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コアダンプ処理完了後に発行） |
| 優先度 | 中（プロセスコンテキスト） |
| リトライ | 無し |

### 送信先決定ロジック

devctl_notifyによるブロードキャスト。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | kernel |
| サブシステム名 | signal |
| タイプ | coredump |
| データ | comm="..." core="..." jid=N pid=N ppid=N signo=N |

### 本文テンプレート

```
!system=kernel subsystem=signal type=coredump comm="/path/to/program" core="/path/to/corefile" jid=0 pid=1234 ppid=1 signo=11
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | ハードコード "kernel" | Yes |
| subsystem | サブシステム名 | ハードコード "signal" | Yes |
| type | イベントタイプ | ハードコード "coredump" | Yes |
| comm | 実行ファイルのフルパス | p->p_textvp (vn_fullpath_global) | Yes |
| core | コアファイルのパス | corefile_open()の結果 | Yes |
| jid | JailID | p->p_ucred->cr_prison->pr_id | Yes |
| pid | プロセスID | p->p_pid | Yes |
| ppid | 親プロセスID | p->p_oppid | Yes |
| signo | シグナル番号 | p->p_sig | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| カーネル内部イベント | コアダンプファイル書き込み完了 | error == 0 かつ coredump_devctl != 0 | コアダンプの生成に成功し、devctl通知が有効 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| kern.coredump_devctl == 0 | デフォルト値は0（無効）。1に設定すると通知が有効化される |
| コアダンプ書き込みエラー | error != 0 の場合は通知が発行されない |
| vn_fullpath_global失敗 | 実行ファイルのフルパス取得に失敗した場合はgoto out2でスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コアダンプ処理完了] --> B{error == 0?}
    B -->|No| I[通知なし]
    B -->|Yes| C{coredump_devctl != 0?}
    C -->|No| I
    C -->|Yes| D[sbuf_new_auto でバッファ作成]
    D --> E[vn_fullpath_global で実行ファイルパス取得]
    E --> F{パス取得成功?}
    F -->|No| I
    F -->|Yes| G[sbuf_printf で通知データ構築]
    G --> H["devctl_notify(kernel, signal, coredump, sbuf_data)"]
    H --> I[終了]
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パス取得失敗 | vn_fullpath_globalがエラー | goto out2で通知をスキップ |
| sbufエラー | sbuf_finishがエラー | devctl_notifyを呼ばずにスキップ |
| CWD取得失敗 | vn_getcwdがエラー（相対パスの場合） | goto out2で通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- /dev/devctlへのアクセスはrootのみ
- 通知データにはプロセスの実行ファイルパスとコアファイルパスが含まれるが、コアファイルの内容自体は含まれない
- パス文字列はdevctl_safe_quote_sbでエスケープ処理される
- Jail環境のプロセスのコアダンプにはjidが含まれ、Jail識別が可能

## 備考

- kern.coredump_devctlのデフォルト値は0（無効）であり、明示的に1に設定する必要がある
- コアファイル名のフォーマットはkern.corefileで制御される（デフォルト: "%N.core"）
- gzipまたはzstd圧縮されたコアファイルの場合も通知は発行される
- corefile_open関数はコアファイル名に%N(プロセス名), %P(PID), %U(UID), %I(インデックス)等の変数展開をサポート

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | coredump_vnode.c | `sys/kern/coredump_vnode.c` | coredump_devctl sysctl変数（113-115行目）でdevctl通知の有効/無効を制御 |
| 1-2 | coredump_vnode.c | `sys/kern/coredump_vnode.c` | coredump_vnode_ctx構造体とcoredump_writer構造体 |

**読解のコツ**: この通知はデフォルト無効であり、kern.coredump_devctl=1の設定が必要。通知データはsbufで動的に構築される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | coredump_vnode.c | `sys/kern/coredump_vnode.c` | coredump_vnode関数（432-562行目） |

**主要処理フロー**:
1. **451-453行目**: ppid, sig, jidの取得
2. **456-457行目**: corefile_openでコアファイルオープン
3. **502-503行目**: sv_coredumpでコアダンプ書き込み
4. **518行目**: error != 0 または coredump_devctl == 0 ならgoto out
5. **520-550行目**: sbufで通知データを構築

#### Step 3: 通知データ構築を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | coredump_vnode.c | `sys/kern/coredump_vnode.c` | 520-550行目の通知データ構築ロジック |

**主要処理フロー**:
- **521行目**: vn_fullpath_globalで実行ファイルのフルパス取得
- **523-524行目**: commフィールドをdevctl_safe_quote_sbでエスケープして追加
- **526行目**: coreフィールドの開始
- **533-543行目**: 相対パスの場合にCWDを前置
- **544行目**: コアファイル名をエスケープして追加
- **547-548行目**: jid, pid, ppid, signoを追加
- **549-550行目**: sbuf_finish成功時にdevctl_notify発行

### プログラム呼び出し階層図

```
シグナルハンドラ（SIGSEGVなど）
    |
    +-- coredump_vnode(td, limit)               [sys/kern/coredump_vnode.c:433]
            |
            +-- corefile_open()                  [456]
            |
            +-- sv_coredump()                    [503]
            |
            +-- vn_fullpath_global()             [521]
            |
            +-- devctl_safe_quote_sb()           [524,540,544]
            |
            +-- sbuf_printf() (jid,pid,ppid,signo) [547]
            |
            +-- devctl_notify("kernel","signal","coredump",sbuf_data) [550]
```

### データフロー図

```
[入力]                     [処理]                        [出力]

プロセスクラッシュ       coredump_vnode()            /dev/devctl
(シグナル受信) -------> コアファイル書き込み -------> devctl_notify()
p->p_sig               sbufで通知データ構築         devdデーモン
p->p_pid               devctl_notify呼出
p->p_textvp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| coredump_vnode.c | `sys/kern/coredump_vnode.c` | ソース | vnodeコアダンプハンドラとdevctl_notify発行 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify, devctl_safe_quote_sbの実装 |
| devctl.h | `sys/sys/devctl.h` | ヘッダ | devctl_notifyプロトタイプ |
| kern_sig.c | `sys/kern/kern_sig.c` | ソース | シグナル処理（コアダンプのトリガー元） |
