# 通知設計書 38-CAM iosched latency

## 概要

本ドキュメントは、FreeBSDカーネルのCAM（Common Access Method）サブシステムにおけるI/Oスケジューラのレイテンシ通知（CAM iosched latency）の設計を記述する。CAM I/Oスケジューラ（cam_iosched.c）が、I/O操作のレイテンシが設定された閾値（bad_latency）を超過した際にdevctl経由でユーザランドへ通知を発行する仕組みを対象とする。

### 本通知の処理概要

本通知は、CAMサブシステムの動的I/Oスケジューラ（CAM_IOSCHED_DYNAMIC有効時）が、個々のI/O操作の完了レイテンシを計測し、設定された閾値を超過するアウトライアーを検出した際に発行されるカーネルレベルの通知である。

**業務上の目的・背景**：ストレージデバイスのI/Oレイテンシ異常は、ディスク障害の前兆やシステムパフォーマンス劣化の重要な指標である。特にSSDにおいては、書き込みレイテンシの増大が読み取りレイテンシに影響を与える現象（ライトアンプリフィケーション等）が知られている。この通知により、ストレージ監視デーモンがレイテンシ異常を即座に検知し、I/Oスケジューリングポリシーの調整やデバイス交換の判断を支援する。

**通知の送信タイミング**：cam_iosched_update関数内で、個別のI/O操作の完了レイテンシ（sim_latency）がiop->bad_latencyを超過した際にcam_iosched_devctl_outlier関数が呼び出され、devctl_notifyが発行される。

**通知の受信者**：devd(8)デーモンおよびdevctl(4)インターフェースを監視するユーザランドプロセス。

**通知内容の概要**：システム名「CAM」、サブシステム名「iosched」、タイプ「latency」。データにはデバイス名、LBA、ブロック数、レイテンシ（ナノ秒）が含まれる。

**期待されるアクション**：ストレージデバイスの健全性チェック、I/Oスケジューリングパラメータの調整、SMART情報の確認、デバイス交換の検討。

## 通知種別

カーネルdevctl通知（devctl_notify経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（I/O完了コールバック内で発行） |
| 優先度 | 中（I/O完了処理コンテキスト） |
| リトライ | 無し |

### 送信先決定ロジック

devctl_notifyによるブロードキャスト。

## 通知テンプレート

### devctl通知の場合

| 項目 | 内容 |
|-----|------|
| システム名 | CAM |
| サブシステム名 | iosched |
| タイプ | latency |
| データ | device=XXNN lba=NNN blocks=NNN latency=NNN |

### 本文テンプレート

```
!system=CAM subsystem=iosched type=latency device=da0 lba=12345 blocks=8 latency=500000000
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| system | 通知のシステム名 | ハードコード "CAM" | Yes |
| subsystem | サブシステム名 | ハードコード "iosched" | Yes |
| type | イベントタイプ | ハードコード "latency" | Yes |
| device | デバイス名（名前+番号） | iop->softc->periph->periph_name + unit_number | Yes |
| lba | 論理ブロックアドレス | bp->bio_pblkno | Yes |
| blocks | ブロック数 | bp->bio_bcount / d_sectorsize | Yes |
| latency | レイテンシ（ナノ秒） | sbttons(sim_latency) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| I/O完了 | cam_iosched_update呼び出し | sim_latency > iop->bad_latency | I/O操作のレイテンシが閾値を超過 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| CAM_IOSCHED_DYNAMIC未定義 | コンパイル時にCAM_IOSCHED_DYNAMICが定義されていない場合、動的スケジューラ機能全体が無効 |
| bad_latency == 0 | 閾値が0の場合、比較が常にfalseとなり通知されない |
| malloc失敗 | sbufバッファのmalloc(M_NOWAIT)が失敗した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[I/O操作完了] --> B[cam_iosched_io_metric_update]
    B --> C[cam_iosched_update]
    C --> D{sim_latency > bad_latency?}
    D -->|Yes| E[cam_iosched_devctl_outlier]
    D -->|No| F[統計更新のみ]
    E --> G[sbuf でメッセージ構築]
    G --> H["devctl_notify(CAM, iosched, latency, sbuf_data)"]
    H --> I[too_long カウンタ++]
    F --> I
```

## データベース参照・更新仕様

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メモリ確保失敗 | malloc(M_NOWAIT)がNULL返却 | return で通知をスキップ |
| sbufエラー | sbuf_finishがエラー | devctl_notifyを呼ばずにスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（I/Oイベント駆動。高負荷時は大量発生の可能性あり） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

/dev/devctlへのアクセスはrootのみ。通知にはデバイス名とI/O統計情報が含まれるが、I/Oデータの内容は含まれない。

## 備考

- CAM_IOSCHED_DYNAMICはコンパイルオプションであり、do_dynamic_iosched sysctlで動的に有効/無効を切り替え可能
- bad_latencyの値はsysctl経由で設定可能
- 通知バッファサイズはCAM_IOSCHED_DEVD_MSG_SIZE（256バイト）に制限される
- レイテンシはsbintime_t型で内部計測され、sbttons()でナノ秒に変換される
- read_stats, write_stats, trim_statsの3種類のI/Oタイプそれぞれに対して閾値判定が行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cam_iosched.c | `sys/cam/cam_iosched.c` | iop_stats構造体のbad_latency, too_longフィールド |
| 1-2 | cam_iosched.c | `sys/cam/cam_iosched.c` | CAM_IOSCHED_DYNAMICコンパイルオプション（69-74行目） |

**読解のコツ**: iop_statsはI/Oタイプ別（read/write/trim）の統計構造体。bad_latencyが閾値、too_longが超過カウント。

#### Step 2: I/O完了パスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cam_iosched.c | `sys/cam/cam_iosched.c` | cam_iosched_io_metric_update関数（2050-2067行目）でI/Oタイプ別にcam_iosched_updateを呼び出し |

#### Step 3: 閾値判定と通知発行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cam_iosched.c | `sys/cam/cam_iosched.c` | cam_iosched_update関数（1960-1973行目）で閾値判定 |
| 3-2 | cam_iosched.c | `sys/cam/cam_iosched.c` | cam_iosched_devctl_outlier関数（1936-1957行目）で通知データ構築とdevctl_notify発行 |

**主要処理フロー**:
- **1970行目**: sim_latency > iop->bad_latency の判定
- **1971行目**: cam_iosched_devctl_outlier呼び出し
- **1949-1952行目**: sbuf_printfでdevice, lba, blocks, latencyを構築
- **1954行目**: devctl_notify("CAM", "iosched", "latency", sbuf_data(&sb))

### プログラム呼び出し階層図

```
CAMペリフェラルドライバ（I/O完了コールバック）
    |
    +-- cam_iosched_io_metric_update(isc, sim_latency, bp) [cam_iosched.c:2050]
            |
            +-- cam_iosched_update(&isc->read_stats, ...)  [2056]
            |   +-- cam_iosched_devctl_outlier(iop, sim_latency, bp) [1971]
            |       +-- devctl_notify("CAM","iosched","latency",...) [1954]
            |
            +-- cam_iosched_update(&isc->write_stats, ...) [2059]
            |
            +-- cam_iosched_update(&isc->trim_stats, ...)  [2062]
```

### データフロー図

```
[入力]                     [処理]                        [出力]

I/O完了イベント          cam_iosched_update()        /dev/devctl
sim_latency ----------> 閾値比較 -----------------> devctl_notify()
bp (bio構造体)          cam_iosched_devctl_outlier  devdデーモン
                        sbufでデータ構築
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cam_iosched.c | `sys/cam/cam_iosched.c` | ソース | CAM I/Oスケジューラ本体 |
| cam_iosched.h | `sys/cam/cam_iosched.h` | ヘッダ | I/Oスケジューラインターフェース |
| cam_periph.c | `sys/cam/cam_periph.c` | ソース | ペリフェラルドライバ共通処理 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify関数の実装 |
