# 通知設計書 46-HDAコネクタイベント通知

## 概要

本ドキュメントは、FreeBSD カーネルの HDA（Intel High Definition Audio）ドライバが、オーディオコネクタの接続状態変更時に発行する devctl 通知「SND / CONN / {IN|OUT}」の設計を記述する。

### 本通知の処理概要

HD Audio コーデックドライバ（hdaa）において、ヘッドフォンジャックやマイクジャックなどのオーディオコネクタの接続・切断が検知された際に、ユーザーランドへ状態変更を通知する。オーディオデバイスの入力（IN）または出力（OUT）方向ごとに通知が発行される。

**業務上の目的・背景**：ユーザーがヘッドフォンやマイクを接続・切断した際に、オーディオルーティングを自動的に切り替える必要がある。この通知により、デスクトップ環境のサウンドマネージャーが接続状態をリアルタイムに検知し、適切なオーディオデバイスへの自動切り替え、音量設定の変更、ミキサー構成の更新を行える。

**通知の送信タイミング**：HD Audio コーデックが unsolicited response（非要求応答）を受信し、ジャック検出ウィジェットの接続状態が変化した際に送信される。現在使用中のコーデックのオーディオアソシエーションに関連するコネクタ変更のみが通知対象となる。

**通知の受信者**：devd(8) デーモンを経由して、PulseAudio/PipeWire 等のサウンドサーバーやデスクトップ環境のオーディオ管理ツールが受信する。

**通知内容の概要**：関連する DSP デバイスの名前（cdev=dspN）が含まれる。

**期待されるアクション**：受信者はオーディオデバイスの切り替え、音量設定の変更、ミキサー構成の更新を実行する。

## 通知種別

devctl カーネル通知（devd(8) 経由のシステムイベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（カーネル内 devctl_notify） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notify() によりカーネルの devctl キューに投入される。

## 通知テンプレート

### devctl 通知フォーマット

| 項目 | 内容 |
|-----|------|
| system | SND |
| subsystem | CONN |
| type | IN（入力方向）または OUT（出力方向） |
| data | cdev=dspN |

### 本文テンプレート

```
!system=SND subsystem=CONN type=OUT
cdev=dsp0
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| cdev | DSP デバイス名 | device_get_unit(asp->pdevinfo->dev) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | HD Audio unsolicited response | ジャック検出ウィジェットの接続状態変化 | コネクタの挿入/抜去検知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非アクティブコーデック | 現在使用中でないコーデックのイベントは無視 |
| アソシエーション不一致 | 接続されたアソシエーションに対応する出力/入力が見つからない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[HD Audio unsolicited response 受信] --> B[ジャック検出ウィジェット特定]
    B --> C{現在アクティブなコーデック?}
    C -->|No| D[無視]
    C -->|Yes| E[オーディオアソシエーション走査]
    E --> F{対応するアソシエーション発見?}
    F -->|No| D
    F -->|Yes| G[snprintf で cdev=dspN を構築]
    G --> H[devctl_notify SND/CONN/IN or OUT 発行]
    D --> I[終了]
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| 構造体 | 用途 | 備考 |
|-----------|------|------|
| struct hdaa_devinfo | コーデックデバイス情報 | アソシエーション配列を保持 |
| struct hdaa_audio_as | オーディオアソシエーション | dir（IN/OUT）, pdevinfo, enable フラグ |
| struct hdaa_widget | ウィジェット情報 | ジャック検出に使用 |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 対応アソシエーション不在 | 接続変化に対応する有効なアソシエーションがない | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 明示的な制限なし |
| 1日あたり上限 | 明示的な制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 通知には DSP デバイス番号のみが含まれ、機密情報は含まれない
- /dev/devctl の読み取りには root 権限が必要

## 備考

- IN は入力方向（マイクなど）、OUT は出力方向（ヘッドフォンなど）を示す
- 同一コーデック上の複数のアソシエーションが存在する場合、接続変化に関連するアソシエーション、または同じ方向の最初のアソシエーションが通知対象となる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HD Audio のアソシエーションとウィジェット構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hdaa.h | `sys/dev/sound/pci/hda/hdaa.h` | struct hdaa_audio_as（dir, pdevinfo, enable, index）、HDAA_CTL_IN/OUT の定義 |

**読解のコツ**: HD Audio のアーキテクチャでは、オーディオストリームが「アソシエーション」として管理され、各アソシエーションに DSP デバイスが対応する。

#### Step 2: エントリーポイントを理解する

ジャック検出から通知発行までの流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hdaa.c | `sys/dev/sound/pci/hda/hdaa.c` | unsolicited response ハンドラ内のジャック検出処理（行576-595付近） |

**主要処理フロー**:
1. **行576-579**: アクティブなコーデックかチェック
2. **行583-595**: アソシエーション配列を走査し、接続変化に対応するものを検索
3. **行589-590**: snprintf で "cdev=dspN" を構築
4. **行591-592**: devctl_notify("SND", "CONN", direction, buf) を発行

### プログラム呼び出し階層図

```
hdaa_unsol_intr()                          [unsolicited response 割り込み]
    |
    +-- hdaa_jack_detect_handler()          [ジャック検出処理]
            |
            +-- [アクティブチェック]
            +-- [アソシエーション走査]
            +-- devctl_notify("SND", "CONN", "IN"/"OUT", ...)  [行591]
```

### データフロー図

```
[入力]                     [処理]                         [出力]

HD Audio unsolicited --> ジャック検出           --> devctl キュー
response                アソシエーション走査         |
                        方向判定(IN/OUT)        devd(8) 受信
                        cdev=dspN 構築
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hdaa.c | `sys/dev/sound/pci/hda/hdaa.c` | ソース | HD Audio オーディオ機能ドライバ。通知発行元 |
| hdaa.h | `sys/dev/sound/pci/hda/hdaa.h` | ヘッダー | HD Audio データ構造定義 |
| hdac.h | `sys/dev/sound/pci/hda/hdac.h` | ヘッダー | HD Audio コントローラ定義 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify() 実装 |
