# 通知設計書 48-HyperVネットワークVF状態通知

## 概要

本ドキュメントは、FreeBSD カーネルの Hyper-V ネットワークドライバ（hn）が、SR-IOV 仮想機能（VF）デバイスのデータパス切り替え時に発行する devctl 通知「HYPERV_NIC_VF / {hn_ifname} / VF_UP|VF_DOWN」の設計を記述する。

### 本通知の処理概要

Hyper-V 仮想マシン環境において、SR-IOV（Single Root I/O Virtualization）の VF（Virtual Function）デバイスによる高速データパスと、合成ネットワーク（NetVSC）経由のフォールバックデータパスが動的に切り替わる際に、状態変更を通知する。

**業務上の目的・背景**：Hyper-V の Accelerated Networking 機能では、VF デバイスが利用可能な場合はハードウェア直接アクセスによる高速通信を行い、VF が利用不可の場合は合成ネットワーク経由にフォールバックする。この切り替えは VM のライブマイグレーション時やホスト側の保守作業時に発生する。通知により、ネットワーク管理ツールがデータパスの状態を追跡し、パフォーマンス監視やトラブルシューティングに活用できる。

**通知の送信タイミング**：VF デバイスへのデータパス切り替え（VF_UP）、または合成ネットワークへのフォールバック（VF_DOWN）が実行された際に送信される。

**通知の受信者**：devd(8) デーモンを経由して、ネットワーク監視ツールや VM 管理スクリプトが受信する。

**通知内容の概要**：hn インターフェース名が subsystem として、VF の上昇/下降状態が type として含まれる。追加データは含まれない（NULL）。

**期待されるアクション**：受信者はネットワークパフォーマンスの監視データの更新、ログ記録、必要に応じたネットワーク設定の調整を行う。

## 通知種別

devctl カーネル通知（devd(8) 経由のシステムイベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（カーネル内 devctl_notify） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notify() によりカーネルの devctl キューに投入される。

## 通知テンプレート

### devctl 通知フォーマット

| 項目 | 内容 |
|-----|------|
| system | HYPERV_NIC_VF |
| subsystem | hn インターフェース名（例: hn0） |
| type | VF_UP または VF_DOWN |
| data | NULL（追加データなし） |

### 本文テンプレート

```
!system=HYPERV_NIC_VF subsystem=hn0 type=VF_UP
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| subsystem（IF名） | hn ネットワークインターフェース名 | if_name(hn_ifp) | Yes |
| type（状態） | VF_UP: VF データパスへの切り替え、VF_DOWN: 合成NW への切り替え | rxvf フラグ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Hyper-V メッセージ | VF データパス切り替え | NVS データパス変更処理完了 | VF_UP: VF が利用可能になった |
| Hyper-V メッセージ | 合成NWフォールバック | NVS データパス変更処理完了 | VF_DOWN: VF が利用不可になった |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | データパス切り替え処理の一部として常に送信される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Hyper-V からの VF 状態変更通知] --> B[NVS データパス切り替え]
    B --> C{rxvf == true?}
    C -->|Yes| D[VF データパスに切り替え]
    C -->|No| E[合成 NW に切り替え]
    D --> F[hn_rxvf_set で VF 設定]
    E --> G[hn_rxvf_set で VF 解除]
    F --> H[RSS 設定修正、管理タスク中断]
    G --> I[RSS 設定復元、管理タスク再開]
    H --> J[devctl_notify VF_UP 発行]
    I --> K[devctl_notify VF_DOWN 発行]
    J --> L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| 構造体 | 用途 | 備考 |
|-----------|------|------|
| struct hn_softc | hn ドライバの softc 構造体 | hn_link_flags, hn_ifp |
| struct ifnet | ネットワークインターフェース構造体 | if_name() |

### 更新テーブル一覧

| 構造体フィールド | 操作 | 概要 |
|-----------|------|------|
| hn_link_flags | UPDATE | LINKUP, NETCHG フラグのクリア（VF_UP 時） |
| rxvf | UPDATE | VF インターフェースの設定/解除 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| NVS スイッチ失敗 | データパス切り替えコマンドの失敗 | 通知は発行されない（切り替え処理自体が完了しない） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 明示的な制限なし |
| 1日あたり上限 | 明示的な制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 通知にはインターフェース名のみが含まれ、機密情報は含まれない
- /dev/devctl の読み取りには root 権限が必要
- data が NULL のため、追加情報の漏洩リスクはない

## 備考

- VF_UP 時にはリンク状態が DOWN に変更され、VF 経由の通信が開始される
- VF_DOWN 時にはリンク状態が合成 NW 経由に復帰し、管理タスクが再開される
- bootverbose が設定されている場合、コンソールにもデータパス切り替えメッセージが出力される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

hn ドライバの softc 構造体と VF 関連フィールドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | if_hn.c | `sys/dev/hyperv/netvsc/if_hn.c` | hn_softc 構造体（hn_link_flags, hn_ifp 等） |

**読解のコツ**: Hyper-V のネットワークドライバは合成NW (NetVSC) と VF (SR-IOV) の二重パスを管理する。HN_NVS_DATAPATH_VF と HN_NVS_DATAPATH_SYNTH の切り替えを理解すること。

#### Step 2: エントリーポイントを理解する

VF データパス切り替えと通知発行の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | if_hn.c | `sys/dev/hyperv/netvsc/if_hn.c` | VF データパス切り替え処理（行1209-1229付近） |

**主要処理フロー**:
1. **行1209**: NVS データパススイッチコマンド送信
2. **行1211**: hn_rxvf_set() で VF インターフェース設定
3. **行1213-1221**: rxvf に応じた RSS/管理タスクの処理
4. **行1224-1225**: devctl_notify("HYPERV_NIC_VF", if_name(hn_ifp), rxvf ? "VF_UP" : "VF_DOWN", NULL) 発行

### プログラム呼び出し階層図

```
[Hyper-V ホストからの VF 状態変更]
    |
    +-- hn_nvs_datapath_switch()           [NVS データパス切り替え]
            |
            +-- hn_rxvf_set()              [VF 受信設定]
            +-- hn_vf_rss_fixup/restore()  [RSS 設定調整]
            +-- hn_suspend/resume_mgmt()   [管理タスク制御]
            +-- devctl_notify()            [行1224: 通知発行]
```

### データフロー図

```
[入力]                     [処理]                         [出力]

Hyper-V ホスト ---------> NVS データパス切り替え -----> devctl キュー
VF 状態変更メッセージ          |                           |
                        hn_rxvf_set()                devd(8) 受信
                        RSS/管理タスク調整
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| if_hn.c | `sys/dev/hyperv/netvsc/if_hn.c` | ソース | Hyper-V ネットワークドライバ。通知発行元 |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify() 実装 |
