# 通知設計書 49-AmigaOne電源ボタン通知

## 概要

本ドキュメントは、FreeBSD カーネルの AmigaOne プラットフォームドライバが、電源ボタンが物理的に押下された際に発行する devctl 通知「AEON / power / press」の設計を記述する。

### 本通知の処理概要

AmigaOne (A-Eon/Varisys) プラットフォーム上で、物理的な電源ボタンが押下された際に、ハードウェア割り込み（IRQ#4）を通じてカーネルが電源ボタン押下イベントを検知し、devctl 通知を発行する。

**業務上の目的・背景**：AmigaOne は PowerPC ベースのデスクトップ/ワークステーション向けプラットフォームである。電源ボタンの押下をユーザーランドに通知することで、devd(8) 経由でグレースフルシャットダウンの実行、サスペンド処理、またはユーザーへの確認ダイアログの表示など、プラットフォームに応じた電源管理アクションを実現できる。ハードウェアによる即時電源断ではなく、ソフトウェアによる制御された対応を可能にする。

**通知の送信タイミング**：物理的な電源ボタンが押下され、IRQ#4（エッジトリガー、ロウアクティブ）が発生した際に送信される。

**通知の受信者**：devd(8) デーモンを経由して、電源管理スクリプトやデスクトップ環境の電源管理ツールが受信する。

**通知内容の概要**：追加データなし（NULL）。system="AEON", subsystem="power", type="press" のみ。

**期待されるアクション**：受信者はシステムのグレースフルシャットダウン（shutdown -p now）、またはユーザーへの電源オフ確認ダイアログの表示を実行する。

## 通知種別

devctl カーネル通知（devd(8) 経由のシステムイベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（カーネル内 devctl_notify、割り込みコンテキスト） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

devctl_notify() によりカーネルの devctl キューに投入される。

## 通知テンプレート

### devctl 通知フォーマット

| 項目 | 内容 |
|-----|------|
| system | AEON |
| subsystem | power |
| type | press |
| data | NULL（追加データなし） |

### 本文テンプレート

```
!system=AEON subsystem=power type=press
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定値のみ、追加データなし）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ハードウェア割り込み | IRQ#4（電源ボタン） | is_aeon == true | AmigaOne プラットフォームの電源ボタン押下 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| is_aeon == false | AmigaOne プラットフォームでない場合は割り込みハンドラ自体が登録されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[電源ボタン押下] --> B[IRQ#4 発生]
    B --> C[aeon_pbutton_intr 割り込みハンドラ]
    C --> D[devctl_notify AEON/power/press 発行]
    D --> E[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（固定値による通知のみ）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| devctl キュー満杯 | devctl キューが一杯の場合 | 通知は破棄される（カーネル内で自動処理） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 明示的な制限なし（物理ボタンの押下頻度に依存） |
| 1日あたり上限 | 明示的な制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 通知には追加データが含まれない（NULL）
- /dev/devctl の読み取りには root 権限が必要
- 物理的なボタン操作が必要なため、リモート攻撃による偽装のリスクは低い

## 備考

- AmigaOne は Varisys 社が製造する PowerPC ベースのプラットフォーム
- 割り込みはエッジトリガー、ロウアクティブに設定される
- is_aeon フラグは aeon_attach() で設定され、Open Firmware の model プロパティが "varisys," で始まるプラットフォームでのみ有効
- 割り込みハンドラは SI_SUB_CONFIGURE / SI_ORDER_ANY の優先度で SYSINIT により登録される
- MPC85xx (e500) コアベースのプラットフォームドライバ（mpc85xx_platform）を継承

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AmigaOne プラットフォーム固有のデータはほとんどなく、グローバルフラグ is_aeon のみ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | platform_amigaone.c | `sys/powerpc/amigaone/platform_amigaone.c` | is_aeon グローバルフラグ（行60）。プラットフォーム検出結果を保持 |

**読解のコツ**: FreeBSD の platform ドライバフレームワークは PLATFORMMETHOD マクロでプラットフォーム固有の操作を定義する。aeon_platform は mpc85xx_platform を継承している。

#### Step 2: エントリーポイントを理解する

プラットフォーム検出と割り込みハンドラ登録の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | platform_amigaone.c | `sys/powerpc/amigaone/platform_amigaone.c` | aeon_probe()（行63-76）でプラットフォーム検出 |
| 2-2 | platform_amigaone.c | `sys/powerpc/amigaone/platform_amigaone.c` | aeon_attach()（行79-90）で is_aeon = true 設定 |
| 2-3 | platform_amigaone.c | `sys/powerpc/amigaone/platform_amigaone.c` | aeon_setup_intr()（行101-118）で IRQ#4 の割り込みハンドラ登録 |

**主要処理フロー**:
1. **行70-72**: Open Firmware の model プロパティで "varisys," プレフィックスを確認
2. **行87**: is_aeon = true 設定
3. **行111**: irq = 4（TRM による IRQ#4 が電源ボタン）
4. **行114**: MAP_IRQ(0, irq) でルート PIC の IRQ にマッピング
5. **行115**: エッジトリガー、ロウアクティブに設定
6. **行116-117**: aeon_pbutton_intr を割り込みハンドラとして登録

#### Step 3: 通知発行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | platform_amigaone.c | `sys/powerpc/amigaone/platform_amigaone.c` | aeon_pbutton_intr()（行93-97）が割り込みハンドラ |

**主要処理フロー**:
- **行96**: devctl_notify("AEON", "power", "press", NULL) - 固定パラメータで通知発行

### プログラム呼び出し階層図

```
[ブート時初期化]
aeon_probe()                               [行63: プラットフォーム検出]
    |
aeon_attach()                              [行79: is_aeon = true]
    |
aeon_setup_intr() [SYSINIT]                [行101: 割り込みハンドラ登録]
    |
    +-- powerpc_config_intr()              [行115: 割り込み設定]
    +-- powerpc_setup_intr()               [行116: ハンドラ登録]

[実行時]
IRQ#4 発生                                  [電源ボタン押下]
    |
    +-- aeon_pbutton_intr()                [行93: 割り込みハンドラ]
            |
            +-- devctl_notify()            [行96: 通知発行]
```

### データフロー図

```
[入力]                     [処理]                         [出力]

電源ボタン押下 ---------> IRQ#4 割り込み ---------> devctl キュー
                          aeon_pbutton_intr()           |
                          devctl_notify()           devd(8) 受信
                          (固定パラメータ)              |
                                                   shutdown -p now
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| platform_amigaone.c | `sys/powerpc/amigaone/platform_amigaone.c` | ソース | AmigaOne プラットフォームドライバ。通知発行元 |
| mpc85xx.h | `sys/powerpc/mpc85xx/mpc85xx.h` | ヘッダー | MPC85xx プラットフォーム共通定義 |
| platform.h | `sys/powerpc/include/platform.h` | ヘッダー | プラットフォームドライバフレームワーク |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify() 実装 |
