# 通知設計書 8-IFNET ATTACH

## 概要

本ドキュメントは、FreeBSDカーネルのネットワークスタックにおいて、ネットワークインターフェースがアタッチされた際に発行されるdevctl通知「IFNET <インターフェース名> ATTACH」の設計を記述する。

### 本通知の処理概要

ネットワークインターフェースがカーネルに登録（アタッチ）された際に、devctlサブシステムを通じてユーザランドに通知を送信する処理である。

**業務上の目的・背景**：新しいネットワークインターフェース（物理NIC、仮想インターフェース、VLANインターフェース等）がシステムに追加された際に、ユーザランドのネットワーク管理デーモン（devd、NetworkManager等）がインターフェースの出現を検知する必要がある。これにより、IPアドレスの自動設定、ルーティングの設定、ファイアウォールルールの適用などの自動化が可能になる。

**通知の送信タイミング**：if_attach_internal()関数の末尾で、EVENTHANDLER_INVOKE(ifnet_attached_event)の後、デフォルトVNET内でのみ送信される。

**通知の受信者**：devd(8)デーモンおよび/dev/devctlをモニタリングしているユーザランドプロセスが受信する。

**通知内容の概要**：アタッチされたインターフェースの名前がsubsystemとして通知される。dataはNULL。

**期待されるアクション**：受信したデーモンは、インターフェースのIPアドレス設定、DHCPクライアントの起動、ルーティングの設定、ファイアウォールルールの適用などを実行する。

## 通知種別

カーネル内devctl通知（/dev/devctl経由のユーザランド通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（devctlキューへのエンキュー） |
| 優先度 | 通常 |
| リトライ | なし |

### 送信先決定ロジック

devctl_notify()により全リスナーにブロードキャストされる。

## 通知テンプレート

### devctl通知メッセージ

| 項目 | 内容 |
|-----|------|
| system | `IFNET` |
| subsystem | `<インターフェース名>` (例: "em0", "igb0", "lo0") |
| type | `ATTACH` |
| data | NULL |

### 本文テンプレート

```
!system=IFNET subsystem=<インターフェース名> type=ATTACH
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| subsystem (インターフェース名) | アタッチされたインターフェースの名前 | ifp->if_xname | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| カーネル内部イベント | if_attach_internal()完了 | IS_DEFAULT_VNET(curvnet) == true | デフォルトVNET内でのみ通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非デフォルトVNET | jail(8)等で作成された非デフォルトVNETではATTACH通知は発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ネットワークインターフェース登録] --> B[if_attach_internal呼出]
    B --> C[EVENTHANDLER_INVOKE ifnet_arrival_event]
    C --> D[if_link_ifnet]
    D --> E[EVENTHANDLER_INVOKE ifnet_attached_event]
    E --> F{IS_DEFAULT_VNET?}
    F -->|Yes| G[devctl_notify IFNET if_xname ATTACH NULL]
    F -->|No| H[通知なし]
    G --> I[終了]
    H --> I
```

## データベース参照・更新仕様

### カーネル内データ構造

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| struct ifnet | ネットワークインターフェース | if_xnameからインターフェース名を取得 |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | devctl_notify()は戻り値なし | N/A |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- /dev/devctlへのアクセスにはroot権限が必要
- 通知に含まれるのはインターフェース名のみ
- data引数はNULLで追加情報は含まれない

## 備考

- IS_DEFAULT_VNET()チェックにより、jail環境内でのインターフェースアタッチではホストOS側への通知は発行されない
- インターフェース名はifp->if_xnameから取得され、"em0"、"igb0"、"lo0"等のフォーマットとなる
- EVENTHANDLER_INVOKE(ifnet_arrival_event)とEVENTHANDLER_INVOKE(ifnet_attached_event)の両方の後にdevctl通知が発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | if_var.h | `sys/net/if_var.h` | struct ifnetの定義：if_xnameフィールド |

**読解のコツ**: FreeBSDのネットワークインターフェースは struct ifnet で管理される。if_xnameはインターフェースの外部名（"em0"等）を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | if.c | `sys/net/if.c` | if_attach_internal()関数の末尾付近（行921-925付近） |

**主要処理フロー**:
1. **行921**: EVENTHANDLER_INVOKE(ifnet_arrival_event, ifp)
2. **行922**: if_link_ifnet(ifp)
3. **行923**: EVENTHANDLER_INVOKE(ifnet_attached_event, ifp)
4. **行924-925**: IS_DEFAULT_VNET判定後、devctl_notify("IFNET", ifp->if_xname, "ATTACH", NULL)

### プログラム呼び出し階層図

```
[ネットワークドライバ]
    |
    +-- if_attach() / ether_ifattach() / ...
            |
            +-- if_attach_internal() [sys/net/if.c]
                    |
                    +-- EVENTHANDLER_INVOKE(ifnet_arrival_event)
                    +-- if_link_ifnet()
                    +-- EVENTHANDLER_INVOKE(ifnet_attached_event)
                    +-- devctl_notify("IFNET", ifp->if_xname, "ATTACH", NULL) [行925]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

NICドライバのattach      --->  if_attach_internal()         --->  EVENTHANDLER通知
(struct ifnet)                  |                                   |
                                v                                   v
                          IS_DEFAULT_VNET判定              devctl_notify("IFNET",name,"ATTACH",NULL)
                                                                    |
                                                                    v
                                                              /dev/devctl
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| if.c | `sys/net/if.c` | ソース | if_attach_internal()でATTACH通知を発行 |
| if_var.h | `sys/net/if_var.h` | ヘッダ | struct ifnetの定義 |
| devctl.h | `sys/sys/devctl.h` | ヘッダ | devctl_notify()のプロトタイプ |
| subr_bus.c | `sys/kern/subr_bus.c` | ソース | devctl_notify()の実装 |
