---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-DEV_CREATE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/geom/geom_dev.c` 行346-423（g_dev_taste関数）
- E-02: `sys/geom/geom_dev.c` 行405-406（devctl_notify GEOM DEV CREATE呼出）
- E-03: `sys/geom/geom_dev.c` 行410-420（エイリアスのCREATE通知ループ）
- E-04: `sys/geom/geom_dev.c` 行60-70（g_dev_softc構造体定義）
- E-05: `sys/geom/geom_dev.c` 行384（make_dev_s呼出）
- E-06: `sys/kern/kern_conf.c` 行529-547（notify関数とnotify_create関数）
- E-07: `sys/sys/devctl.h` 行17-18（devctl_notify関数プロトタイプ）
- E-08: `sys/geom/geom_dev.c` 行354（バッファサイズ SPECNAMELEN + 6）
- E-09: `sys/geom/geom_dev.c` 行918（DECLARE_GEOM_CLASS マクロ）
- E-10: `sys/geom/geom_dev.c` 行365-374（g_attach失敗時の処理）
- E-11: `sys/geom/geom_dev.c` 行385-393（make_dev_s失敗時の処理）
- E-12: `sys/kern/kern_conf.c` 行708-761（prep_devname関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | g_dev_taste()がGEOMプロバイダ検出時にcdevを作成する | E-01 | ○ |
| C-02 | devctl_notify("GEOM","DEV","CREATE",buf)で通知が発行される | E-02 | ○ |
| C-03 | エイリアスデバイスにも個別にCREATE通知が発行される | E-03 | ○ |
| C-04 | g_dev_softcがsc_devとsc_aliasフィールドを持つ | E-04 | ○ |
| C-05 | make_dev_s()でcdevが作成される | E-05 | ○ |
| C-06 | kern_conf.cのnotify_create()がDEVFS CDEV CREATE通知を発行する | E-06 | ○ |
| C-07 | devctl_notify()は4引数（system,subsystem,type,data）のインターフェース | E-07 | ○ |
| C-08 | バッファサイズはSPECNAMELEN + 6 | E-08 | ○ |
| C-09 | DEVクラスはDECLARE_GEOM_CLASSマクロで登録される | E-09 | ○ |
| C-10 | g_attach失敗時はNULLを返し通知なし | E-10 | ○ |
| C-11 | make_dev_s失敗時はprintfでログ出力しリソース解放 | E-11 | ○ |
| C-12 | デバイス名にスペースやダブルクォートは拒否される | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいて検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] g_dev_taste()関数の処理フローが設計書の記述と一致するか確認
- [ ] エイリアスデバイスの通知が漏れなく記載されているか確認
- [ ] devctl_notify()の引数が実際のコードと一致するか確認
