---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-IFNET_LINK_STATE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/net/if.c` 行2041-2043（devctl_notify IFNET LINK_UP/LINK_DOWN呼出）
- E-02: `sys/net/if.c` 行2040（IS_DEFAULT_VNET判定）
- E-03: `sys/net/if.c` 行2042（link_state == LINK_STATE_UP三項演算子）
- E-04: `sys/net/if.c` 行2043（data引数がNULL）
- E-05: `sys/net/if.c` 行2041（ifp->if_xnameがsubsystem引数）
- E-06: `sys/net/if.c` 行2036（bridge_linkstate通知）
- E-07: `sys/net/if.c` 行2037-2038（lagg_linkstate通知）
- E-08: `sys/net/if.c` 行2044-2045（pendingカウンタのコアレッシングログ）
- E-09: `sys/net/if.c` 行2042（"LINK_UP"と"LINK_DOWN"の2値）
- E-10: `sys/net/if.c` 行2046-2047（log_link_state_change判定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | if_link_state_change_1()でLINK_UP/LINK_DOWN通知が発行される | E-01 | ○ |
| C-02 | IS_DEFAULT_VNET判定でデフォルトVNETのみ通知 | E-02 | ○ |
| C-03 | link_state == LINK_STATE_UPの場合"LINK_UP"、それ以外"LINK_DOWN" | E-03 | ○ |
| C-04 | data引数はNULL | E-04 | ○ |
| C-05 | インターフェース名はifp->if_xnameから取得される | E-05 | ○ |
| C-06 | bridge_linkstateへの通知がdevctl通知の前に行われる | E-06 | ○ |
| C-07 | lagg_linkstateへの通知がdevctl通知の前に行われる | E-07 | ○ |
| C-08 | pending > 1の場合にコアレッシングのログが出力される | E-08 | ○ |
| C-09 | typeは"LINK_UP"または"LINK_DOWN"の2値 | E-09 | ○ |
| C-10 | LINK_STATE_UNKNOWNも"LINK_DOWN"として通知される | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] if_link_state_change_1()内のdevctl_notify呼出の条件分岐を確認
- [ ] LINK_STATE_UPとそれ以外の判定ロジックを確認
- [ ] コアレッシング処理の影響を確認
