---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：12-ルート変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **rt_addrmsg()の呼び出し元の網羅性**：どのioctlやカーネル処理からrt_addrmsg()が呼ばれるかの完全な一覧が根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/net/route.c` 611-651行目 - rt_addrmsg()関数の実装
- E-02: `sys/net/route.c` 632-633行目 - IPv4 devctl_notify呼び出し
- E-03: `sys/net/route.c` 643-644行目 - IPv6 devctl_notify呼び出し
- E-04: `sys/net/route.c` 618-621行目 - cmdバリデーション（KASSERT）
- E-05: `sys/net/route.c` 623行目 - EVENTHANDLER_DIRECT_INVOKE
- E-06: `sys/net/route.c` 630-631行目 - inet_ntoa_rによるアドレス文字列化
- E-07: `sys/net/route.c` 641行目 - ip6_sprintfによるIPv6アドレス文字列化
- E-08: `sys/net/route.c` 648-650行目 - V_rt_add_addr_allfibs判定とrtsock_addrmsg

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("IFNET", if_xname, "ADDR_ADD"/"ADDR_DEL", ...)として通知される | E-02, E-03 | ○ |
| C-02 | AF_INETの場合inet_ntoa_rでアドレス文字列化される | E-06 | ○ |
| C-03 | AF_INET6の場合ip6_sprintfでアドレス文字列化される | E-07 | ○ |
| C-04 | RTM_ADDまたはRTM_DELETEのみが有効なcmd | E-04 | ○ |
| C-05 | EVENTHANDLER_DIRECT_INVOKEがdevctl_notifyの前に呼ばれる | E-05 | ○ |
| C-06 | 非INET/INET6ファミリの場合devctl通知は発行されない | E-01 | ○ |
| C-07 | rt_addrmsg()は611行目に定義されている | E-01 | ○ |
| C-08 | データフォーマットは"address=%s" | E-06 | ○ |
| C-09 | V_rt_add_addr_allfibs設定が全FIB通知を制御する | E-08 | ○ |
| C-10 | SIOCAIFADDR等のioctlがrt_addrmsg()のトリガーとなる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-10のrt_addrmsg()呼び出し元について、直接の呼び出し元チェーンを完全にトレースしていない
  - 候補：sys/netinet/in.c / sys/netinet6/in6.c / その他のアドレス設定関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - devctl_notifyの引数とフォーマットはコードから直接確認済み
- 1: 中リスク - rt_addrmsg()の呼び出し元の網羅性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify()の引数がコードと一致しているか確認
- [ ] rt_addrmsg()の呼び出し元を網羅的に確認
- [ ] 通知一覧の「ルート変更」という名称と実際のADDR_ADD/ADDR_DEL通知の対応が適切か確認
