---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-IFATTACH

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/net/if_infiniband.c` 660-701行目付近 - infiniband_ifattach()関数の実装
- E-02: `sys/net/if_infiniband.c` 700行目 - devctl_notify()呼び出し
- E-03: `sys/net/if_infiniband.c` 699行目 - IS_DEFAULT_VNETチェック
- E-04: `sys/net/if_infiniband.c` 697行目 - EVENTHANDLER_INVOKE
- E-05: `sys/net/if_infiniband.c` 674行目 - sdl_type = IFT_INFINIBAND
- E-06: `sys/net/if_infiniband.c` 687行目 - bpfattach(DLT_EN10MB)
- E-07: `sys/net/if_infiniband.c` 666-667行目 - デフォルトボーレート設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("INFINIBAND", if_xname, "IFATTACH", NULL)として通知される | E-02 | ○ |
| C-02 | IS_DEFAULT_VNET(curvnet)がtrueの場合のみ通知される | E-03 | ○ |
| C-03 | EVENTHANDLER_INVOKEがdevctl_notifyの前に呼ばれる | E-04, E-02 | ○ |
| C-04 | sockaddr_dlのsdl_typeにIFT_INFINIBANDが設定される | E-05 | ○ |
| C-05 | bpfattachではDLT_EN10MB互換としてアタッチされる | E-06 | ○ |
| C-06 | デフォルトボーレートは10Gbps | E-07 | ○ |
| C-07 | InfiniBandアドレスは20バイト長 | E-01 | ○ |
| C-08 | 通知データはNULL | E-02 | ○ |
| C-09 | devctl_notifyは700行目で呼び出される | E-02 | ○ |
| C-10 | EVENTHANDLER_INVOKEは697行目で発行される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの直接的な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify()の引数がコードと一致しているか確認
- [ ] InfiniBandアドレス長（20バイト）の記述が正確か確認
