---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-状態変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/netinet/ip_carp.c` 2605-2624行目 - carp_set_state()関数の実装
- E-02: `sys/netinet/ip_carp.c` 2622行目 - devctl_notify()呼び出し
- E-03: `sys/netinet/ip_carp.c` 2610行目 - 状態比較条件
- E-04: `sys/netinet/ip_carp.c` 2614-2615行目 - subsys文字列生成
- E-05: `sys/netinet/ip_carp.c` 2611行目 - carp_states配列宣言
- E-06: `sys/netinet/ip_carp.h` 171行目 - CARP_STATES定義
- E-07: `sys/netinet/ip_carp.c` 95-100行目 - carp_softc構造体定義
- E-08: `sys/netinet/ip_carp.c` 2608行目 - CARP_LOCK_ASSERT
- E-09: `sys/netinet/ip_carp.c` 2620行目 - sc_state更新

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("CARP", subsys, carp_states[state], NULL)として通知される | E-02 | ○ |
| C-02 | サブシステム名は"{vhid}@{if_name}"形式 | E-04 | ○ |
| C-03 | 状態が同一の場合は通知されない | E-03 | ○ |
| C-04 | CARP状態は"INIT", "BACKUP", "MASTER"の3種類 | E-06 | ○ |
| C-05 | carp_set_state()は2605行目に定義されている | E-01 | ○ |
| C-06 | devctl_notifyは2622行目で呼び出される | E-02 | ○ |
| C-07 | CARP_LOCK_ASSERTでロック保持が確認される | E-08 | ○ |
| C-08 | sc_stateが新しい状態に更新される | E-09 | ○ |
| C-09 | carp_softc構造体にsc_vhid、sc_state、sc_carpdevが含まれる | E-07 | ○ |
| C-10 | 通知データはNULL | E-02 | ○ |
| C-11 | CARP_MAXVHIDは255 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの直接的な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify()の引数がコードと一致しているか確認
- [ ] carp_set_state()の呼び出し元が網羅的に記述されているか確認
- [ ] CARP状態遷移のすべてのパスが文書化されているか確認
