---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：18-汎用ACPI通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **acpi_UserNotify()の呼び出し元の網羅性**：すべてのACPIドライバからの呼び出しを完全にリストアップできていない

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/acpica/acpi.c` 4561-4579行目 - acpi_UserNotify()関数の実装
- E-02: `sys/dev/acpica/acpi.c` 4577行目 - devctl_notify()呼び出し
- E-03: `sys/dev/acpica/acpi.c` 4568行目 - subsystem NULLチェック
- E-04: `sys/dev/acpica/acpi.c` 4573行目 - AcpiNsHandleToPathname()呼び出し
- E-05: `sys/dev/acpica/acpi.c` 4574-4575行目 - ACPI_FAILUREチェック
- E-06: `sys/dev/acpica/acpi.c` 4576行目 - notify_buf生成（"notify=0x%02x"）
- E-07: `sys/dev/acpica/acpi.c` 4578行目 - AcpiOsFree()によるメモリ解放
- E-08: `sys/dev/acpica/acpi.c` 4560行目 - 関数コメント "Inform devctl(4) when we receive a Notify."

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("ACPI", subsystem, handle_buf.Pointer, notify_buf)として通知される | E-02 | ○ |
| C-02 | subsystemがNULLの場合は即リターン | E-03 | ○ |
| C-03 | AcpiNsHandleToPathnameでパス名に変換 | E-04 | ○ |
| C-04 | パス名変換失敗時は通知を発行しない | E-05 | ○ |
| C-05 | notify_bufは"notify=0x%02x"フォーマット | E-06 | ○ |
| C-06 | AcpiOsFreeでメモリ解放 | E-07 | ○ |
| C-07 | acpi_UserNotify()は4561行目に定義されている | E-01 | ○ |
| C-08 | handle_bufにACPI_ALLOCATE_BUFFERが設定される | E-01 | ○ |
| C-09 | 関数の目的はdevctl(4)への通知 | E-08 | ○ |
| C-10 | notify_bufは16バイトの固定サイズ | E-01 | ○ |
| C-11 | 多くのACPIドライバ（acpi_button, acpi_lid等）から呼ばれる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11: acpi_UserNotify()の呼び出し元について、grepで全呼び出し元を網羅的に確認する必要がある
  - 候補：sys/dev/acpica/acpi_button.c / acpi_lid.c / acpi_thermal.c 等

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - devctl_notifyの引数とフォーマットはコードから直接確認済み
- 1: 中リスク - 呼び出し元の網羅性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify()の引数がコードと一致しているか確認
- [ ] acpi_UserNotify()の呼び出し元一覧が正確か確認
- [ ] AcpiNsHandleToPathname()の出力フォーマットが正確に記述されているか確認
